/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class IoWriterUtils {
    public static void writeByteArrary(OutputStream outputStream, byte[] byArray) {
        outputStream.write(byArray);
    }

    public static void writeIntegerValue(OutputStream outputStream, int n2) {
        outputStream.write(n2 & 0xFF);
        outputStream.write(n2 >>> 8 & 0xFF);
        outputStream.write(n2 >>> 16 & 0xFF);
        outputStream.write(n2 >>> 24);
    }

    public static void writeLongValue(OutputStream outputStream, long l2) {
        outputStream.write((int)(l2 & 0xFFL));
        outputStream.write((int)(l2 >>> 8 & 0xFFL));
        outputStream.write((int)(l2 >>> 16 & 0xFFL));
        outputStream.write((int)(l2 >>> 24 & 0xFFL));
        outputStream.write((int)(l2 >>> 32 & 0xFFL));
        outputStream.write((int)(l2 >>> 40 & 0xFFL));
        outputStream.write((int)(l2 >>> 48 & 0xFFL));
        outputStream.write((int)(l2 >>> 56));
    }

    public static void writeNewZipFile(String string, List<File> list) {
        byte[] byArray = new byte[1024];
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
        for (File file : list) {
            int n2;
            FileInputStream fileInputStream = new FileInputStream(file);
            zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n2);
            }
            zipOutputStream.closeEntry();
            fileInputStream.close();
        }
        zipOutputStream.finish();
        zipOutputStream.close();
    }

    public static void writeShortValue(OutputStream outputStream, int n2) {
        if (n2 > Short.MAX_VALUE) {
            throw new IOException("Value out of range exception.");
        }
        outputStream.write(n2 & 0xFF);
        outputStream.write(n2 >>> 8);
    }

    public static void writeStringValue(OutputStream outputStream, String string) {
        outputStream.write(string.getBytes());
    }
}

