/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.utils;

import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.bindiff.resources.Constants;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.system.IdaHelpers;
import java.io.File;

public class ExternalAppUtils {
    public static String getCommandLineDiffer() {
        String string = BinDiffConfig.getInstance().getMainSettings().getDiffEnginePath();
        if (string == null || string.isEmpty()) {
            string = FileUtils.findLocalRootPath(ExternalAppUtils.class);
        }
        return FileUtils.ensureTrailingSlash(string) + Constants.BINDIFF_ENGINE_EXECUTABLE;
    }

    public static File getIdaExe(File file) {
        String string = FileUtils.getFileExtension(file);
        GeneralSettingsConfigItem generalSettingsConfigItem = BinDiffConfig.getInstance().getMainSettings();
        if (string.equalsIgnoreCase("idb")) {
            return new File(generalSettingsConfigItem.getIdaDirectory() + File.separatorChar + IdaHelpers.IDA32_EXECUTABLE);
        }
        if (string.equalsIgnoreCase("i64")) {
            return new File(generalSettingsConfigItem.getIdaDirectory() + File.separatorChar + IdaHelpers.IDA64_EXECUTABLE);
        }
        return null;
    }
}

