/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class BinDiffFileUtils {
    private BinDiffFileUtils() {
    }

    public static void deleteDirectory(File file) {
        if (file == null || !file.isDirectory() || !file.exists()) {
            return;
        }
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static List<String> findFiles(File file, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file == null || !file.isDirectory() || !file.exists()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                arrayList.addAll(BinDiffFileUtils.findFiles(file2, list));
            }
            for (String string : list) {
                String string2 = "." + string;
                if (!file2.getPath().endsWith(string2)) continue;
                arrayList.add(file2.getPath());
            }
        }
        return arrayList;
    }

    public static String forceFilenameEndsNotWithExtension(String string, String string2) {
        String string3 = string;
        if (string3.toLowerCase().endsWith(("." + string2).toLowerCase())) {
            string3 = string.substring(0, string.length() - ("." + string2).length());
        }
        return string3;
    }

    public static String forceFilenameEndsWithExtension(String string, String string2) {
        if (string.toLowerCase().endsWith(("." + string2).toLowerCase())) {
            return string;
        }
        return string + "." + string2;
    }

    public static String forceFileSeparator(String string) {
        return string.replace(File.separator.equals("/") ? "\\" : "/", File.separator);
    }

    public static String removeFileExtension(String string) {
        int n2 = string.lastIndexOf(".");
        return n2 < 1 ? string : string.substring(0, n2);
    }
}

