/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.project.matches.IAddressPair;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Matches<Match extends IAddressPair> {
    private final Table<Long, Long, Match> store = HashBasedTable.create();

    public Matches(List<Match> list) {
        for (IAddressPair iAddressPair : Preconditions.checkNotNull(list)) {
            this.put(iAddressPair);
        }
    }

    public void put(Match Match) {
        if (this.store.put(Match.getAddress(ESide.PRIMARY), Match.getAddress(ESide.SECONDARY), Match) != null) {
            throw new IllegalArgumentException("Attempt to insert duplicate basic block match");
        }
    }

    public Match remove(IAddress iAddress, IAddress iAddress2) {
        return (Match)((IAddressPair)this.store.remove(iAddress.toLong(), iAddress2.toLong()));
    }

    public void clear() {
        this.store.clear();
    }

    public int size() {
        return this.store.size();
    }

    public Match get(IAddress iAddress, ESide eSide) {
        if (iAddress == null) {
            return null;
        }
        long l2 = iAddress.toLong();
        Map<Long, Match> map = ESide.PRIMARY.equals((Object)eSide) ? this.store.row(l2) : this.store.column(l2);
        Collection<Match> collection = map.values();
        return (Match)(!collection.isEmpty() ? (IAddressPair)collection.iterator().next() : null);
    }

    public Collection<Match> getMatches() {
        return Collections.unmodifiableCollection(this.store.values());
    }
}

