/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.types;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.project.matches.AddressPairComparator;
import com.google.security.zynamics.bindiff.project.matches.IAddressPair;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AddressBimap {
    private long[] primarySortedValues;
    private long[] secondaryAssignedValues;
    private long[] secondarySortedValues;
    private long[] primaryAssignedValues;

    public AddressBimap(List<IAddressPair> list) {
        Preconditions.checkNotNull(list);
        int n2 = list.size();
        this.primarySortedValues = new long[n2];
        this.secondaryAssignedValues = new long[n2];
        Collections.sort(list, new AddressPairComparator(ESide.PRIMARY));
        int n3 = 0;
        for (IAddressPair iAddressPair : list) {
            this.primarySortedValues[n3] = iAddressPair.getAddress(ESide.PRIMARY);
            this.secondaryAssignedValues[n3] = iAddressPair.getAddress(ESide.SECONDARY);
            ++n3;
        }
        this.secondarySortedValues = new long[n2];
        this.primaryAssignedValues = new long[n2];
        Collections.sort(list, new AddressPairComparator(ESide.SECONDARY));
        n3 = 0;
        for (IAddressPair iAddressPair : list) {
            this.primaryAssignedValues[n3] = iAddressPair.getAddress(ESide.PRIMARY);
            this.secondarySortedValues[n3] = iAddressPair.getAddress(ESide.SECONDARY);
            ++n3;
        }
    }

    private Long getPrimaryAddress(long l2) {
        int n2 = this.getIndex(l2, ESide.SECONDARY);
        return n2 >= 0 ? Long.valueOf(this.primaryAssignedValues[n2]) : null;
    }

    private Long getSecondaryAddress(long l2) {
        int n2 = this.getIndex(l2, ESide.PRIMARY);
        return n2 >= 0 ? Long.valueOf(this.secondaryAssignedValues[n2]) : null;
    }

    public boolean contains(IAddress iAddress, ESide eSide) {
        return this.getIndex(iAddress.toLong(), eSide) >= 0;
    }

    public boolean contains(IAddress iAddress, IAddress iAddress2) {
        if (iAddress == null || iAddress2 == null) {
            return false;
        }
        int n2 = this.getIndex(iAddress, ESide.PRIMARY);
        if (n2 >= 0) {
            return this.primarySortedValues[n2] == iAddress.toLong() && this.secondaryAssignedValues[n2] == iAddress2.toLong();
        }
        return false;
    }

    public int getIndex(IAddress iAddress, ESide eSide) {
        return iAddress != null ? this.getIndex(iAddress.toLong(), eSide) : -1;
    }

    public int getIndex(long l2, ESide eSide) {
        return eSide == ESide.PRIMARY ? Arrays.binarySearch(this.primarySortedValues, l2) : Arrays.binarySearch(this.secondarySortedValues, l2);
    }

    public IAddress getPrimaryAddress(IAddress iAddress) {
        Long l2 = this.getPrimaryAddress(iAddress.toLong());
        return l2 != null ? new CAddress(l2) : null;
    }

    public IAddress getSecondaryAddress(IAddress iAddress) {
        Long l2 = this.getSecondaryAddress(iAddress.toLong());
        return l2 != null ? new CAddress(l2) : null;
    }

    public boolean remove(IAddress iAddress, IAddress iAddress2) {
        int n2 = this.getIndex(iAddress, ESide.PRIMARY);
        int n3 = this.getIndex(iAddress2, ESide.SECONDARY);
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        int n4 = this.primarySortedValues.length;
        long[] lArray = new long[n4 - 1];
        long[] lArray2 = new long[n4 - 1];
        long[] lArray3 = new long[n4 - 1];
        long[] lArray4 = new long[n4 - 1];
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (i2 != n2) {
                lArray[n5] = this.primarySortedValues[i2];
                lArray2[n5] = this.secondaryAssignedValues[i2];
                ++n5;
            }
            if (i2 == n3) continue;
            lArray3[n6] = this.secondarySortedValues[i2];
            lArray4[n6] = this.primaryAssignedValues[i2];
            ++n6;
        }
        this.primarySortedValues = lArray;
        this.secondaryAssignedValues = lArray2;
        this.secondarySortedValues = lArray3;
        this.primaryAssignedValues = lArray4;
        return true;
    }
}

