/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.socketserver;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.io.matches.DiffRequestMessage;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class SocketServer {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final int port;
    private ServerSocket socket;
    private final WorkspaceTabPanelFunctions controller;

    public SocketServer(int n2, WorkspaceTabPanelFunctions workspaceTabPanelFunctions) {
        this.port = n2;
        this.socket = null;
        this.controller = Preconditions.checkNotNull(workspaceTabPanelFunctions);
    }

    private void handleReceivedByteBuffer(byte[] byArray) {
        logger.at(Level.INFO).log("Received byte stream from socket...");
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            XPath xPath = XPathFactory.newInstance().newXPath();
            DiffRequestMessage diffRequestMessage = new DiffRequestMessage();
            boolean bl2 = "flow_graph".equals(xPath.evaluate("/BinDiffMatch/@type", document));
            diffRequestMessage.setMatchesDBPath(xPath.evaluate("/BinDiffMatch/Database/@path", document));
            diffRequestMessage.setBinExportPath(xPath.evaluate("/BinDiffMatch/Primary/@path", document), ESide.PRIMARY);
            diffRequestMessage.setFunctionAddress(Long.parseUnsignedLong(xPath.evaluate("/BinDiffMatch/Primary/@address", document)), ESide.PRIMARY);
            diffRequestMessage.setBinExportPath(xPath.evaluate("/BinDiffMatch/Secondary/@path", document), ESide.SECONDARY);
            diffRequestMessage.setFunctionAddress(Long.parseUnsignedLong(xPath.evaluate("/BinDiffMatch/Secondary/@address", document)), ESide.SECONDARY);
            if (bl2) {
                this.controller.openFunctionDiffView(diffRequestMessage);
            } else {
                this.controller.openCallGraphDiffView(diffRequestMessage);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        catch (IOException iOException) {
            this.handleError(iOException, "Error reading from socket: " + iOException.getMessage());
        }
        catch (XPathException | SAXException exception) {
            this.handleError(exception, "Failed to parse data from socket: " + exception.getMessage());
        }
    }

    private void handleError(Exception exception, String string) {
        CMessageBox.showError(this.controller.getMainWindow(), string);
        ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log(string);
    }

    public void startListening() {
        logger.at(Level.INFO).log("Starting local command server on port %d...", this.port);
        this.socket = new ServerSocket();
        this.socket.bind(new InetSocketAddress(InetAddress.getByName(null), this.port));
        new SocketListenerThread(this).start();
    }

    ServerSocket getSocket() {
        return this.socket;
    }

    static class SocketListenerThread
    extends Thread {
        private final SocketServer server;

        public SocketListenerThread(SocketServer socketServer) {
            this.server = Preconditions.checkNotNull(socketServer);
        }

        private static byte[] receiveBoundedBytes(InputStream inputStream) {
            int n2 = 4;
            byte[] byArray = new byte[n2];
            if (inputStream.read(byArray, 0, n2) != n2) {
                throw new IOException("Premature end of stream");
            }
            n2 = Math.min(ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt(), 0x100000);
            byte[] byArray2 = new byte[n2];
            if (inputStream.read(byArray2, 0, n2) != n2) {
                throw new IOException("Unexpected end of stream");
            }
            return byArray2;
        }

        @Override
        public void run() {
            while (!SocketListenerThread.interrupted()) {
                try {
                    Socket socket = this.server.getSocket().accept();
                    try {
                        InputStream inputStream = socket.getInputStream();
                        try {
                            this.server.handleReceivedByteBuffer(SocketListenerThread.receiveBoundedBytes(inputStream));
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    finally {
                        if (socket == null) continue;
                        socket.close();
                    }
                }
                catch (IOException | SecurityException exception) {
                    this.server.handleError(exception, exception.getMessage());
                }
            }
        }
    }
}

