/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.userview;

import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.userview.CallGraphViewData;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.project.userview.ViewData;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ViewManager {
    private final Set<ViewData> views = new HashSet<ViewData>();

    public void addView(ViewData viewData) {
        this.views.add(viewData);
    }

    public boolean containsView(IAddress iAddress, IAddress iAddress2) {
        for (ViewData viewData : this.views) {
            if (viewData.isFlowGraphView()) {
                FlowGraphViewData flowGraphViewData = (FlowGraphViewData)viewData;
                boolean bl2 = iAddress == null && flowGraphViewData.getRawGraph(ESide.PRIMARY) == null;
                IAddress iAddress3 = null;
                if (flowGraphViewData.getRawGraph(ESide.PRIMARY) != null) {
                    iAddress3 = flowGraphViewData.getRawGraph(ESide.PRIMARY).getAddress();
                }
                if (iAddress != null && iAddress3 != null) {
                    bl2 = iAddress.equals(iAddress3);
                }
                boolean bl3 = iAddress2 == null && flowGraphViewData.getRawGraph(ESide.SECONDARY) == null;
                IAddress iAddress4 = null;
                if (flowGraphViewData.getRawGraph(ESide.SECONDARY) != null) {
                    iAddress4 = flowGraphViewData.getRawGraph(ESide.SECONDARY).getAddress();
                }
                if (iAddress2 != null && iAddress4 != null) {
                    bl3 = iAddress2.equals(iAddress4);
                }
                if (bl2 && bl3) {
                    return true;
                }
            }
            if (!viewData.isCallGraphView() || viewData.getAddress(ESide.PRIMARY) != null || iAddress != null || viewData.getAddress(ESide.SECONDARY) != null || iAddress2 != null) continue;
            return true;
        }
        return false;
    }

    public CallGraphViewData getCallGraphViewData(Diff diff) {
        for (CallGraphViewData callGraphViewData : this.getCallGraphViewsData()) {
            if (callGraphViewData.getGraphs().getDiff() != diff) continue;
            return callGraphViewData;
        }
        return null;
    }

    public List<CallGraphViewData> getCallGraphViewsData() {
        ArrayList<CallGraphViewData> arrayList = new ArrayList<CallGraphViewData>();
        for (ViewData viewData : this.views) {
            if (!(viewData instanceof CallGraphViewData)) continue;
            arrayList.add((CallGraphViewData)viewData);
        }
        return arrayList;
    }

    public FlowGraphViewData getFlowGraphViewData(IAddress iAddress, IAddress iAddress2) {
        for (ViewData viewData : this.views) {
            if (!viewData.isFlowGraphView() || viewData.getMatchState() != EMatchState.MATCHED) continue;
            FlowGraphViewData flowGraphViewData = (FlowGraphViewData)viewData;
            IAddress iAddress3 = flowGraphViewData.getAddress(ESide.PRIMARY);
            IAddress iAddress4 = flowGraphViewData.getAddress(ESide.SECONDARY);
            if (!iAddress3.equals(iAddress) || !iAddress4.equals(iAddress2)) continue;
            return flowGraphViewData;
        }
        return null;
    }

    public List<FlowGraphViewData> getFlowGraphViewsData() {
        ArrayList<FlowGraphViewData> arrayList = new ArrayList<FlowGraphViewData>();
        for (ViewData viewData : this.views) {
            if (!(viewData instanceof FlowGraphViewData)) continue;
            arrayList.add((FlowGraphViewData)viewData);
        }
        return arrayList;
    }

    public void removeView(ViewData viewData) {
        this.views.remove(viewData);
    }
}

