/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.userview;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.enums.EViewType;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedJump;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.userview.ViewData;
import com.google.security.zynamics.zylib.disassembly.IAddress;

public class FlowGraphViewData
extends ViewData {
    private final RawFlowGraph primaryRawGraph;
    private final RawFlowGraph secondaryRawGraph;
    private final RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> combinedRawFlowgraph;

    public FlowGraphViewData(RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2, RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph, GraphsContainer graphsContainer, String string, EViewType eViewType) {
        super(graphsContainer, string, eViewType);
        Preconditions.checkArgument(rawFlowGraph != null || rawFlowGraph2 != null, "Raw primary and secondary flow graphs cannot both be null");
        this.combinedRawFlowgraph = Preconditions.checkNotNull(rawCombinedFlowGraph);
        this.primaryRawGraph = rawFlowGraph;
        this.secondaryRawGraph = rawFlowGraph2;
    }

    @Override
    public IAddress getAddress(ESide eSide) {
        if (eSide == ESide.PRIMARY) {
            if (this.primaryRawGraph == null) {
                return null;
            }
            return this.primaryRawGraph.getAddress();
        }
        if (this.secondaryRawGraph == null) {
            return null;
        }
        return this.secondaryRawGraph.getAddress();
    }

    public RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> getCombinedRawGraph() {
        return this.combinedRawFlowgraph;
    }

    public String getFunctionName(ESide eSide) {
        if (eSide == ESide.PRIMARY) {
            if (this.primaryRawGraph == null) {
                return null;
            }
            return this.primaryRawGraph.getName();
        }
        if (this.secondaryRawGraph == null) {
            return null;
        }
        return this.secondaryRawGraph.getName();
    }

    public RawFlowGraph getRawGraph(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.primaryRawGraph : this.secondaryRawGraph;
    }

    @Override
    public boolean isCallGraphView() {
        return false;
    }

    public boolean isChangedOnlyInstructions() {
        RawFunction rawFunction = this.getGraphs().getDiff().getCallGraph(ESide.PRIMARY).getFunction(this.getAddress(ESide.PRIMARY));
        return rawFunction != null && rawFunction.isChangedInstructionsOnlyMatch();
    }

    public boolean isChangedStructural() {
        RawFunction rawFunction = this.getGraphs().getDiff().getCallGraph(ESide.PRIMARY).getFunction(this.getAddress(ESide.PRIMARY));
        return rawFunction != null && rawFunction.isChangedStructuralMatch();
    }

    @Override
    public boolean isFlowGraphView() {
        return true;
    }

    public boolean isMatched() {
        RawFunction rawFunction = this.getGraphs().getDiff().getCallGraph(ESide.PRIMARY).getFunction(this.getAddress(ESide.PRIMARY));
        return rawFunction != null && rawFunction.getMatchedFunction() != null;
    }

    public boolean isMatchedIdentical() {
        RawFunction rawFunction = this.getGraphs().getDiff().getCallGraph(ESide.PRIMARY).getFunction(this.getAddress(ESide.PRIMARY));
        return rawFunction != null && rawFunction.isIdenticalMatch();
    }
}

