/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.rawflowgraph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstructionComment;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import java.util.List;

public class RawInstruction {
    private final IAddress address;
    private final String mnemonic;
    private final int maxMnemonicLen;
    private final byte[] taggedOperandDisassembly;
    private final long[] callTargetAddresses;
    private List<RawInstructionComment> comments;

    public RawInstruction(IAddress iAddress, String string, int n2, byte[] byArray, long[] lArray, List<RawInstructionComment> list) {
        this.address = Preconditions.checkNotNull(iAddress);
        this.mnemonic = Preconditions.checkNotNull(string);
        this.maxMnemonicLen = n2;
        this.taggedOperandDisassembly = Preconditions.checkNotNull(byArray);
        this.callTargetAddresses = Preconditions.checkNotNull(lArray);
        this.comments = list;
    }

    public IAddress getAddress() {
        return this.address;
    }

    public long[] getCallTargetAddresses() {
        return this.callTargetAddresses;
    }

    public List<RawInstructionComment> getComments() {
        return this.comments;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public int getMaxMnemonicLen() {
        return this.maxMnemonicLen;
    }

    public int getOperandLength() {
        int n2 = 0;
        for (byte by2 : this.taggedOperandDisassembly) {
            if (by2 <= 15) continue;
            ++n2;
        }
        return n2;
    }

    public byte[] getOperands() {
        return this.taggedOperandDisassembly;
    }

    public boolean hasComments() {
        return this.comments != null && this.comments.size() > 0;
    }

    public boolean isCall() {
        return this.callTargetAddresses.length > 0;
    }

    public void setComment(String string, ECommentPlacement eCommentPlacement) {
        if (this.comments != null) {
            for (RawInstructionComment rawInstructionComment : this.comments) {
                if (rawInstructionComment.getPlacement() != eCommentPlacement) continue;
                rawInstructionComment.setText(string);
                if ("".equals(rawInstructionComment.getText())) {
                    this.comments.remove(rawInstructionComment);
                    if (this.comments.size() == 0) {
                        this.comments = null;
                    }
                }
                return;
            }
        } else if (!"".equals(string)) {
            this.comments.clear();
            RawInstructionComment rawInstructionComment = new RawInstructionComment(string, eCommentPlacement);
            this.comments.add(rawInstructionComment);
        }
    }
}

