/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.rawflowgraph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EFunctionType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.edges.SingleViewEdge;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.project.matches.AddressPair;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawJump;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RawFlowGraph
extends MutableDirectedGraph<RawBasicBlock, RawJump> {
    private final IAddress address;
    private final String name;
    private final EFunctionType functionType;
    private final ESide side;
    private final Map<IAddress, RawBasicBlock> addrToBasicblockMap = new HashMap<IAddress, RawBasicBlock>();
    private final Map<AddressPair, RawJump> addrPairToJumpMap = new HashMap<AddressPair, RawJump>();

    public RawFlowGraph(IAddress iAddress, String string, EFunctionType eFunctionType, List<RawBasicBlock> list, List<RawJump> list2, ESide eSide) {
        super(list, list2);
        this.address = Preconditions.checkNotNull(iAddress);
        this.name = Preconditions.checkNotNull(string);
        this.functionType = Preconditions.checkNotNull(eFunctionType);
        this.side = Preconditions.checkNotNull(eSide);
        for (RawBasicBlock object : list) {
            this.addrToBasicblockMap.put(object.getAddress(), object);
        }
        for (RawJump rawJump : list2) {
            long l2 = rawJump.getSource().getAddress().toLong();
            long l3 = rawJump.getTarget().getAddress().toLong();
            this.addrPairToJumpMap.put(new AddressPair(l2, l3), rawJump);
        }
    }

    private void removeFromMap(SingleViewEdge<? extends SingleViewNode> singleViewEdge) {
        IAddress iAddress = ((SingleViewNode)singleViewEdge.getSource()).getAddress();
        IAddress iAddress2 = ((SingleViewNode)singleViewEdge.getTarget()).getAddress();
        AddressPair addressPair = new AddressPair(iAddress.toLong(), iAddress2.toLong());
        this.addrPairToJumpMap.remove(addressPair);
    }

    @Override
    public void addEdge(RawJump rawJump) {
        AddressPair addressPair = new AddressPair(rawJump.getSource().getAddress().toLong(), rawJump.getTarget().getAddress().toLong());
        this.addrPairToJumpMap.put(addressPair, rawJump);
        super.addEdge(rawJump);
    }

    @Override
    public void addNode(RawBasicBlock rawBasicBlock) {
        this.addrToBasicblockMap.put(rawBasicBlock.getAddress(), rawBasicBlock);
        super.addNode(rawBasicBlock);
    }

    public IAddress getAddress() {
        return this.address;
    }

    public RawBasicBlock getBasicblock(IAddress iAddress) {
        return this.addrToBasicblockMap.get(iAddress);
    }

    public EFunctionType getFunctionType() {
        return this.functionType;
    }

    public RawJump getJump(IAddress iAddress, IAddress iAddress2) {
        if (iAddress == null || iAddress2 == null) {
            return null;
        }
        return this.addrPairToJumpMap.get(new AddressPair(iAddress.toLong(), iAddress2.toLong()));
    }

    public String getName() {
        return this.name;
    }

    public ESide getSide() {
        return this.side;
    }

    @Override
    public void removeNode(RawBasicBlock rawBasicBlock) {
        this.addrToBasicblockMap.remove(rawBasicBlock.getAddress());
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawBasicBlock.getIncomingEdges()) {
            SingleViewNode.unlink((SingleViewNode)singleViewEdge.getSource(), (SingleViewNode)singleViewEdge.getTarget());
            ((SingleViewNode)singleViewEdge.getSource()).removeOutgoingEdge(singleViewEdge);
            ((SingleViewNode)singleViewEdge.getTarget()).removeIncomingEdge(singleViewEdge);
            this.removeFromMap(singleViewEdge);
        }
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawBasicBlock.getOutgoingEdges()) {
            SingleViewNode.unlink((SingleViewNode)singleViewEdge.getSource(), (SingleViewNode)singleViewEdge.getTarget());
            ((SingleViewNode)singleViewEdge.getSource()).removeOutgoingEdge(singleViewEdge);
            ((SingleViewNode)singleViewEdge.getTarget()).removeIncomingEdge(singleViewEdge);
            this.removeFromMap(singleViewEdge);
        }
        super.removeNode(rawBasicBlock);
    }
}

