/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.rawflowgraph;

import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.graph.edges.CombinedViewEdge;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedJump;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import java.util.List;

public class RawCombinedFlowGraph<NodeType extends RawCombinedBasicBlock, EdgeType extends RawCombinedJump<NodeType>>
extends MutableDirectedGraph<NodeType, EdgeType> {
    private final RawFlowGraph primaryFlowgraph;
    private final RawFlowGraph secondaryFlowgraph;

    public RawCombinedFlowGraph(List<NodeType> list, List<EdgeType> list2, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2) {
        super(list, list2);
        if (rawFlowGraph == null && rawFlowGraph2 == null) {
            throw new IllegalArgumentException("Primary and secondary flow graphs cannot both be null.");
        }
        this.primaryFlowgraph = rawFlowGraph;
        this.secondaryFlowgraph = rawFlowGraph2;
    }

    public EMatchState getMatchState() {
        if (this.secondaryFlowgraph == null) {
            return EMatchState.PRIMARY_UNMATCHED;
        }
        if (this.primaryFlowgraph == null) {
            return EMatchState.SECONDRAY_UNMATCHED;
        }
        return EMatchState.MATCHED;
    }

    public IAddress getPrimaryAddress() {
        if (this.primaryFlowgraph == null) {
            return null;
        }
        return this.primaryFlowgraph.getAddress();
    }

    public RawFlowGraph getPrimaryFlowgraph() {
        return this.primaryFlowgraph;
    }

    public String getPrimaryName() {
        if (this.primaryFlowgraph == null) {
            return "";
        }
        return this.primaryFlowgraph.getName();
    }

    public IAddress getSecondaryAddress() {
        if (this.secondaryFlowgraph == null) {
            return null;
        }
        return this.secondaryFlowgraph.getAddress();
    }

    public RawFlowGraph getSecondaryFlowgraph() {
        return this.secondaryFlowgraph;
    }

    public String getSecondaryName() {
        if (this.secondaryFlowgraph == null) {
            return "";
        }
        return this.secondaryFlowgraph.getName();
    }

    @Override
    public void removeNode(NodeType NodeType2) {
        for (CombinedViewEdge<? extends CombinedViewNode> combinedViewEdge : ((CombinedViewNode)NodeType2).getIncomingEdges()) {
            CombinedViewNode.unlink((CombinedViewNode)combinedViewEdge.getSource(), (CombinedViewNode)combinedViewEdge.getTarget());
            ((CombinedViewNode)combinedViewEdge.getSource()).removeOutgoingEdge(combinedViewEdge);
            ((CombinedViewNode)combinedViewEdge.getTarget()).removeIncomingEdge(combinedViewEdge);
        }
        for (CombinedViewEdge<? extends CombinedViewNode> combinedViewEdge : ((CombinedViewNode)NodeType2).getOutgoingEdges()) {
            CombinedViewNode.unlink((CombinedViewNode)combinedViewEdge.getSource(), (CombinedViewNode)combinedViewEdge.getTarget());
            ((CombinedViewNode)combinedViewEdge.getTarget()).removeIncomingEdge(combinedViewEdge);
            ((CombinedViewNode)combinedViewEdge.getSource()).removeOutgoingEdge(combinedViewEdge);
        }
        super.removeNode(NodeType2);
    }
}

