/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.rawcallgraph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EFunctionType;
import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RawFunction
extends SingleViewNode {
    private final String name;
    private final EFunctionType type;
    private final ESide side;
    private FunctionMatchData match = null;
    private RawFunction matchedFunction = null;
    private int basicBlocks = -1;
    private int jumps = -1;
    private int instructions = -1;
    private String comment = "";

    public RawFunction(IAddress iAddress, String string, EFunctionType eFunctionType, ESide eSide) {
        super(iAddress, -1, 0.0, 0.0, Color.WHITE, Color.BLACK, false, true);
        this.name = Preconditions.checkNotNull(string);
        this.type = Preconditions.checkNotNull(eFunctionType);
        this.side = Preconditions.checkNotNull(eSide);
    }

    public Set<RawFunction> getCallees() {
        List<SingleViewNode> list = this.getChildren();
        HashSet<RawFunction> hashSet = new HashSet<RawFunction>();
        for (SingleViewNode singleViewNode : list) {
            hashSet.add((RawFunction)singleViewNode);
        }
        return hashSet;
    }

    public Set<RawFunction> getCallers() {
        List<SingleViewNode> list = this.getParents();
        HashSet<RawFunction> hashSet = new HashSet<RawFunction>();
        for (SingleViewNode singleViewNode : list) {
            hashSet.add((RawFunction)singleViewNode);
        }
        return hashSet;
    }

    public String getComment() {
        return this.comment;
    }

    public FunctionMatchData getFunctionMatch() {
        return this.match;
    }

    public EFunctionType getFunctionType() {
        return this.type;
    }

    public FunctionMatchData getMatch() {
        return this.match;
    }

    public RawFunction getMatchedFunction() {
        return this.matchedFunction;
    }

    public IAddress getMatchedFunctionAddress() {
        if (this.getMatchState() == EMatchState.MATCHED) {
            return this.match.getIAddress(this.side == ESide.PRIMARY ? ESide.SECONDARY : ESide.PRIMARY);
        }
        return null;
    }

    @Override
    public EMatchState getMatchState() {
        if (this.match == null) {
            return this.side == ESide.PRIMARY ? EMatchState.PRIMARY_UNMATCHED : EMatchState.SECONDRAY_UNMATCHED;
        }
        return EMatchState.MATCHED;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ESide getSide() {
        return this.side;
    }

    public int getSizeOfBasicBlocks() {
        return this.basicBlocks;
    }

    public int getSizeOfInstructions() {
        return this.instructions;
    }

    public int getSizeOfJumps() {
        return this.jumps;
    }

    public int getSizeOfMatchedBasicBlocks() {
        return this.match == null ? 0 : this.match.getSizeOfMatchedBasicBlocks();
    }

    public int getSizeOfMatchedInstructions() {
        return this.match == null ? 0 : this.match.getSizeOfMatchedInstructions();
    }

    public int getSizeOfMatchedJumps() {
        return this.match == null ? 0 : this.match.getSizeOfMatchedJumps();
    }

    public int getSizeOfUnmatchedBasicBlocks() {
        return this.basicBlocks - this.match.getSizeOfMatchedBasicBlocks();
    }

    public int getSizeOfUnmatchedInstructions() {
        return this.instructions - this.match.getSizeOfMatchedInstructions();
    }

    public int getSizeOfUnmatchedJumps() {
        return this.jumps - this.match.getSizeOfMatchedJumps();
    }

    public boolean isChanged() {
        if (this.getMatchState() == EMatchState.MATCHED) {
            boolean bl2 = this.basicBlocks == this.matchedFunction.getSizeOfBasicBlocks() && this.basicBlocks == this.getSizeOfMatchedBasicBlocks();
            boolean bl3 = this.jumps == this.matchedFunction.getSizeOfJumps() && this.jumps == this.getSizeOfMatchedJumps();
            boolean bl4 = this.instructions == this.matchedFunction.getSizeOfInstructions() && this.instructions == this.getSizeOfMatchedInstructions();
            return !bl2 || !bl3 || !bl4;
        }
        return false;
    }

    public boolean isChangedInstructionsOnlyMatch() {
        if (this.getMatchState() == EMatchState.MATCHED) {
            boolean bl2 = this.basicBlocks == this.matchedFunction.getSizeOfBasicBlocks() && this.basicBlocks == this.getSizeOfMatchedBasicBlocks();
            boolean bl3 = this.jumps == this.matchedFunction.getSizeOfJumps() && this.jumps == this.getSizeOfMatchedJumps();
            boolean bl4 = this.instructions == this.matchedFunction.getSizeOfInstructions() && this.instructions == this.getSizeOfMatchedInstructions();
            return bl2 && bl3 && !bl4;
        }
        return false;
    }

    public boolean isChangedStructuralMatch() {
        if (this.getMatchState() == EMatchState.MATCHED) {
            boolean bl2 = this.basicBlocks == this.matchedFunction.getSizeOfBasicBlocks() && this.basicBlocks == this.getSizeOfMatchedBasicBlocks();
            boolean bl3 = this.jumps == this.matchedFunction.getSizeOfJumps() && this.jumps == this.getSizeOfMatchedJumps();
            return !bl2 || !bl3;
        }
        return false;
    }

    public boolean isIdenticalMatch() {
        if (this.getMatchState() == EMatchState.MATCHED) {
            boolean bl2 = this.basicBlocks == this.matchedFunction.getSizeOfBasicBlocks() && this.basicBlocks == this.getSizeOfMatchedBasicBlocks();
            boolean bl3 = this.jumps == this.matchedFunction.getSizeOfJumps() && this.jumps == this.getSizeOfMatchedJumps();
            boolean bl4 = this.instructions == this.matchedFunction.getSizeOfInstructions() && this.instructions == this.getSizeOfMatchedInstructions();
            return bl2 && bl3 && bl4;
        }
        return false;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setMatch(RawFunction rawFunction, FunctionMatchData functionMatchData) {
        this.matchedFunction = rawFunction;
        this.match = functionMatchData;
    }

    public void setSizeOfBasicBlocks(int n2) {
        this.basicBlocks = n2;
    }

    public void setSizeOfInstructions(int n2) {
        this.instructions = n2;
    }

    public void setSizeOfJumps(int n2) {
        this.jumps = n2;
    }
}

