/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.rawcallgraph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EFunctionType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.zylib.disassembly.IAddress;

public class RawCombinedFunction
extends CombinedViewNode {
    private final RawFunction primaryFunction;
    private final RawFunction secondaryFunction;

    public RawCombinedFunction(RawFunction rawFunction, RawFunction rawFunction2) {
        Preconditions.checkArgument(rawFunction != null || rawFunction2 != null, "Primary function and seconday function cannot both be null");
        this.primaryFunction = rawFunction;
        this.secondaryFunction = rawFunction2;
    }

    @Override
    public IAddress getAddress(ESide eSide) {
        if (this.getRawNode(eSide) == null) {
            return null;
        }
        return this.getRawNode(eSide).getAddress();
    }

    public EFunctionType getFunctionType() {
        if (this.primaryFunction == null) {
            return this.secondaryFunction.getFunctionType();
        }
        if (this.secondaryFunction == null) {
            return this.primaryFunction.getFunctionType();
        }
        if (this.primaryFunction.getFunctionType() == this.secondaryFunction.getFunctionType()) {
            return this.primaryFunction.getFunctionType();
        }
        return EFunctionType.MIXED;
    }

    @Override
    public RawFunction getRawNode(ESide eSide) {
        if (eSide == ESide.PRIMARY) {
            return this.primaryFunction;
        }
        return this.secondaryFunction;
    }

    public boolean isChanged() {
        if (this.primaryFunction != null && this.secondaryFunction != null) {
            return this.primaryFunction.isChanged();
        }
        return false;
    }
}

