/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.rawcallgraph;

import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.graph.edges.CombinedViewEdge;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCall;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedFunction;

public class RawCombinedCall
extends CombinedViewEdge<RawCombinedFunction> {
    private final RawCall primaryCall;
    private final RawCall secondaryCall;

    public RawCombinedCall(RawCombinedFunction rawCombinedFunction, RawCombinedFunction rawCombinedFunction2, RawCall rawCall, RawCall rawCall2) {
        super(rawCombinedFunction, rawCombinedFunction2);
        this.primaryCall = rawCall;
        this.secondaryCall = rawCall2;
    }

    @Override
    public EMatchState getMatchState() {
        if (this.primaryCall == null) {
            return EMatchState.SECONDRAY_UNMATCHED;
        }
        if (this.secondaryCall == null) {
            return EMatchState.PRIMARY_UNMATCHED;
        }
        return EMatchState.MATCHED;
    }

    public RawCall getPrimaryEdge() {
        return this.primaryCall;
    }

    public RawCall getSecondaryEdge() {
        return this.secondaryCall;
    }

    @Override
    public RawCombinedFunction getSource() {
        return (RawCombinedFunction)super.getSource();
    }

    @Override
    public RawCombinedFunction getTarget() {
        return (RawCombinedFunction)super.getTarget();
    }

    public boolean isChanged() {
        if (this.getMatchState() != EMatchState.MATCHED) {
            if (this.primaryCall != null) {
                return this.primaryCall.isChanged();
            }
            if (this.secondaryCall != null) {
                return this.secondaryCall.isChanged();
            }
        }
        return false;
    }
}

