/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.rawcallgraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCall;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.CViewNode;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import java.util.List;

public class RawCallGraph
extends MutableDirectedGraph<RawFunction, RawCall> {
    private final ImmutableMap<IAddress, RawFunction> addressToFunction;
    private final ESide side;

    public RawCallGraph(List<RawFunction> list, List<RawCall> list2, ESide eSide) {
        super(list, list2);
        this.side = Preconditions.checkNotNull(eSide);
        this.addressToFunction = Maps.uniqueIndex(list, rawFunction -> rawFunction.getAddress());
    }

    public RawFunction getFunction(IAddress iAddress) {
        return this.addressToFunction.get(iAddress);
    }

    public ESide getSide() {
        return this.side;
    }

    public void resetVisibilityAndSelection() {
        for (Object object : this.getEdges()) {
            ((CViewEdge)object).removeAllListeners();
            ((CViewEdge)object).setVisible(true);
            ((CViewEdge)object).setSelected(false);
        }
        for (Object object : this.getNodes()) {
            ((CViewNode)object).removeAllListeners();
            ((CViewNode)object).setVisible(true);
            ((CViewNode)object).setSelected(false);
        }
    }
}

