/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.matches;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.matches.IMatchesChangeListener;
import com.google.security.zynamics.bindiff.types.Matches;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.List;

public class MatchData {
    private final DiffMetadata metadata;
    private Matches<FunctionMatchData> functionMatches;
    private final ListenerProvider<IMatchesChangeListener> listener = new ListenerProvider();

    public MatchData(List<FunctionMatchData> list, DiffMetadata diffMetadata) {
        this.metadata = Preconditions.checkNotNull(diffMetadata);
        this.functionMatches = new Matches<FunctionMatchData>(Preconditions.checkNotNull(list));
    }

    public void addListener(IMatchesChangeListener iMatchesChangeListener) {
        this.listener.addListener(iMatchesChangeListener);
    }

    public void close() {
        this.functionMatches.clear();
    }

    public FunctionMatchData getFunctionMatch(IAddress iAddress, ESide eSide) {
        return this.functionMatches.get(iAddress, eSide);
    }

    public FunctionMatchData[] getFunctionMatches() {
        return this.functionMatches.getMatches().toArray(new FunctionMatchData[0]);
    }

    public IAddress getPrimaryFunctionAddr(IAddress iAddress) {
        FunctionMatchData functionMatchData = this.functionMatches.get(iAddress, ESide.SECONDARY);
        return functionMatchData != null ? functionMatchData.getIAddress(ESide.PRIMARY) : null;
    }

    public IAddress getSecondaryFunctionAddr(IAddress iAddress) {
        FunctionMatchData functionMatchData = this.functionMatches.get(iAddress, ESide.PRIMARY);
        return functionMatchData != null ? functionMatchData.getIAddress(ESide.SECONDARY) : null;
    }

    public int getSizeOfBasicBlocks(ESide eSide) {
        return this.metadata.getSizeOfBasicBlocks(eSide);
    }

    public int getSizeOfCalls(ESide eSide) {
        return this.metadata.getSizeOfCalls(eSide);
    }

    public int getSizeOfChangedCalls() {
        return this.metadata.getSizeOfChangedCalls();
    }

    public int getSizeOfChangedFunctions() {
        return this.metadata.getSizeOfChangedFunctions();
    }

    public int getSizeOfFunctions(ESide eSide) {
        return this.metadata.getSizeOfFunctions(eSide);
    }

    public int getSizeOfInstructions(ESide eSide) {
        return this.metadata.getSizeOfInstructions(eSide);
    }

    public int getSizeOfJumps(ESide eSide) {
        return this.metadata.getSizeOfJumps(eSide);
    }

    public int getSizeOfMatchedBasicBlocks() {
        return this.metadata.getSizeOfMatchedBasicBlocks();
    }

    public int getSizeOfMatchedCalls() {
        return this.metadata.getSizeOfMatchedCalls();
    }

    public int getSizeOfMatchedFunctions() {
        return this.metadata.getSizeOfMatchedFunctions();
    }

    public int getSizeOfMatchedInstructions() {
        return this.metadata.getSizeOfMatchedInstructions();
    }

    public int getSizeOfMatchedJumps() {
        return this.metadata.getSizeOfMatchedJumps();
    }

    public int getSizeOfUnmatchedBasicBlocks(ESide eSide) {
        return this.metadata.getSizeOfUnmatchedBasicblocks(eSide);
    }

    public int getSizeOfUnmatchedCalls(ESide eSide) {
        return this.metadata.getSizeOfUnmatchedCalls(eSide);
    }

    public int getSizeOfUnmatchedFunctions(ESide eSide) {
        return this.metadata.getSizeOfUnmatchedFunctions(eSide);
    }

    public int getSizeOfUnmatchedInstructions(ESide eSide) {
        return this.metadata.getSizeOfUnmatchedInstructions(eSide);
    }

    public int getSizeOfUnmatchedJumps(ESide eSide) {
        return this.metadata.getSizeOfUnmatchedJumps(eSide);
    }

    public boolean isFunctionMatch(IAddress iAddress, IAddress iAddress2) {
        IAddress iAddress3 = this.getSecondaryFunctionAddr(iAddress);
        return iAddress3 != null && iAddress3.equals(iAddress2);
    }

    public void notifyBasicBlockMatchAddedListener(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
        for (IMatchesChangeListener iMatchesChangeListener : this.listener) {
            iMatchesChangeListener.addedBasicBlockMatch(iAddress, iAddress2, iAddress3, iAddress4);
        }
    }

    public void notifyBasicBlockMatchRemovedListener(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
        for (IMatchesChangeListener iMatchesChangeListener : this.listener) {
            iMatchesChangeListener.removedBasicBlockMatch(iAddress, iAddress2, iAddress3, iAddress4);
        }
    }

    public void removeListener(IMatchesChangeListener iMatchesChangeListener) {
        this.listener.removeListener(iMatchesChangeListener);
    }

    public void setSizeOfChangedCalls(int n2) {
        this.metadata.setSizeOfChangedCalls(n2);
    }

    public void setSizeOfChangedFunctions(int n2) {
        this.metadata.setSizeOfChangedFunctions(n2);
    }

    public void setSizeOfMatchedBasicBlocks(int n2) {
        this.metadata.setSizeOfMatchedBasicBlocks(n2);
    }

    public void setSizeOfMatchedCalls(int n2) {
        this.metadata.setSizeOfMatchedCalls(n2);
    }

    public void setSizeOfMatchedInstructions(int n2) {
        this.metadata.setSizeOfMatchedInstructions(n2);
    }

    public void setSizeOfMatchedJumps(int n2) {
        this.metadata.setSizeOfMatchedJumps(n2);
    }
}

