/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.matches;

import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.edges.CombinedViewEdge;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.matches.AddressPair;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.matches.IAddressPair;
import com.google.security.zynamics.bindiff.project.matches.InstructionMatchData;
import com.google.security.zynamics.bindiff.project.matches.MatchData;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedJump;
import com.google.security.zynamics.bindiff.types.Matches;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FunctionMatchData
implements IAddressPair {
    private final int id;
    private final IAddressPair addrPair;
    private final double similarity;
    private final double confidence;
    private final int flags;
    private final int algoId;
    private Matches<BasicBlockMatchData> basicblockMatches = null;
    private int matchedBasicBlocks;
    private int matchedJumps;
    private int matchedInstructions;

    public FunctionMatchData(int n2, long l2, long l3, double d2, double d3, int n3, int n4, int n5, int n6, int n7) {
        this.id = n2;
        this.addrPair = new AddressPair(l2, l3);
        this.similarity = d2;
        this.confidence = d3;
        this.flags = n3;
        this.algoId = n4;
        this.matchedBasicBlocks = n5;
        this.matchedJumps = n6;
        this.matchedInstructions = n7;
    }

    protected int getId() {
        return this.id;
    }

    public void addBasicblockMatch(Diff diff, BasicBlockMatchData basicBlockMatchData, RawCombinedBasicBlock rawCombinedBasicBlock) {
        this.basicblockMatches.put(basicBlockMatchData);
        HashSet<CombinedViewEdge<? extends CombinedViewNode>> hashSet = new HashSet<CombinedViewEdge<? extends CombinedViewNode>>();
        hashSet.addAll(rawCombinedBasicBlock.getIncomingEdges());
        hashSet.addAll(rawCombinedBasicBlock.getOutgoingEdges());
        int n2 = 0;
        for (CombinedViewEdge object2 : hashSet) {
            if (object2.getMatchState() != EMatchState.MATCHED) continue;
            ++n2;
        }
        int n3 = basicBlockMatchData.getInstructionMatches().length;
        this.matchedInstructions += n3;
        this.matchedJumps += n2;
        ++this.matchedBasicBlocks;
        MatchData matchData = diff.getMatches();
        matchData.setSizeOfMatchedBasicBlocks(matchData.getSizeOfMatchedBasicBlocks() + 1);
        matchData.setSizeOfMatchedJumps(matchData.getSizeOfMatchedJumps() + n2);
        matchData.setSizeOfMatchedInstructions(matchData.getSizeOfMatchedInstructions() + n3);
    }

    @Override
    public long getAddress(ESide eSide) {
        return this.addrPair.getAddress(eSide);
    }

    public int getAlgorithmId() {
        return this.algoId;
    }

    public String getAlgorithmName() {
        return "TODO";
    }

    public BasicBlockMatchData getBasicBlockMatch(IAddress iAddress, ESide eSide) {
        return this.basicblockMatches != null ? this.basicblockMatches.get(iAddress, eSide) : null;
    }

    public Collection<BasicBlockMatchData> getBasicBlockMatches() {
        return this.basicblockMatches != null ? this.basicblockMatches.getMatches() : null;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public IAddress getIAddress(ESide eSide) {
        return new CAddress(this.addrPair.getAddress(eSide));
    }

    public Map<IAddress, IAddress> getInstructionsAddressMap(ESide eSide) {
        if (this.basicblockMatches != null) {
            HashMap<IAddress, IAddress> hashMap = new HashMap<IAddress, IAddress>();
            for (BasicBlockMatchData basicBlockMatchData : this.basicblockMatches.getMatches()) {
                InstructionMatchData[] instructionMatchDataArray;
                for (InstructionMatchData instructionMatchData : instructionMatchDataArray = basicBlockMatchData.getInstructionMatches()) {
                    ESide eSide2 = eSide == ESide.PRIMARY ? ESide.SECONDARY : ESide.PRIMARY;
                    hashMap.put(instructionMatchData.getIAddress(eSide), instructionMatchData.getIAddress(eSide2));
                }
            }
            return hashMap;
        }
        return null;
    }

    public IAddress getPrimaryBasicblockAddr(IAddress iAddress) {
        if (this.basicblockMatches != null) {
            BasicBlockMatchData basicBlockMatchData = this.basicblockMatches.get(iAddress, ESide.SECONDARY);
            return basicBlockMatchData != null ? basicBlockMatchData.getIAddress(ESide.PRIMARY) : null;
        }
        return null;
    }

    public IAddress getSecondaryBasicblockAddr(IAddress iAddress) {
        if (this.basicblockMatches != null) {
            BasicBlockMatchData basicBlockMatchData = this.basicblockMatches.get(iAddress, ESide.PRIMARY);
            return basicBlockMatchData != null ? basicBlockMatchData.getIAddress(ESide.SECONDARY) : null;
        }
        return null;
    }

    public double getSimilarity() {
        return this.similarity;
    }

    public int getSizeOfMatchedBasicBlocks() {
        return this.matchedBasicBlocks;
    }

    public int getSizeOfMatchedInstructions() {
        return this.matchedInstructions;
    }

    public int getSizeOfMatchedJumps() {
        return this.matchedJumps;
    }

    public boolean isBasicblockMatch(IAddress iAddress, IAddress iAddress2) {
        IAddress iAddress3 = this.getSecondaryBasicblockAddr(iAddress);
        return iAddress3 != null && iAddress3.equals(iAddress2);
    }

    public boolean isLoaded() {
        return this.basicblockMatches != null;
    }

    public void loadBasicBlockMatches(List<BasicBlockMatchData> list) {
        this.basicblockMatches = new Matches<BasicBlockMatchData>(list);
    }

    public void removeBasicblockMatch(Diff diff, RawCombinedBasicBlock rawCombinedBasicBlock) {
        IAddress iAddress;
        IAddress iAddress2 = rawCombinedBasicBlock.getAddress(ESide.PRIMARY);
        BasicBlockMatchData basicBlockMatchData = this.basicblockMatches.remove(iAddress2, iAddress = rawCombinedBasicBlock.getAddress(ESide.SECONDARY));
        if (basicBlockMatchData != null) {
            int n2 = basicBlockMatchData.getSizeOfMatchedInstructions();
            HashSet<CombinedViewEdge<? extends CombinedViewNode>> hashSet = new HashSet<CombinedViewEdge<? extends CombinedViewNode>>();
            hashSet.addAll(rawCombinedBasicBlock.getOutgoingEdges());
            hashSet.addAll(rawCombinedBasicBlock.getIncomingEdges());
            int n3 = 0;
            for (CombinedViewEdge combinedViewEdge : hashSet) {
                if (((RawCombinedJump)combinedViewEdge).getMatchState() != EMatchState.MATCHED) continue;
                ++n3;
            }
            this.matchedInstructions -= n2;
            this.matchedJumps -= n3;
            --this.matchedBasicBlocks;
            MatchData matchData = diff.getMatches();
            matchData.setSizeOfMatchedBasicBlocks(matchData.getSizeOfMatchedBasicBlocks() - 1);
            matchData.setSizeOfMatchedJumps(matchData.getSizeOfMatchedJumps() - n3);
            matchData.setSizeOfMatchedInstructions(matchData.getSizeOfMatchedInstructions() - n2);
        }
    }

    public void setSizeOfMatchedBasicblocks(int n2) {
        this.matchedBasicBlocks = n2;
    }

    public void setSizeOfMatchedInstructions(int n2) {
        this.matchedInstructions = n2;
    }

    public void setSizeOfMatchedJumps(int n2) {
        this.matchedJumps = n2;
    }
}

