/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.matches;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.project.diff.CountsChangedListener;
import com.google.security.zynamics.zylib.date.DateHelpers;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;

public class DiffMetadata {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final String version;
    private final String description;
    private final String primaryIdbName;
    private final String secondaryIdbName;
    private final String primaryImageName;
    private final String secondaryImageName;
    private final String primaryHash;
    private final String secondaryHash;
    private String primaryArchitectureName;
    private String secondaryArchitectureName;
    private int primaryMaxMnemonicLen;
    private int secondaryMaxMnemonicLen;
    private final GregorianCalendar date;
    private final double totalSimilarity;
    private final double totalConfidence;
    private final int[] similarityIntervalCounts;
    private int matchedFunctions;
    private int changedFunctions;
    private final int priFunctions;
    private final int secFunctions;
    private int matchedCalls;
    private int changedCalls;
    private final int priCalls;
    private final int secCalls;
    private final int priBasicBlocks;
    private final int secBasicBlocks;
    private final int priJumps;
    private final int secJumps;
    private final int priInstructions;
    private final int secInstructions;
    private int matchedBasicBlocks;
    private int matchedJumps;
    private int matchedInstructions;
    private final ListenerProvider<CountsChangedListener> listeners = new ListenerProvider();

    public DiffMetadata(String string, String string2, GregorianCalendar gregorianCalendar, double d2, double d3, String string3, String string4, String string5, String string6, String string7, String string8, int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        this.version = string;
        this.description = string2;
        this.primaryIdbName = string3;
        this.secondaryIdbName = string4;
        this.primaryImageName = string5;
        this.secondaryImageName = string6;
        this.primaryHash = string7;
        this.secondaryHash = string8;
        this.date = gregorianCalendar;
        this.totalSimilarity = d2;
        this.totalConfidence = d3;
        this.similarityIntervalCounts = nArray;
        this.matchedFunctions = n2;
        this.priFunctions = n3;
        this.secFunctions = n4;
        this.priCalls = n5;
        this.secCalls = n6;
        this.priBasicBlocks = n7;
        this.secBasicBlocks = n8;
        this.priJumps = n9;
        this.secJumps = n10;
        this.priInstructions = n11;
        this.secInstructions = n12;
        this.changedFunctions = 0;
        this.matchedCalls = 0;
        this.changedCalls = 0;
    }

    public static GregorianCalendar dbDateStringToCalendar(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            gregorianCalendar.setTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string));
        }
        catch (ParseException parseException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(parseException)).log();
        }
        return gregorianCalendar;
    }

    public void addListener(CountsChangedListener countsChangedListener) {
        this.listeners.addListener(countsChangedListener);
    }

    public String getArchitectureName(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.primaryArchitectureName : this.secondaryArchitectureName;
    }

    public GregorianCalendar getDate() {
        return this.date;
    }

    public String getDateString() {
        return DateHelpers.formatDate(this.date.getTime(), 2, Locale.getDefault());
    }

    public String getDiffDescription() {
        return this.description;
    }

    public String getIdbName(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.primaryIdbName : this.secondaryIdbName;
    }

    public String getImageHash(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.primaryHash : this.secondaryHash;
    }

    public String getImageName(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.primaryImageName : this.secondaryImageName;
    }

    public String getDisplayName(ESide eSide) {
        String string = this.getImageName(eSide);
        if ("".equals(string)) {
            string = this.getIdbName(eSide);
        }
        if ("".equals(string)) {
            string = this.getImageHash(eSide);
        }
        if ("".equals(string)) {
            string = eSide.toString();
        }
        return string;
    }

    public int getMaxMnemonicLen() {
        int n2 = Math.max(this.primaryMaxMnemonicLen, this.secondaryMaxMnemonicLen);
        if (n2 == 0) {
            n2 = 12;
        }
        return n2;
    }

    public int getMaxMnemonicLen(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.primaryMaxMnemonicLen : this.secondaryMaxMnemonicLen;
    }

    public int getSimilarityIntervalCount(int n2) {
        Preconditions.checkArgument(n2 <= 10, "Confidence interval index cannot be greater than 10.");
        return this.similarityIntervalCounts[n2];
    }

    public int[] getSimilarityIntervalCounts() {
        return this.similarityIntervalCounts;
    }

    public int getSizeOfBasicBlocks(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priBasicBlocks : this.secBasicBlocks;
    }

    public int getSizeOfCalls(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priCalls : this.secCalls;
    }

    public int getSizeOfChangedCalls() {
        return this.changedCalls;
    }

    public int getSizeOfChangedFunctions() {
        return this.changedFunctions;
    }

    public int getSizeOfFunctions(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priFunctions : this.secFunctions;
    }

    public int getSizeOfInstructions(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priInstructions : this.secInstructions;
    }

    public int getSizeOfJumps(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priJumps : this.secJumps;
    }

    public int getSizeOfMatchedBasicBlocks() {
        return this.matchedBasicBlocks;
    }

    public int getSizeOfMatchedCalls() {
        return this.matchedCalls;
    }

    public int getSizeOfMatchedFunctions() {
        return this.matchedFunctions;
    }

    public int getSizeOfMatchedInstructions() {
        return this.matchedInstructions;
    }

    public int getSizeOfMatchedJumps() {
        return this.matchedJumps;
    }

    public int getSizeOfUnmatchedBasicblocks(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priBasicBlocks - this.matchedBasicBlocks : this.secBasicBlocks - this.matchedBasicBlocks;
    }

    public int getSizeOfUnmatchedCalls(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priCalls - this.matchedCalls : this.secCalls - this.matchedCalls;
    }

    public int getSizeOfUnmatchedFunctions(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priFunctions - this.matchedFunctions : this.secFunctions - this.matchedFunctions;
    }

    public int getSizeOfUnmatchedInstructions(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priInstructions - this.matchedInstructions : this.secInstructions - this.matchedInstructions;
    }

    public int getSizeOfUnmatchedJumps(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.priJumps - this.matchedJumps : this.secJumps - this.matchedJumps;
    }

    public double getTotalConfidence() {
        return this.totalConfidence;
    }

    public double getTotalSimilarity() {
        return this.totalSimilarity;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeListener(CountsChangedListener countsChangedListener) {
        this.listeners.removeListener(countsChangedListener);
    }

    public void setArchitectureName(String string, ESide eSide) {
        if (eSide == ESide.PRIMARY) {
            this.primaryArchitectureName = string;
        } else {
            this.secondaryArchitectureName = string;
        }
    }

    public void setMaxMnemonicLen(int n2, ESide eSide) {
        if (eSide == ESide.PRIMARY) {
            this.primaryMaxMnemonicLen = n2;
        } else {
            this.secondaryMaxMnemonicLen = n2;
        }
    }

    public void setSizeOfChangedCalls(int n2) {
        this.changedCalls = n2;
        for (CountsChangedListener countsChangedListener : this.listeners) {
            countsChangedListener.callsCountChanged();
        }
    }

    public void setSizeOfChangedFunctions(int n2) {
        this.changedFunctions = n2;
        for (CountsChangedListener countsChangedListener : this.listeners) {
            countsChangedListener.functionsCountChanged();
        }
    }

    public void setSizeOfMatchedBasicBlocks(int n2) {
        this.matchedBasicBlocks = n2;
        for (CountsChangedListener countsChangedListener : this.listeners) {
            countsChangedListener.basicBlocksCountChanged();
        }
    }

    public void setSizeOfMatchedCalls(int n2) {
        this.matchedCalls = n2;
        for (CountsChangedListener countsChangedListener : this.listeners) {
            countsChangedListener.callsCountChanged();
        }
    }

    public void setSizeOfMatchedFunctions(int n2) {
        this.matchedFunctions = n2;
        for (CountsChangedListener countsChangedListener : this.listeners) {
            countsChangedListener.functionsCountChanged();
        }
    }

    public void setSizeOfMatchedInstructions(int n2) {
        this.matchedInstructions = n2;
        for (CountsChangedListener countsChangedListener : this.listeners) {
            countsChangedListener.instructionsCountsChanged();
        }
    }

    public void setSizeOfMatchedJumps(int n2) {
        this.matchedJumps = n2;
        for (CountsChangedListener countsChangedListener : this.listeners) {
            countsChangedListener.jumpsCountChanged();
        }
    }
}

