/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.matches;

import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.project.matches.AddressPair;
import com.google.security.zynamics.bindiff.project.matches.IAddressPair;
import com.google.security.zynamics.bindiff.project.matches.InstructionMatchData;
import com.google.security.zynamics.bindiff.types.Matches;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;

public class BasicBlockMatchData
implements IAddressPair {
    private final IAddressPair addrPair;
    private final int algoId;
    private final Matches<InstructionMatchData> instructionMatches;

    public BasicBlockMatchData(long l2, long l3, int n2, Matches<InstructionMatchData> matches) {
        this.addrPair = new AddressPair(l2, l3);
        this.algoId = n2;
        this.instructionMatches = matches;
    }

    @Override
    public long getAddress(ESide eSide) {
        return this.addrPair.getAddress(eSide);
    }

    public int getAlgorithmId() {
        return this.algoId;
    }

    @Override
    public IAddress getIAddress(ESide eSide) {
        return new CAddress(this.getAddress(eSide));
    }

    public InstructionMatchData getInstructionMatch(IAddress iAddress, ESide eSide) {
        return this.instructionMatches.get(iAddress, eSide);
    }

    public InstructionMatchData[] getInstructionMatches() {
        return this.instructionMatches.getMatches().toArray(new InstructionMatchData[0]);
    }

    public IAddress getPrimaryInstructionAddr(IAddress iAddress) {
        InstructionMatchData instructionMatchData = this.instructionMatches.get(iAddress, ESide.SECONDARY);
        return instructionMatchData != null ? instructionMatchData.getIAddress(ESide.PRIMARY) : null;
    }

    public IAddress getSecondaryInstructionAddr(IAddress iAddress) {
        InstructionMatchData instructionMatchData = this.instructionMatches.get(iAddress, ESide.PRIMARY);
        return instructionMatchData != null ? instructionMatchData.getIAddress(ESide.SECONDARY) : null;
    }

    public int getSizeOfMatchedInstructions() {
        return this.instructionMatches.size();
    }

    public boolean isInstructionMatch(IAddress iAddress) {
        IAddress iAddress2 = this.getSecondaryInstructionAddr(iAddress);
        return iAddress2 != null && iAddress2.equals(iAddress);
    }
}

