/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.helpers;

import com.google.security.zynamics.bindiff.enums.EMatchType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.edges.CombinedDiffEdge;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.graph.sorters.AddressPairSorter;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.matches.InstructionMatchData;
import com.google.security.zynamics.bindiff.project.matches.MatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstruction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MatchesGetter {
    public static Map<IAddress, IAddress> createMatchedInstructionsMap(Diff diff, RawFunction rawFunction) {
        HashMap<IAddress, IAddress> hashMap = new HashMap<IAddress, IAddress>();
        FunctionMatchData functionMatchData = MatchesGetter.getFunctionMatch(diff, rawFunction);
        for (BasicBlockMatchData basicBlockMatchData : functionMatchData.getBasicBlockMatches()) {
            for (InstructionMatchData instructionMatchData : basicBlockMatchData.getInstructionMatches()) {
                if (rawFunction.getSide() == ESide.PRIMARY) {
                    hashMap.put(instructionMatchData.getIAddress(ESide.PRIMARY), instructionMatchData.getIAddress(ESide.SECONDARY));
                    continue;
                }
                hashMap.put(instructionMatchData.getIAddress(ESide.SECONDARY), instructionMatchData.getIAddress(ESide.PRIMARY));
            }
        }
        return hashMap;
    }

    public static List<Pair<IAddress, IAddress>> getBasicBlockAddressPairs(Diff diff, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2) {
        ArrayList<Pair<IAddress, IAddress>> arrayList = new ArrayList<Pair<IAddress, IAddress>>();
        MatchData matchData = diff.getMatches();
        if (rawFlowGraph == null) {
            for (RawBasicBlock rawBasicBlock : rawFlowGraph2) {
                arrayList.add(new Pair<Object, IAddress>(null, rawBasicBlock.getAddress()));
            }
        } else if (rawFlowGraph2 == null) {
            for (RawBasicBlock rawBasicBlock : rawFlowGraph) {
                arrayList.add(new Pair<IAddress, Object>(rawBasicBlock.getAddress(), null));
            }
        } else {
            IAddress iAddress;
            FunctionMatchData functionMatchData = matchData.getFunctionMatch(rawFlowGraph.getAddress(), ESide.PRIMARY);
            for (RawBasicBlock rawBasicBlock : rawFlowGraph) {
                iAddress = rawBasicBlock.getAddress();
                IAddress iAddress2 = functionMatchData.getSecondaryBasicblockAddr(iAddress);
                arrayList.add(new Pair<IAddress, IAddress>(iAddress, iAddress2));
            }
            for (RawBasicBlock rawBasicBlock : rawFlowGraph2) {
                iAddress = rawBasicBlock.getAddress();
                if (functionMatchData.getPrimaryBasicblockAddr(iAddress) != null) continue;
                arrayList.add(new Pair<Object, IAddress>(null, iAddress));
            }
        }
        return AddressPairSorter.getSortedList(arrayList, ESide.PRIMARY);
    }

    public static BasicBlockMatchData getBasicBlockMatch(Diff diff, RawBasicBlock rawBasicBlock) {
        ESide eSide = rawBasicBlock.getSide();
        RawFunction rawFunction = diff.getFunction(rawBasicBlock.getFunctionAddr(), eSide);
        FunctionMatchData functionMatchData = MatchesGetter.getFunctionMatch(diff, rawFunction);
        return MatchesGetter.getBasicBlockMatch(functionMatchData, rawBasicBlock);
    }

    public static BasicBlockMatchData getBasicBlockMatch(Diff diff, IAddress iAddress, IAddress iAddress2, ESide eSide) {
        RawFunction rawFunction = diff.getFunction(iAddress, eSide);
        FunctionMatchData functionMatchData = MatchesGetter.getFunctionMatch(diff, rawFunction);
        if (functionMatchData == null) {
            return null;
        }
        return functionMatchData.getBasicBlockMatch(iAddress2, eSide);
    }

    public static BasicBlockMatchData getBasicBlockMatch(FunctionMatchData functionMatchData, RawBasicBlock rawBasicBlock) {
        if (functionMatchData == null) {
            return null;
        }
        IAddress iAddress = rawBasicBlock.getAddress();
        if (rawBasicBlock.getSide() == ESide.SECONDARY) {
            iAddress = functionMatchData.getPrimaryBasicblockAddr(iAddress);
        }
        return functionMatchData.getBasicBlockMatch(iAddress, ESide.PRIMARY);
    }

    public static EMatchType getFlowGraphsMatchType(CombinedGraph combinedGraph, FunctionMatchData functionMatchData) {
        int n2 = functionMatchData.getBasicBlockMatches().size();
        int n3 = combinedGraph.getPrimaryGraph().getPrimaryGraph().getNodes().size();
        int n4 = combinedGraph.getSecondaryGraph().getSecondaryGraph().getNodes().size();
        if (n3 == n2 && n4 == n2) {
            Object object;
            boolean bl2 = true;
            for (Object object2 : combinedGraph.getEdges()) {
                Object object3 = ((CombinedDiffEdge)object2).getPrimaryDiffEdge();
                object = ((CombinedDiffEdge)object2).getSecondaryDiffEdge();
                if (object3 != null && object != null) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                boolean bl3 = true;
                for (Object object3 : combinedGraph.getNodes()) {
                    object = (RawBasicBlock)((CombinedDiffNode)object3).getPrimaryRawNode();
                    RawBasicBlock rawBasicBlock = (RawBasicBlock)((CombinedDiffNode)object3).getSecondaryRawNode();
                    BasicBlockMatchData basicBlockMatchData = functionMatchData.getBasicBlockMatch(((SingleViewNode)object).getAddress(), ESide.PRIMARY);
                    int n5 = ((RawBasicBlock)object).getSizeOfInstructions();
                    int n6 = rawBasicBlock.getSizeOfInstructions();
                    int n7 = basicBlockMatchData.getSizeOfMatchedInstructions();
                    if (n5 == n7 && n6 == n7) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) {
                    return EMatchType.IDENTICAL;
                }
                return EMatchType.INSTRUCTIONS_CHANGED;
            }
        }
        return EMatchType.STRUCTURAL_CHANGED;
    }

    public static FunctionMatchData getFunctionMatch(Diff diff, RawFlowGraph rawFlowGraph) {
        ESide eSide = rawFlowGraph.getSide();
        IAddress iAddress = rawFlowGraph.getAddress();
        RawFunction rawFunction = diff.getCallGraph(eSide).getFunction(iAddress);
        return MatchesGetter.getFunctionMatch(diff, rawFunction);
    }

    public static FunctionMatchData getFunctionMatch(Diff diff, RawFunction rawFunction) {
        MatchData matchData = diff.getMatches();
        if (rawFunction.getSide() == ESide.PRIMARY) {
            IAddress iAddress = rawFunction.getAddress();
            IAddress iAddress2 = matchData.getSecondaryFunctionAddr(rawFunction.getAddress());
            if (iAddress2 != null) {
                return matchData.getFunctionMatch(iAddress, ESide.PRIMARY);
            }
        } else {
            IAddress iAddress = matchData.getPrimaryFunctionAddr(rawFunction.getAddress());
            if (iAddress != null) {
                return matchData.getFunctionMatch(iAddress, ESide.PRIMARY);
            }
        }
        return null;
    }

    public static List<Pair<IAddress, IAddress>> getInstructionAddressPairs(Diff diff, RawBasicBlock rawBasicBlock, RawBasicBlock rawBasicBlock2) {
        ArrayList<Pair<IAddress, IAddress>> arrayList = new ArrayList<Pair<IAddress, IAddress>>();
        MatchData matchData = diff.getMatches();
        if (rawBasicBlock == null) {
            for (RawInstruction rawInstruction : rawBasicBlock2) {
                arrayList.add(new Pair<Object, IAddress>(null, rawInstruction.getAddress()));
            }
        } else if (rawBasicBlock2 == null) {
            for (RawInstruction rawInstruction : rawBasicBlock) {
                arrayList.add(new Pair<IAddress, Object>(rawInstruction.getAddress(), null));
            }
        } else {
            IAddress iAddress;
            IAddress iAddress2 = rawBasicBlock.getFunctionAddr();
            FunctionMatchData functionMatchData = matchData.getFunctionMatch(iAddress2, ESide.PRIMARY);
            IAddress iAddress3 = rawBasicBlock.getAddress();
            BasicBlockMatchData basicBlockMatchData = functionMatchData.getBasicBlockMatch(iAddress3, ESide.PRIMARY);
            for (RawInstruction rawInstruction : rawBasicBlock) {
                iAddress = rawInstruction.getAddress();
                IAddress iAddress4 = basicBlockMatchData.getSecondaryInstructionAddr(iAddress);
                arrayList.add(new Pair<IAddress, IAddress>(iAddress, iAddress4));
            }
            for (RawInstruction rawInstruction : rawBasicBlock2) {
                iAddress = rawInstruction.getAddress();
                if (basicBlockMatchData.getPrimaryInstructionAddr(iAddress) != null) continue;
                arrayList.add(new Pair<Object, IAddress>(null, iAddress));
            }
        }
        return AddressPairSorter.getSortedList(arrayList, ESide.PRIMARY);
    }

    public static boolean isChangedBasicBlock(Diff diff, RawBasicBlock rawBasicBlock, RawBasicBlock rawBasicBlock2) {
        if (rawBasicBlock == null || rawBasicBlock2 == null) {
            return false;
        }
        BasicBlockMatchData basicBlockMatchData = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock);
        if (basicBlockMatchData != null) {
            int n2 = basicBlockMatchData.getSizeOfMatchedInstructions();
            int n3 = rawBasicBlock.getSizeOfInstructions();
            int n4 = rawBasicBlock2.getSizeOfInstructions();
            return n2 != n3 || n2 != n4;
        }
        return false;
    }

    public static boolean isIdenticalBasicBlock(Diff diff, RawBasicBlock rawBasicBlock, RawBasicBlock rawBasicBlock2) {
        if (rawBasicBlock == null || rawBasicBlock2 == null) {
            return false;
        }
        BasicBlockMatchData basicBlockMatchData = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock);
        if (basicBlockMatchData != null) {
            int n2 = basicBlockMatchData.getSizeOfMatchedInstructions();
            int n3 = rawBasicBlock.getSizeOfInstructions();
            int n4 = rawBasicBlock2.getSizeOfInstructions();
            return n2 == n3 && n2 == n4;
        }
        return false;
    }

    public static boolean isIdenticalFunctionPair(RawFunction rawFunction, RawFunction rawFunction2) {
        if (rawFunction.getMatchedFunction() != rawFunction2) {
            throw new IllegalArgumentException("Primary and secondary function must be matched to each other.");
        }
        return rawFunction.isIdenticalMatch();
    }

    public static boolean isInstructionsOnlyChangedFunctionPair(RawFunction rawFunction, RawFunction rawFunction2) {
        if (rawFunction.getMatchedFunction() != rawFunction2) {
            throw new IllegalArgumentException("Primary and secondary function must be matched to each other.");
        }
        int n2 = rawFunction.getFunctionMatch().getSizeOfMatchedInstructions();
        return rawFunction.getSizeOfUnmatchedBasicBlocks() == 0 && rawFunction.getSizeOfUnmatchedJumps() == 0 && rawFunction2.getSizeOfUnmatchedBasicBlocks() == 0 && rawFunction2.getSizeOfUnmatchedJumps() == 0 && (rawFunction.getSizeOfInstructions() != n2 || rawFunction2.getSizeOfInstructions() != n2);
    }

    public static boolean isMatchedInstruction(Diff diff, RawBasicBlock rawBasicBlock, RawInstruction rawInstruction) {
        MatchData matchData = diff.getMatches();
        FunctionMatchData functionMatchData = matchData.getFunctionMatch(rawBasicBlock.getFunctionAddr(), rawBasicBlock.getSide());
        return MatchesGetter.isMatchedInstruction(functionMatchData, rawBasicBlock, rawInstruction);
    }

    public static boolean isMatchedInstruction(FunctionMatchData functionMatchData, RawBasicBlock rawBasicBlock, RawInstruction rawInstruction) {
        ESide eSide = rawBasicBlock.getSide();
        if (functionMatchData != null) {
            BasicBlockMatchData basicBlockMatchData;
            IAddress iAddress;
            IAddress iAddress2 = eSide == ESide.PRIMARY ? rawBasicBlock.getAddress() : functionMatchData.getPrimaryBasicblockAddr(rawBasicBlock.getAddress());
            IAddress iAddress3 = iAddress = eSide == ESide.SECONDARY ? rawBasicBlock.getAddress() : functionMatchData.getSecondaryBasicblockAddr(rawBasicBlock.getAddress());
            if (iAddress2 != null && iAddress != null && (basicBlockMatchData = functionMatchData.getBasicBlockMatch(iAddress2, ESide.PRIMARY)) != null) {
                IAddress iAddress4 = rawInstruction.getAddress();
                if (eSide == ESide.PRIMARY) {
                    return basicBlockMatchData.getSecondaryInstructionAddr(iAddress4) != null;
                }
                return basicBlockMatchData.getPrimaryInstructionAddr(iAddress4) != null;
            }
        }
        return false;
    }

    public static boolean isStructuralChangedFunctionPair(RawFunction rawFunction, RawFunction rawFunction2) {
        if (rawFunction.getMatchedFunction() != rawFunction2) {
            throw new IllegalArgumentException("Primary and secondary function must be matched to each other.");
        }
        return rawFunction.getSizeOfUnmatchedBasicBlocks() != 0 || rawFunction.getSizeOfUnmatchedJumps() != 0 || rawFunction2.getSizeOfUnmatchedBasicBlocks() != 0 || rawFunction2.getSizeOfUnmatchedJumps() != 0;
    }
}

