/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.helpers;

import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.edges.SingleViewEdge;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.helpers.MatchesGetter;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCall;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawJump;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GraphGetter {
    public static RawCall getCall(RawCallGraph rawCallGraph, IAddress iAddress, IAddress iAddress2, IAddress iAddress3) {
        RawFunction rawFunction = rawCallGraph.getFunction(iAddress);
        if (rawFunction != null) {
            for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawFunction.getOutgoingEdges()) {
                RawCall rawCall = (RawCall)singleViewEdge;
                if (!rawCall.getSourceInstructionAddr().equals(iAddress3) || !((RawFunction)rawCall.getTarget()).getAddress().equals(iAddress2)) continue;
                return rawCall;
            }
        }
        return null;
    }

    public static List<RawFunction> getCallees(RawFunction rawFunction) {
        ArrayList<RawFunction> arrayList = new ArrayList<RawFunction>();
        arrayList.addAll(rawFunction.getCallees());
        return arrayList;
    }

    public static List<RawFunction> getCallers(RawFunction rawFunction) {
        ArrayList<RawFunction> arrayList = new ArrayList<RawFunction>();
        arrayList.addAll(rawFunction.getCallers());
        return arrayList;
    }

    public static List<RawCall> getCallsAt(RawCallGraph rawCallGraph, IAddress iAddress, IAddress iAddress2) {
        ArrayList<RawCall> arrayList = new ArrayList<RawCall>();
        RawFunction rawFunction = rawCallGraph.getFunction(iAddress);
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawFunction.getOutgoingEdges()) {
            RawCall rawCall = (RawCall)singleViewEdge;
            if (!rawCall.getSourceInstructionAddr().equals(iAddress2)) continue;
            arrayList.add(rawCall);
        }
        return arrayList;
    }

    public static Set<Pair<RawFunction, RawFunction>> getChangedFunctionPairs(RawCallGraph rawCallGraph, RawCallGraph rawCallGraph2) {
        Set<Pair<RawFunction, RawFunction>> set = GraphGetter.getMatchedFunctionPairs(rawCallGraph, rawCallGraph2);
        HashSet<Pair<RawFunction, RawFunction>> hashSet = new HashSet<Pair<RawFunction, RawFunction>>();
        for (Pair<RawFunction, RawFunction> pair : set) {
            RawFunction rawFunction = pair.first();
            RawFunction rawFunction2 = pair.second();
            int n2 = rawFunction.getFunctionMatch().getSizeOfMatchedInstructions();
            if (rawFunction.getSizeOfUnmatchedBasicBlocks() == 0 && rawFunction.getSizeOfUnmatchedJumps() == 0 && rawFunction2.getSizeOfUnmatchedBasicBlocks() == 0 && rawFunction2.getSizeOfUnmatchedJumps() == 0 && rawFunction.getSizeOfInstructions() == n2 && rawFunction2.getSizeOfInstructions() == n2) continue;
            Pair<RawFunction, RawFunction> pair2 = new Pair<RawFunction, RawFunction>(rawFunction, rawFunction2);
            hashSet.add(pair2);
        }
        return hashSet;
    }

    public static SingleDiffNode getDiffNode(GraphsContainer graphsContainer, RawBasicBlock rawBasicBlock) {
        return rawBasicBlock.getSide() == ESide.PRIMARY ? (SingleDiffNode)graphsContainer.getPrimaryGraph().getNode(rawBasicBlock) : (SingleDiffNode)graphsContainer.getSecondaryGraph().getNode(rawBasicBlock);
    }

    public static RawFunction getFunction(Diff diff, RawBasicBlock rawBasicBlock) {
        IAddress iAddress = rawBasicBlock.getFunctionAddr();
        RawCallGraph rawCallGraph = diff.getCallGraph(rawBasicBlock.getSide());
        return rawCallGraph.getFunction(iAddress);
    }

    public static RawFunction getFunction(Diff diff, RawFlowGraph rawFlowGraph) {
        if (rawFlowGraph == null) {
            return null;
        }
        RawCallGraph rawCallGraph = diff.getCallGraph(rawFlowGraph.getSide());
        return rawCallGraph.getFunction(rawFlowGraph.getAddress());
    }

    public static Set<Pair<RawFunction, RawFunction>> getIdenticalFunctionPairs(RawCallGraph rawCallGraph, RawCallGraph rawCallGraph2) {
        Set<Pair<RawFunction, RawFunction>> set = GraphGetter.getMatchedFunctionPairs(rawCallGraph, rawCallGraph2);
        HashSet<Pair<RawFunction, RawFunction>> hashSet = new HashSet<Pair<RawFunction, RawFunction>>();
        for (Pair<RawFunction, RawFunction> pair : set) {
            RawFunction rawFunction;
            RawFunction rawFunction2 = pair.first();
            if (!MatchesGetter.isIdenticalFunctionPair(rawFunction2, rawFunction = pair.second())) continue;
            Pair<RawFunction, RawFunction> pair2 = new Pair<RawFunction, RawFunction>(rawFunction2, rawFunction);
            hashSet.add(pair2);
        }
        return hashSet;
    }

    public static Collection<RawJump> getIncomingJumps(RawBasicBlock rawBasicBlock) {
        ArrayList<RawJump> arrayList = new ArrayList<RawJump>();
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawBasicBlock.getIncomingEdges()) {
            if (!(singleViewEdge instanceof RawJump)) continue;
            arrayList.add((RawJump)singleViewEdge);
        }
        return arrayList;
    }

    public static Set<Pair<RawFunction, RawFunction>> getInstructionOnlyChangedFunctionPairs(RawCallGraph rawCallGraph, RawCallGraph rawCallGraph2) {
        Set<Pair<RawFunction, RawFunction>> set = GraphGetter.getMatchedFunctionPairs(rawCallGraph, rawCallGraph2);
        HashSet<Pair<RawFunction, RawFunction>> hashSet = new HashSet<Pair<RawFunction, RawFunction>>();
        for (Pair<RawFunction, RawFunction> pair : set) {
            RawFunction rawFunction;
            RawFunction rawFunction2 = pair.first();
            if (!MatchesGetter.isInstructionsOnlyChangedFunctionPair(rawFunction2, rawFunction = pair.second())) continue;
            Pair<RawFunction, RawFunction> pair2 = new Pair<RawFunction, RawFunction>(rawFunction2, rawFunction);
            hashSet.add(pair2);
        }
        return hashSet;
    }

    public static List<RawFunction> getMatchedCallees(RawFunction rawFunction) {
        HashSet<RawFunction> hashSet = new HashSet<RawFunction>();
        for (RawFunction rawFunction2 : rawFunction.getCallees()) {
            if (rawFunction2.getMatchState() != EMatchState.MATCHED) continue;
            hashSet.add(rawFunction2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public static List<RawFunction> getMatchedCallers(RawFunction rawFunction) {
        HashSet<RawFunction> hashSet = new HashSet<RawFunction>();
        for (RawFunction rawFunction2 : rawFunction.getCallers()) {
            if (rawFunction2.getMatchState() != EMatchState.MATCHED) continue;
            hashSet.add(rawFunction2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public static Set<Pair<RawFunction, RawFunction>> getMatchedFunctionPairs(RawCallGraph rawCallGraph, RawCallGraph rawCallGraph2) {
        HashSet<Pair<RawFunction, RawFunction>> hashSet = new HashSet<Pair<RawFunction, RawFunction>>();
        for (RawFunction rawFunction : rawCallGraph.getNodes()) {
            if (rawFunction.getMatchState() != EMatchState.MATCHED) continue;
            RawFunction rawFunction2 = rawCallGraph2.getFunction(rawFunction.getMatchedFunctionAddress());
            Pair<RawFunction, RawFunction> pair = new Pair<RawFunction, RawFunction>(rawFunction, rawFunction2);
            hashSet.add(pair);
        }
        return hashSet;
    }

    public static List<RawCall> getMatchedIncomingCalls(RawFunction rawFunction) {
        ArrayList<RawCall> arrayList = new ArrayList<RawCall>();
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawFunction.getIncomingEdges()) {
            RawCall rawCall = (RawCall)singleViewEdge;
            if (rawCall.getMatchState() != EMatchState.MATCHED && !rawCall.isChanged()) continue;
            arrayList.add(rawCall);
        }
        return arrayList;
    }

    public static Collection<RawJump> getMatchedIncomingJumps(Diff diff, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2, RawBasicBlock rawBasicBlock) {
        ArrayList<RawJump> arrayList = new ArrayList<RawJump>();
        BasicBlockMatchData basicBlockMatchData = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock);
        if (basicBlockMatchData == null) {
            return arrayList;
        }
        RawFlowGraph rawFlowGraph3 = rawBasicBlock.getSide() == ESide.PRIMARY ? rawFlowGraph2 : rawFlowGraph;
        Collection<RawJump> collection = GraphGetter.getIncomingJumps(rawBasicBlock);
        for (RawJump rawJump : collection) {
            RawBasicBlock rawBasicBlock2 = rawJump.getTarget();
            BasicBlockMatchData basicBlockMatchData2 = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock2);
            if (basicBlockMatchData2 == null) continue;
            IAddress iAddress = null;
            IAddress iAddress2 = null;
            if (rawBasicBlock.getSide() == ESide.PRIMARY) {
                iAddress = basicBlockMatchData.getIAddress(ESide.SECONDARY);
                iAddress2 = basicBlockMatchData2.getIAddress(ESide.SECONDARY);
            } else {
                iAddress = basicBlockMatchData.getIAddress(ESide.PRIMARY);
                iAddress2 = basicBlockMatchData2.getIAddress(ESide.PRIMARY);
            }
            if (rawFlowGraph3.getJump(iAddress, iAddress2) == null) continue;
            arrayList.add(rawJump);
        }
        return arrayList;
    }

    public static List<RawCall> getMatchedOutgoingCalls(Diff diff, RawBasicBlock rawBasicBlock) {
        ArrayList<RawCall> arrayList = new ArrayList<RawCall>();
        List<RawCall> list = GraphGetter.getOutgoingCalls(diff, rawBasicBlock);
        for (RawCall rawCall : list) {
            if (rawCall.getMatchState() != EMatchState.MATCHED && !rawCall.isChanged()) continue;
            arrayList.add(rawCall);
        }
        return arrayList;
    }

    public static List<RawCall> getMatchedOutgoingCalls(RawFunction rawFunction) {
        ArrayList<RawCall> arrayList = new ArrayList<RawCall>();
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawFunction.getOutgoingEdges()) {
            RawCall rawCall = (RawCall)singleViewEdge;
            if (rawCall.getMatchState() != EMatchState.MATCHED && !rawCall.isChanged()) continue;
            arrayList.add(rawCall);
        }
        return arrayList;
    }

    public static Collection<RawJump> getMatchedOutgoingJumps(Diff diff, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2, RawBasicBlock rawBasicBlock) {
        ArrayList<RawJump> arrayList = new ArrayList<RawJump>();
        BasicBlockMatchData basicBlockMatchData = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock);
        if (basicBlockMatchData == null) {
            return arrayList;
        }
        RawFlowGraph rawFlowGraph3 = rawBasicBlock.getSide() == ESide.PRIMARY ? rawFlowGraph2 : rawFlowGraph;
        Collection<RawJump> collection = GraphGetter.getOutgoingJumps(rawBasicBlock);
        for (RawJump rawJump : collection) {
            RawBasicBlock rawBasicBlock2 = rawJump.getTarget();
            BasicBlockMatchData basicBlockMatchData2 = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock2);
            if (basicBlockMatchData2 == null) continue;
            IAddress iAddress = null;
            IAddress iAddress2 = null;
            if (rawBasicBlock.getSide() == ESide.PRIMARY) {
                iAddress = basicBlockMatchData.getIAddress(ESide.SECONDARY);
                iAddress2 = basicBlockMatchData2.getIAddress(ESide.SECONDARY);
            } else {
                iAddress = basicBlockMatchData.getIAddress(ESide.PRIMARY);
                iAddress2 = basicBlockMatchData2.getIAddress(ESide.PRIMARY);
            }
            if (rawFlowGraph3.getJump(iAddress, iAddress2) == null) continue;
            arrayList.add(rawJump);
        }
        return arrayList;
    }

    public static IAddress getMaxAddress(List<RawBasicBlock> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        IAddress iAddress = new CAddress(0L);
        for (RawBasicBlock rawBasicBlock : list) {
            IAddress iAddress2 = rawBasicBlock.getAddress();
            if (iAddress2.compareTo(iAddress) <= 0) continue;
            iAddress = iAddress2;
        }
        return iAddress;
    }

    public static IAddress getMinAddress(List<RawBasicBlock> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        IAddress iAddress = new CAddress(-1L);
        for (RawBasicBlock rawBasicBlock : list) {
            IAddress iAddress2 = rawBasicBlock.getAddress();
            if (iAddress2.compareTo(iAddress) >= 0) continue;
            iAddress = iAddress2;
        }
        return iAddress;
    }

    public static SingleGraph getOtherGraph(SingleGraph singleGraph) {
        return singleGraph.getSide() == ESide.PRIMARY ? singleGraph.getSecondaryGraph() : singleGraph.getPrimaryGraph();
    }

    public static List<RawCall> getOutgoingCalls(Diff diff, RawBasicBlock rawBasicBlock) {
        ArrayList<RawCall> arrayList = new ArrayList<RawCall>();
        RawFunction rawFunction = GraphGetter.getFunction(diff, rawBasicBlock);
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawFunction.getOutgoingEdges()) {
            RawCall rawCall = (RawCall)singleViewEdge;
            if (rawBasicBlock.getInstruction(rawCall.getSourceInstructionAddr()) == null) continue;
            arrayList.add(rawCall);
        }
        return arrayList;
    }

    public static Collection<RawJump> getOutgoingJumps(RawBasicBlock rawBasicBlock) {
        ArrayList<RawJump> arrayList = new ArrayList<RawJump>();
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawBasicBlock.getOutgoingEdges()) {
            if (!(singleViewEdge instanceof RawJump)) continue;
            arrayList.add((RawJump)singleViewEdge);
        }
        return arrayList;
    }

    public static SingleDiffNode getPrimaryDiffNode(SingleGraph singleGraph, RawBasicBlock rawBasicBlock) {
        SingleDiffNode singleDiffNode = (SingleDiffNode)singleGraph.getSecondaryGraph().getNode(rawBasicBlock);
        return singleDiffNode.getOtherSideDiffNode();
    }

    public static RawBasicBlock getPrimaryRawBasicblock(GraphsContainer graphsContainer, RawBasicBlock rawBasicBlock) {
        SingleDiffNode singleDiffNode = GraphGetter.getDiffNode(graphsContainer, rawBasicBlock);
        SingleDiffNode singleDiffNode2 = singleDiffNode.getOtherSideDiffNode();
        if (singleDiffNode2 != null) {
            return (RawBasicBlock)singleDiffNode2.getRawNode();
        }
        return null;
    }

    public static RawFunction getRawFunction(Diff diff, RawFlowGraph rawFlowGraph) {
        return diff.getCallGraph(rawFlowGraph.getSide()).getFunction(rawFlowGraph.getAddress());
    }

    public static SingleDiffNode getSecondaryDiffNode(SingleGraph singleGraph, RawBasicBlock rawBasicBlock) {
        SingleDiffNode singleDiffNode = (SingleDiffNode)singleGraph.getPrimaryGraph().getNode(rawBasicBlock);
        return singleDiffNode.getOtherSideDiffNode();
    }

    public static RawBasicBlock getSecondaryRawBasicblock(GraphsContainer graphsContainer, RawBasicBlock rawBasicBlock) {
        SingleDiffNode singleDiffNode = GraphGetter.getDiffNode(graphsContainer, rawBasicBlock);
        SingleDiffNode singleDiffNode2 = singleDiffNode.getOtherSideDiffNode();
        if (singleDiffNode2 != null) {
            return (RawBasicBlock)singleDiffNode2.getRawNode();
        }
        return null;
    }

    public static Set<Pair<RawFunction, RawFunction>> getStructuralChangedFunctionPairs(RawCallGraph rawCallGraph, RawCallGraph rawCallGraph2) {
        Set<Pair<RawFunction, RawFunction>> set = GraphGetter.getMatchedFunctionPairs(rawCallGraph, rawCallGraph2);
        HashSet<Pair<RawFunction, RawFunction>> hashSet = new HashSet<Pair<RawFunction, RawFunction>>();
        for (Pair<RawFunction, RawFunction> pair : set) {
            RawFunction rawFunction;
            RawFunction rawFunction2 = pair.first();
            if (!MatchesGetter.isStructuralChangedFunctionPair(rawFunction2, rawFunction = pair.second())) continue;
            Pair<RawFunction, RawFunction> pair2 = new Pair<RawFunction, RawFunction>(rawFunction2, rawFunction);
            hashSet.add(pair2);
        }
        return hashSet;
    }

    public static List<RawFunction> getUnmatchedCallees(RawFunction rawFunction) {
        HashSet<RawFunction> hashSet = new HashSet<RawFunction>();
        for (RawFunction rawFunction2 : rawFunction.getCallees()) {
            if (rawFunction2.getMatchState() == EMatchState.MATCHED) continue;
            hashSet.add(rawFunction2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public static List<RawFunction> getUnmatchedCallers(RawFunction rawFunction) {
        HashSet<RawFunction> hashSet = new HashSet<RawFunction>();
        for (RawFunction rawFunction2 : rawFunction.getCallees()) {
            if (rawFunction2.getMatchState() == EMatchState.MATCHED) continue;
            hashSet.add(rawFunction2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public static List<RawFunction> getUnmatchedFunctions(RawCallGraph rawCallGraph) {
        ArrayList<RawFunction> arrayList = new ArrayList<RawFunction>();
        for (RawFunction rawFunction : rawCallGraph.getNodes()) {
            if (rawFunction.getMatchState() == EMatchState.MATCHED) continue;
            arrayList.add(rawFunction);
        }
        return arrayList;
    }

    public static List<RawCall> getUnmatchedIncomingCalls(RawFunction rawFunction) {
        ArrayList<RawCall> arrayList = new ArrayList<RawCall>();
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawFunction.getIncomingEdges()) {
            RawCall rawCall = (RawCall)singleViewEdge;
            if (rawCall.getMatchState() == EMatchState.MATCHED || rawCall.isChanged()) continue;
            arrayList.add(rawCall);
        }
        return arrayList;
    }

    public static Collection<RawJump> getUnmatchedIncomingJumps(Diff diff, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2, RawBasicBlock rawBasicBlock) {
        ArrayList<RawJump> arrayList = new ArrayList<RawJump>();
        BasicBlockMatchData basicBlockMatchData = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock);
        if (basicBlockMatchData == null) {
            return GraphGetter.getIncomingJumps(rawBasicBlock);
        }
        RawFlowGraph rawFlowGraph3 = rawBasicBlock.getSide() == ESide.PRIMARY ? rawFlowGraph2 : rawFlowGraph;
        Collection<RawJump> collection = GraphGetter.getIncomingJumps(rawBasicBlock);
        for (RawJump rawJump : collection) {
            RawBasicBlock rawBasicBlock2 = rawJump.getSource();
            BasicBlockMatchData basicBlockMatchData2 = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock2);
            if (basicBlockMatchData2 != null) {
                IAddress iAddress = null;
                IAddress iAddress2 = null;
                if (rawBasicBlock.getSide() == ESide.PRIMARY) {
                    iAddress2 = basicBlockMatchData.getIAddress(ESide.SECONDARY);
                    iAddress = basicBlockMatchData2.getIAddress(ESide.SECONDARY);
                } else {
                    iAddress2 = basicBlockMatchData.getIAddress(ESide.PRIMARY);
                    iAddress = basicBlockMatchData2.getIAddress(ESide.PRIMARY);
                }
                if (rawFlowGraph3.getJump(iAddress, iAddress2) != null) continue;
                arrayList.add(rawJump);
                continue;
            }
            arrayList.add(rawJump);
        }
        return arrayList;
    }

    public static List<RawCall> getUnmatchedOutgoingCalls(Diff diff, RawBasicBlock rawBasicBlock) {
        ArrayList<RawCall> arrayList = new ArrayList<RawCall>();
        List<RawCall> list = GraphGetter.getOutgoingCalls(diff, rawBasicBlock);
        for (RawCall rawCall : list) {
            if (rawCall.getMatchState() == EMatchState.MATCHED || rawCall.isChanged()) continue;
            arrayList.add(rawCall);
        }
        return arrayList;
    }

    public static List<RawCall> getUnmatchedOutgoingCalls(RawFunction rawFunction) {
        ArrayList<RawCall> arrayList = new ArrayList<RawCall>();
        for (SingleViewEdge<? extends SingleViewNode> singleViewEdge : rawFunction.getOutgoingEdges()) {
            RawCall rawCall = (RawCall)singleViewEdge;
            if (rawCall.getMatchState() == EMatchState.MATCHED || rawCall.isChanged()) continue;
            arrayList.add(rawCall);
        }
        return arrayList;
    }

    public static Collection<RawJump> getUnmatchedOutgoingJumps(Diff diff, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2, RawBasicBlock rawBasicBlock) {
        ArrayList<RawJump> arrayList = new ArrayList<RawJump>();
        BasicBlockMatchData basicBlockMatchData = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock);
        if (basicBlockMatchData == null) {
            return GraphGetter.getOutgoingJumps(rawBasicBlock);
        }
        RawFlowGraph rawFlowGraph3 = rawBasicBlock.getSide() == ESide.PRIMARY ? rawFlowGraph2 : rawFlowGraph;
        Collection<RawJump> collection = GraphGetter.getOutgoingJumps(rawBasicBlock);
        for (RawJump rawJump : collection) {
            RawBasicBlock rawBasicBlock2 = rawJump.getTarget();
            BasicBlockMatchData basicBlockMatchData2 = MatchesGetter.getBasicBlockMatch(diff, rawBasicBlock2);
            if (basicBlockMatchData2 != null) {
                IAddress iAddress = null;
                IAddress iAddress2 = null;
                if (rawBasicBlock.getSide() == ESide.PRIMARY) {
                    iAddress = basicBlockMatchData.getIAddress(ESide.SECONDARY);
                    iAddress2 = basicBlockMatchData2.getIAddress(ESide.SECONDARY);
                } else {
                    iAddress = basicBlockMatchData.getIAddress(ESide.PRIMARY);
                    iAddress2 = basicBlockMatchData2.getIAddress(ESide.PRIMARY);
                }
                if (rawFlowGraph3.getJump(iAddress, iAddress2) != null) continue;
                arrayList.add(rawJump);
                continue;
            }
            arrayList.add(rawJump);
        }
        return arrayList;
    }
}

