/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.diff;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.common.io.ByteStreams;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.components.MessageBox;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;

public class FunctionDiffViewSaver
extends CEndlessHelperThread {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final ViewTabPanelFunctions controller;
    private final Window parent;
    private final File primaryExportFileTarget;
    private final File secondaryExportFileTarget;
    private final File binDiffFileTarget;
    private final boolean overridePrimaryExport;
    private final boolean overrideSecondaryExport;
    private boolean cleanupPrimaryExportFile = false;
    private boolean cleanupSecondaryExportFile = false;
    private boolean cleanupBinDiffFile = false;
    private final Diff diffToSave;
    private Diff savedDiff;
    private boolean addSavedDiffToWorkspace = false;

    public FunctionDiffViewSaver(ViewTabPanelFunctions viewTabPanelFunctions, File file, File file2, File file3, boolean bl2, boolean bl3) {
        this.controller = Preconditions.checkNotNull(viewTabPanelFunctions);
        this.parent = viewTabPanelFunctions.getMainWindow();
        this.diffToSave = viewTabPanelFunctions.getGraphs().getDiff();
        this.primaryExportFileTarget = Preconditions.checkNotNull(file);
        this.secondaryExportFileTarget = Preconditions.checkNotNull(file2);
        this.binDiffFileTarget = Preconditions.checkNotNull(file3);
        this.overridePrimaryExport = bl2;
        this.overrideSecondaryExport = bl3;
    }

    private void cleanUp() {
        File file;
        String string = "";
        if (this.primaryExportFileTarget != null && this.primaryExportFileTarget.exists() && this.cleanupPrimaryExportFile && !this.primaryExportFileTarget.delete()) {
            string = String.format("Failed to delete '%s'.\n", this.primaryExportFileTarget.getPath());
        }
        if (this.secondaryExportFileTarget != null && this.secondaryExportFileTarget.exists() && this.cleanupSecondaryExportFile && !this.secondaryExportFileTarget.delete()) {
            string = String.format("Failed to delete '%s'.\n", this.secondaryExportFileTarget.getPath());
        }
        if (this.binDiffFileTarget != null && this.binDiffFileTarget.exists() && this.cleanupBinDiffFile && !this.binDiffFileTarget.delete()) {
            string = String.format("Failed to delete '%s'.\n", this.binDiffFileTarget.getPath());
        }
        if ((file = this.binDiffFileTarget.getParentFile()).list().length == 0 && !file.delete()) {
            string = String.format("Failed to delete '%s'.\n", file.getPath());
        }
        if (!"".equals(string)) {
            string = string.substring(0, string.length() - 2);
            logger.at(Level.WARNING).log(string);
            MessageBox.showWarning(this.parent, string);
        }
    }

    private void cloneDiffObjectOnSaveAs() {
        FlowGraphViewData flowGraphViewData = this.diffToSave.getViewManager().getFlowGraphViewsData().get(0);
        if (this.binDiffFileTarget.exists() && !this.binDiffFileTarget.equals(this.diffToSave.getMatchesDatabase()) && this.diffToSave.getMatchesDatabase().getParent().equals(this.binDiffFileTarget.getParent())) {
            this.diffToSave.willOverwriteDiff(this.binDiffFileTarget.getPath());
            this.savedDiff = this.diffToSave.cloneDiffObjectOnSaveAs(this.binDiffFileTarget, this.primaryExportFileTarget, this.secondaryExportFileTarget, flowGraphViewData);
        } else if (!this.binDiffFileTarget.exists() && this.diffToSave.getMatchesDatabase().getParent().equals(this.binDiffFileTarget.getParent())) {
            this.savedDiff = this.diffToSave.cloneDiffObjectOnSaveAs(this.binDiffFileTarget, this.primaryExportFileTarget, this.secondaryExportFileTarget, flowGraphViewData);
        } else {
            this.addSavedDiffToWorkspace = !this.binDiffFileTarget.equals(this.diffToSave.getMatchesDatabase());
            this.savedDiff = this.diffToSave;
        }
        this.addSavedDiffToWorkspace = this.addSavedDiffToWorkspace || this.savedDiff != this.diffToSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyBinDiffFile() {
        File file = this.diffToSave.getMatchesDatabase();
        if (file.getPath().equals(this.binDiffFileTarget.getPath())) {
            this.savedDiff = this.diffToSave;
            return true;
        }
        this.cleanupBinDiffFile = !this.binDiffFileTarget.exists();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            this.cloneDiffObjectOnSaveAs();
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(this.binDiffFileTarget);
            ByteStreams.copy(fileInputStream, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(fileNotFoundException)).log("Save function diff view failed. Couldn't copy BinDiff file into workspace.");
            MessageBox.showError(this.parent, "Save function diff view failed. Couldn't copy BinDiff file into workspace.");
            boolean bl2 = false;
            return bl2;
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Save function diff view failed. Couldn't copy BinExport files into workspace.");
            MessageBox.showError(this.parent, "Save function diff view failed. Couldn't copy BinExport files into workspace.");
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    ((FluentLogger.Api)logger.at(Level.WARNING).withCause(iOException)).log("Couldn't close file input stream");
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    ((FluentLogger.Api)logger.at(Level.WARNING).withCause(iOException)).log("Couldn't close file output stream");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyExportFile(ESide eSide) {
        File file;
        File file2 = this.diffToSave.getExportFile(eSide);
        File file3 = file = eSide == ESide.PRIMARY ? this.primaryExportFileTarget : this.secondaryExportFileTarget;
        if (file.exists() && (eSide == ESide.PRIMARY && !this.overridePrimaryExport || eSide == ESide.SECONDARY && !this.overrideSecondaryExport)) {
            return true;
        }
        if (file2.getPath().equals(file.getPath())) {
            return true;
        }
        if (eSide == ESide.PRIMARY) {
            this.cleanupPrimaryExportFile = !file.exists();
        } else {
            this.cleanupSecondaryExportFile = !file.exists();
        }
        try {
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                fileOutputStream = new FileOutputStream(file);
                ByteStreams.copy(fileInputStream, fileOutputStream);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        ((FluentLogger.Api)logger.at(Level.WARNING).withCause(iOException)).log("Couldn't close file input stream");
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        ((FluentLogger.Api)logger.at(Level.WARNING).withCause(iOException)).log("Couldn't close file output stream");
                    }
                }
            }
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Save function diff view failed. Couldn't copy BinExport files.");
            MessageBox.showError(this.parent, "Save function diff view failed. Couldn't copy BinExport files.");
            return false;
        }
        return true;
    }

    private void saveView() {
        this.controller.writeComments();
        this.controller.writeFlowgraphMatches();
    }

    private boolean updateDiff() {
        try {
            this.savedDiff.setMatchesDatabase(this.binDiffFileTarget);
            this.savedDiff.setExportFile(this.primaryExportFileTarget, ESide.PRIMARY);
            this.savedDiff.setExportFile(this.secondaryExportFileTarget, ESide.SECONDARY);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(unsupportedOperationException)).log("Save function diff view failed. Couldn't update diff object.");
            MessageBox.showError(this.parent, "Save function diff view failed. Couldn't update diff object.");
            return false;
        }
        return true;
    }

    private boolean updateMatchesDatabase() {
        String string = BinDiffFileUtils.forceFilenameEndsNotWithExtension(this.primaryExportFileTarget.getName(), "BinExport");
        String string2 = BinDiffFileUtils.forceFilenameEndsNotWithExtension(this.secondaryExportFileTarget.getName(), "BinExport");
        if (!this.binDiffFileTarget.exists()) {
            return false;
        }
        try (MatchesDatabase matchesDatabase = new MatchesDatabase(this.binDiffFileTarget);){
            matchesDatabase.changeExportFilename(string, ESide.PRIMARY);
            matchesDatabase.changeExportFilename(string2, ESide.SECONDARY);
            matchesDatabase.changeFileTable(this.savedDiff);
        }
        catch (SQLException sQLException) {
            String string3 = "Save function diff view failed. Couldn't update export file name in matches database.";
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log("Save function diff view failed. Couldn't update export file name in matches database.");
            MessageBox.showError(this.parent, "Save function diff view failed. Couldn't update export file name in matches database. " + sQLException.getMessage());
            return false;
        }
        return true;
    }

    private void updateWorkspace() {
        if (this.addSavedDiffToWorkspace) {
            this.controller.getWorkspace().addDiff(this.savedDiff);
        }
    }

    @Override
    protected void runExpensiveCommand() {
        this.setDescription("Copying primary BinExport file...");
        if (!this.copyExportFile(ESide.PRIMARY)) {
            this.cleanUp();
            return;
        }
        this.setDescription("Copying secondary BinExport file...");
        if (!this.copyExportFile(ESide.SECONDARY)) {
            this.cleanUp();
            return;
        }
        this.setDescription("Copying BinDiff file...");
        if (!this.copyBinDiffFile()) {
            this.cleanUp();
            return;
        }
        this.setDescription("Updating BinDiff database...");
        if (!this.updateMatchesDatabase()) {
            this.cleanUp();
            return;
        }
        this.setDescription("Updating Diff...");
        if (!this.updateDiff()) {
            this.cleanUp();
            return;
        }
        this.setDescription("Saving comments and changed matches...");
        this.saveView();
        this.setDescription("Updating Workspace...");
        this.updateWorkspace();
        this.setDescription("Completed successfully.");
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

