/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.diff;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.database.CommentsDatabase;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.enums.EViewType;
import com.google.security.zynamics.bindiff.exceptions.GraphCreationException;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.builders.ViewFlowGraphBuilder;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.detachedviewstabpanel.FunctionDiffViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelInitializer;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.io.matches.DiffRequestMessage;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.builders.RawCombinedFlowGraphBuilder;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffLoader;
import com.google.security.zynamics.bindiff.project.matches.FunctionDiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedJump;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import java.io.File;

public class FunctionDiffViewLoader
extends CEndlessHelperThread {
    private final DiffRequestMessage data;
    private final MainWindow window;
    private final TabPanelManager tabPanelManager;
    private final Workspace workspace;
    private FlowGraphViewData viewData;

    public FunctionDiffViewLoader(DiffRequestMessage diffRequestMessage, MainWindow mainWindow, TabPanelManager tabPanelManager, Workspace workspace) {
        this.data = Preconditions.checkNotNull(diffRequestMessage);
        this.window = Preconditions.checkNotNull(mainWindow);
        this.tabPanelManager = Preconditions.checkNotNull(tabPanelManager);
        this.workspace = Preconditions.checkNotNull(workspace);
        this.viewData = null;
    }

    private void createSingleFunctionDiffFlowGraphView(Diff diff, FunctionMatchData functionMatchData, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2, RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph) {
        GraphsContainer graphsContainer = ViewFlowGraphBuilder.buildViewFlowGraphs(diff, functionMatchData, rawCombinedFlowGraph);
        RawFunction rawFunction = diff.getFunction(functionMatchData.getIAddress(ESide.PRIMARY), ESide.PRIMARY);
        RawFunction rawFunction2 = diff.getFunction(functionMatchData.getIAddress(ESide.SECONDARY), ESide.SECONDARY);
        String string = diff.getMatchesDatabase().getName();
        string = BinDiffFileUtils.forceFilenameEndsNotWithExtension(string, "BinDiff");
        if (!this.workspace.isLoaded() || diff.getMatchesDatabase().getParent().indexOf(this.workspace.getWorkspaceDirPath()) != 0) {
            string = String.format("%s vs %s", rawFunction.getName(), rawFunction2.getName());
        }
        this.viewData = new FlowGraphViewData(rawFlowGraph, rawFlowGraph2, rawCombinedFlowGraph, graphsContainer, string, EViewType.SINGLE_FUNCTION_DIFF_VIEW);
        diff.getViewManager().addView(this.viewData);
        FunctionDiffViewTabPanel functionDiffViewTabPanel = new FunctionDiffViewTabPanel(this.window, this.tabPanelManager, this.workspace, diff, functionMatchData, this.viewData);
        try {
            ViewTabPanelInitializer.initialize(this.viewData.getGraphs(), this);
        }
        catch (Exception exception) {
            throw new GraphCreationException("An error occurred while initializing the graph.");
        }
        this.tabPanelManager.addTab(functionDiffViewTabPanel);
        ViewTabPanelInitializer.centerSingleGraphs(this.viewData.getGraphs().getSuperGraph());
        ViewTabPanelInitializer.centerCombinedGraph(this.viewData.getGraphs(), functionDiffViewTabPanel);
        this.tabPanelManager.selectTab(functionDiffViewTabPanel);
    }

    @Override
    protected void runExpensiveCommand() {
        File file = new File(this.data.getMatchesDBPath());
        try (MatchesDatabase matchesDatabase = new MatchesDatabase(file);){
            FunctionDiffMetadata functionDiffMetadata = matchesDatabase.loadFunctionDiffMetadata(true);
            File file2 = new File(this.data.getBinExportPath(ESide.PRIMARY));
            File file3 = new File(this.data.getBinExportPath(ESide.SECONDARY));
            Diff diff = this.data.getDiff();
            if (diff == null) {
                diff = new Diff(functionDiffMetadata, file, file2, file3, true);
            }
            DiffLoader diffLoader = new DiffLoader();
            diffLoader.loadDiff(diff, this.data);
            if (diff.getCallGraph(ESide.PRIMARY).getNodes().size() != 1) {
                throw new IllegalStateException("Primary call graph of a single function diff has more than one vertex.");
            }
            if (diff.getCallGraph(ESide.SECONDARY).getNodes().size() != 1) {
                throw new IllegalStateException("Secondary call graph of a single function diff has more than one vertex.");
            }
            RawFunction rawFunction = (RawFunction)diff.getCallGraph(ESide.PRIMARY).getNodes().get(0);
            RawFunction rawFunction2 = (RawFunction)diff.getCallGraph(ESide.SECONDARY).getNodes().get(0);
            rawFunction.setSizeOfBasicBlocks(functionDiffMetadata.getSizeOfBasicBlocks(ESide.PRIMARY));
            rawFunction2.setSizeOfBasicBlocks(functionDiffMetadata.getSizeOfBasicBlocks(ESide.SECONDARY));
            rawFunction.setSizeOfJumps(functionDiffMetadata.getSizeOfJumps(ESide.PRIMARY));
            rawFunction2.setSizeOfJumps(functionDiffMetadata.getSizeOfJumps(ESide.SECONDARY));
            rawFunction.setSizeOfInstructions(functionDiffMetadata.getSizeOfInstructions(ESide.PRIMARY));
            rawFunction2.setSizeOfInstructions(functionDiffMetadata.getSizeOfInstructions(ESide.SECONDARY));
            IAddress iAddress = rawFunction.getAddress();
            IAddress iAddress2 = rawFunction2.getAddress();
            functionDiffMetadata.setFunctionAddr(iAddress, ESide.PRIMARY);
            functionDiffMetadata.setFunctionAddr(iAddress2, ESide.SECONDARY);
            functionDiffMetadata.setFunctionName(rawFunction.getName(), ESide.PRIMARY);
            functionDiffMetadata.setFunctionName(rawFunction2.getName(), ESide.SECONDARY);
            functionDiffMetadata.setFunctionType(rawFunction.getFunctionType(), ESide.PRIMARY);
            functionDiffMetadata.setFunctionType(rawFunction2.getFunctionType(), ESide.SECONDARY);
            FunctionMatchData functionMatchData = diff.getMatches().getFunctionMatch(iAddress, ESide.PRIMARY);
            matchesDatabase.loadBasicBlockMatches(functionMatchData);
            CommentsDatabase commentsDatabase = null;
            if (this.workspace.isLoaded()) {
                commentsDatabase = new CommentsDatabase(this.workspace, true);
            }
            RawFlowGraph rawFlowGraph = DiffLoader.loadRawFlowGraph(commentsDatabase, diff, iAddress, ESide.PRIMARY);
            RawFlowGraph rawFlowGraph2 = DiffLoader.loadRawFlowGraph(commentsDatabase, diff, iAddress2, ESide.SECONDARY);
            RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph = RawCombinedFlowGraphBuilder.buildRawCombinedFlowGraph(functionMatchData, rawFlowGraph, rawFlowGraph2);
            this.createSingleFunctionDiffFlowGraphView(diff, functionMatchData, rawFlowGraph, rawFlowGraph2, rawCombinedFlowGraph);
        }
    }
}

