/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.diff;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.database.CommentsDatabase;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.database.SqliteDatabase;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.enums.EViewType;
import com.google.security.zynamics.bindiff.exceptions.GraphCreationException;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.builders.ViewFlowGraphBuilder;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.detachedviewstabpanel.FunctionDiffViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelInitializer;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.builders.RawCombinedFlowGraphBuilder;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffLoader;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedJump;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Triple;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashSet;

public class FlowGraphViewLoader
extends CEndlessHelperThread {
    private final TabPanelManager tabPanelManager;
    private final MainWindow window;
    private final Workspace workspace;
    private final LinkedHashSet<Triple<Diff, IAddress, IAddress>> viewsAddrs;

    public FlowGraphViewLoader(MainWindow mainWindow, TabPanelManager tabPanelManager, Workspace workspace, LinkedHashSet<Triple<Diff, IAddress, IAddress>> linkedHashSet) {
        this.tabPanelManager = Preconditions.checkNotNull(tabPanelManager);
        this.window = Preconditions.checkNotNull(mainWindow);
        this.workspace = Preconditions.checkNotNull(workspace);
        this.viewsAddrs = Preconditions.checkNotNull(linkedHashSet);
    }

    private void createFlowGraphView(FlowGraphViewData flowGraphViewData) {
        ViewTabPanel viewTabPanel;
        Diff diff = flowGraphViewData.getGraphs().getDiff();
        if (diff.isFunctionDiff()) {
            FunctionMatchData functionMatchData = diff.getMatches().getFunctionMatches()[0];
            viewTabPanel = new FunctionDiffViewTabPanel(this.window, this.tabPanelManager, this.workspace, diff, functionMatchData, flowGraphViewData);
        } else {
            viewTabPanel = new ViewTabPanel(this.window, this.tabPanelManager, this.workspace, diff, flowGraphViewData);
        }
        try {
            ViewTabPanelInitializer.initialize(flowGraphViewData.getGraphs(), this);
        }
        catch (Exception exception) {
            throw new GraphCreationException("An error occurred while initializing the graph.");
        }
        this.tabPanelManager.addTab(viewTabPanel);
        ViewTabPanelInitializer.centerSingleGraphs(flowGraphViewData.getGraphs().getSuperGraph());
        ViewTabPanelInitializer.centerCombinedGraph(flowGraphViewData.getGraphs(), viewTabPanel);
        this.tabPanelManager.selectTab(viewTabPanel);
    }

    private FlowGraphViewData loadFlowGraphViewData(Diff diff, IAddress iAddress, IAddress iAddress2) {
        CommentsDatabase commentsDatabase = this.workspace.getWorkspaceFile() != null ? new CommentsDatabase(this.workspace, true) : null;
        RawFlowGraph rawFlowGraph = null;
        RawFlowGraph rawFlowGraph2 = null;
        FunctionMatchData functionMatchData = this.loadFunctionMatchData(diff, iAddress, iAddress2);
        if (iAddress != null) {
            this.setDescription("Loading primary raw function data...");
            rawFlowGraph = DiffLoader.loadRawFlowGraph(commentsDatabase, diff, iAddress, ESide.PRIMARY);
        }
        if (iAddress2 != null) {
            this.setDescription("Loading secondary raw function data...");
            rawFlowGraph2 = DiffLoader.loadRawFlowGraph(commentsDatabase, diff, iAddress2, ESide.SECONDARY);
        }
        this.setDescription("Building combined flow graph...");
        RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> rawCombinedFlowGraph = RawCombinedFlowGraphBuilder.buildRawCombinedFlowGraph(functionMatchData, rawFlowGraph, rawFlowGraph2);
        this.setDescription("Creating flow graph view...");
        GraphsContainer graphsContainer = ViewFlowGraphBuilder.buildViewFlowGraphs(diff, functionMatchData, rawCombinedFlowGraph);
        FlowGraphViewData flowGraphViewData = new FlowGraphViewData(rawFlowGraph, rawFlowGraph2, rawCombinedFlowGraph, graphsContainer, FlowGraphViewData.getViewName(graphsContainer), EViewType.FUNCTION_DIFF_VIEW);
        diff.getViewManager().addView(flowGraphViewData);
        return flowGraphViewData;
    }

    private FunctionMatchData loadFunctionMatchData(Diff diff, IAddress iAddress, IAddress iAddress2) {
        FunctionMatchData functionMatchData = diff.getMatches().getFunctionMatch(iAddress, ESide.PRIMARY);
        if (functionMatchData != null) {
            try {
                Object object;
                String string = diff.getDiffName();
                if (!diff.isFunctionDiff()) {
                    object = diff.getCallGraph(ESide.PRIMARY).getFunction(iAddress);
                    RawFunction rawFunction = diff.getCallGraph(ESide.SECONDARY).getFunction(iAddress2);
                    if (object != null) {
                        string = ((RawFunction)object).getName();
                    }
                    if (rawFunction != null) {
                        string = string + (object == null ? rawFunction.getName() : " vs " + rawFunction.getName());
                    }
                }
                object = new MatchesDatabase(diff.getMatchesDatabase());
                try {
                    this.setGeneralDescription(String.format("Loading '%s'", string));
                    this.setDescription("Please wait...");
                    ((MatchesDatabase)object).loadBasicBlockMatches(functionMatchData);
                }
                finally {
                    ((SqliteDatabase)object).close();
                }
            }
            catch (IOException | SQLException exception) {
                throw new IOException("Couldn't read flow graph basic block and instruction matches from database: " + exception.getMessage());
            }
        }
        return functionMatchData;
    }

    @Override
    protected void runExpensiveCommand() {
        for (Triple triple : this.viewsAddrs) {
            FlowGraphViewData flowGraphViewData = this.loadFlowGraphViewData((Diff)triple.first(), (IAddress)triple.second(), (IAddress)triple.third());
            this.createFlowGraphView(flowGraphViewData);
        }
    }
}

