/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.diff;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.database.CommentsDatabase;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.enums.EFunctionType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.io.BinExport2Reader;
import com.google.security.zynamics.bindiff.io.matches.DiffRequestMessage;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.IDiffListener;
import com.google.security.zynamics.bindiff.project.matches.AddressPair;
import com.google.security.zynamics.bindiff.project.matches.AddressTriple;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.FunctionDiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCall;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstruction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstructionComment;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawJump;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IProgressDescription;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.types.common.ICommand;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class DiffLoader
implements ICommand {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private IProgressDescription descriptionTarget = null;
    private final LinkedHashSet<Diff> diffs;

    public DiffLoader() {
        this.diffs = null;
    }

    public DiffLoader(LinkedHashSet<Diff> linkedHashSet) {
        this.diffs = Preconditions.checkNotNull(linkedHashSet);
    }

    private static void setBasicBlockComments(RawFlowGraph rawFlowGraph, Map<IAddress, String> map) {
        for (Map.Entry<IAddress, String> entry : map.entrySet()) {
            RawBasicBlock rawBasicBlock = rawFlowGraph.getBasicblock(entry.getKey());
            rawBasicBlock.setComment(entry.getValue());
        }
    }

    private static void setInstructionComment(RawFlowGraph rawFlowGraph, Map<Pair<IAddress, ECommentPlacement>, String> map) {
        for (RawBasicBlock rawBasicBlock : rawFlowGraph.getNodes()) {
            for (Map.Entry<IAddress, RawInstruction> entry : rawBasicBlock.getInstructions().entrySet()) {
                String string;
                Pair<IAddress, ECommentPlacement> pair;
                IAddress iAddress = entry.getKey();
                if (entry.getValue().getComments() != null) {
                    for (RawInstructionComment rawInstructionComment : entry.getValue().getComments()) {
                        pair = Pair.make(iAddress, rawInstructionComment.getPlacement());
                        string = map.get(pair);
                        if (string == null) continue;
                        String string2 = rawInstructionComment.getText();
                        if (!string.equals(string2) && string.indexOf(string2) != 0) {
                            string2 = string2 + " // " + string;
                        }
                        string2 = string;
                        rawInstructionComment.setText(string2);
                    }
                    continue;
                }
                Pair<IAddress, ECommentPlacement> pair2 = Pair.make(iAddress, ECommentPlacement.ABOVE_LINE);
                Pair<IAddress, ECommentPlacement> pair3 = Pair.make(iAddress, ECommentPlacement.BEHIND_LINE);
                pair = map.get(pair2);
                string = map.get(pair3);
                if (pair != null) {
                    entry.getValue().setComment((String)((Object)pair), ECommentPlacement.ABOVE_LINE);
                }
                if (string == null) continue;
                entry.getValue().setComment(string, ECommentPlacement.BEHIND_LINE);
            }
        }
    }

    public static RawFlowGraph loadRawFlowGraph(CommentsDatabase commentsDatabase, Diff diff, IAddress iAddress, ESide eSide) {
        BinExport2Reader binExport2Reader = new BinExport2Reader(diff.getExportFile(ESide.PRIMARY), ESide.PRIMARY);
        BinExport2Reader binExport2Reader2 = new BinExport2Reader(diff.getExportFile(ESide.SECONDARY), ESide.SECONDARY);
        RawFunction rawFunction = diff.getCallGraph(eSide).getFunction(iAddress);
        if (rawFunction == null) {
            return null;
        }
        if (rawFunction.getFunctionType() == EFunctionType.IMPORTED) {
            return new RawFlowGraph(iAddress, rawFunction.getName(), rawFunction.getFunctionType(), new ArrayList<RawBasicBlock>(), new ArrayList<RawJump>(), eSide);
        }
        RawFlowGraph rawFlowGraph = eSide == ESide.PRIMARY ? binExport2Reader.readFlowGraph(diff, iAddress) : binExport2Reader2.readFlowGraph(diff, iAddress);
        String string = diff.getDiffMetaData().getImageHash(eSide);
        if (commentsDatabase != null) {
            Map<Pair<IAddress, ECommentPlacement>, String> map = commentsDatabase.readInstructionComments(string, iAddress);
            Map<IAddress, String> map2 = commentsDatabase.readBasicblockComments(string, iAddress);
            DiffLoader.setBasicBlockComments(rawFlowGraph, map2);
            DiffLoader.setInstructionComment(rawFlowGraph, map);
        }
        return rawFlowGraph;
    }

    public static DiffMetadata preloadDiffMatches(File file) {
        try (MatchesDatabase matchesDatabase = new MatchesDatabase(file);){
            DiffMetadata diffMetadata = matchesDatabase.loadDiffMetadata(file);
            return diffMetadata;
        }
    }

    void loadDiff(Diff diff, DiffRequestMessage diffRequestMessage) {
        if (diff.isLoaded()) {
            logger.at(Level.INFO).log("Diff is already loaded");
            return;
        }
        if (this.descriptionTarget != null) {
            this.descriptionTarget.setDescription(String.format("Loading Diff '%s'", diff.getDiffName()));
        }
        logger.at(Level.INFO).log("Loading Diff '%s'", diff.getDiffName());
        this.validateInputFiles(diff);
        this.setSubDescription("Loading function matches...");
        this.loadDiffMatches(diff);
        this.setSubDescription("Loading exports...");
        this.loadRawCallGraphs(diff, diffRequestMessage);
        this.setSubDescription("Setting function matches...");
        this.setFunctionMatches(diff);
        this.setSubDescription("Loading call matches...");
        this.setCallMatches(diff);
        this.setChangedFunctionsCount(diff);
        diff.setLoaded(true);
        this.setSubDescription("Preparing UI...");
        SwingUtilities.invokeLater(() -> {
            for (IDiffListener iDiffListener : diff.getListener()) {
                iDiffListener.loadedDiff(diff);
            }
        });
    }

    private void loadDiffMatches(Diff diff) {
        File file = diff.getMatchesDatabase();
        if (!file.exists()) {
            throw new IOException(String.format("Couldn't find '%s%s%s'.", file.getPath(), File.separator, file.getName()));
        }
        logger.at(Level.INFO).log(" - Loading Diff '%s'", file.getPath());
        try (MatchesDatabase matchesDatabase = new MatchesDatabase(file);){
            diff.setMatches(matchesDatabase.loadFunctionMatches(diff));
        }
    }

    private void loadRawCallGraphs(Diff diff, DiffRequestMessage diffRequestMessage) {
        RawCallGraph rawCallGraph;
        RawCallGraph rawCallGraph2;
        BinExport2Reader binExport2Reader = new BinExport2Reader(diff.getExportFile(ESide.PRIMARY), ESide.PRIMARY);
        BinExport2Reader binExport2Reader2 = new BinExport2Reader(diff.getExportFile(ESide.SECONDARY), ESide.SECONDARY);
        if (!diff.isFunctionDiff()) {
            this.setSubDescription("Reading raw primary call graph...");
            rawCallGraph2 = binExport2Reader.readCallGraph();
            this.setSubDescription("Reading raw secondary call graph...");
            rawCallGraph = binExport2Reader2.readCallGraph();
        } else if (diffRequestMessage != null) {
            this.setSubDescription("Reading raw primary call graph...");
            rawCallGraph2 = binExport2Reader.readSingleFunctionDiffCallGraph(diffRequestMessage);
            this.setSubDescription("Reading raw secondary call graph...");
            rawCallGraph = binExport2Reader2.readSingleFunctionDiffCallGraph(diffRequestMessage);
        } else {
            FunctionDiffMetadata functionDiffMetadata = (FunctionDiffMetadata)diff.getMetadata();
            String string = functionDiffMetadata.getFunctionName(ESide.PRIMARY);
            EFunctionType eFunctionType = functionDiffMetadata.getFunctionType(ESide.PRIMARY);
            IAddress iAddress = diff.getMatches().getFunctionMatches()[0].getIAddress(ESide.PRIMARY);
            RawFunction rawFunction = new RawFunction(iAddress, string, eFunctionType, ESide.PRIMARY);
            ArrayList<RawFunction> arrayList = new ArrayList<RawFunction>();
            arrayList.add(rawFunction);
            rawCallGraph2 = new RawCallGraph(arrayList, new ArrayList<RawCall>(), ESide.PRIMARY);
            String string2 = functionDiffMetadata.getFunctionName(ESide.SECONDARY);
            EFunctionType eFunctionType2 = functionDiffMetadata.getFunctionType(ESide.SECONDARY);
            IAddress iAddress2 = diff.getMatches().getFunctionMatches()[0].getIAddress(ESide.SECONDARY);
            RawFunction rawFunction2 = new RawFunction(iAddress2, string2, eFunctionType2, ESide.SECONDARY);
            ArrayList<RawFunction> arrayList2 = new ArrayList<RawFunction>();
            arrayList2.add(rawFunction2);
            rawCallGraph = new RawCallGraph(arrayList2, new ArrayList<RawCall>(), ESide.SECONDARY);
            try (MatchesDatabase matchesDatabase = new MatchesDatabase(diff.getMatchesDatabase());){
                matchesDatabase.setFunctionDiffCounts(rawFunction, rawFunction2);
            }
        }
        diff.setCallGraph(rawCallGraph2, ESide.PRIMARY);
        diff.setCallGraph(rawCallGraph, ESide.SECONDARY);
        if (!diff.isFunctionDiff()) {
            this.setSubDescription("Preprocessing raw primary flow graphs...");
            binExport2Reader.readFlowGraphsStatistics(diff);
            this.setSubDescription("Preprocessing raw secondary flow graphs...");
            binExport2Reader2.readFlowGraphsStatistics(diff);
        }
    }

    private void setCallMatches(Diff diff) {
        File file = diff.getMatchesDatabase();
        if (!file.exists()) {
            throw new IOException(String.format("Couldn't find '%s%s%s'.", file.getPath(), File.separator, file.getName()));
        }
        try (MatchesDatabase matchesDatabase = new MatchesDatabase(file);){
            long l2;
            long l3;
            int n2 = 0;
            Map<AddressPair, AddressPair> map = matchesDatabase.loadMatchedCallAddresses(diff);
            ImmutableMap immutableMap = Maps.uniqueIndex(diff.getCallGraph(ESide.SECONDARY).getEdges(), rawCall -> new AddressTriple(((RawFunction)rawCall.getSource()).getAddress().toLong(), ((RawFunction)rawCall.getTarget()).getAddress().toLong(), rawCall.getSourceInstructionAddr().toLong()));
            for (Object object : diff.getCallGraph(ESide.PRIMARY).getEdges()) {
                long l4;
                AddressTriple addressTriple;
                RawCall rawCall2;
                Object object2 = (RawFunction)((CViewEdge)object).getSource();
                RawFunction rawFunction = (RawFunction)((CViewEdge)object).getTarget();
                l3 = ((SingleViewNode)object2).getAddress().toLong();
                l2 = ((RawCall)object).getSourceInstructionAddr().toLong();
                if (((RawFunction)object2).getMatchedFunction() == null || rawFunction.getMatchedFunction() == null) continue;
                long l5 = ((RawFunction)object2).getMatchedFunction().getAddress().toLong();
                long l6 = rawFunction.getMatchedFunction().getAddress().toLong();
                AddressPair addressPair = new AddressPair(l3, l2);
                AddressPair addressPair2 = map.get(addressPair);
                if (addressPair2 == null || (rawCall2 = (RawCall)immutableMap.get(addressTriple = new AddressTriple(l5, l6, l4 = addressPair2.getAddress(ESide.SECONDARY)))) == null) continue;
                ((RawCall)object).setMatchState(true, rawCall2);
                rawCall2.setMatchState(true, (RawCall)object);
                ++n2;
            }
            HashMap hashMap = new HashMap();
            for (Object object2 : diff.getCallGraph(ESide.SECONDARY).getEdges()) {
                long l7;
                if (((RawCall)object2).getMatchedCall() != null) continue;
                long l8 = ((RawFunction)((CViewEdge)object2).getSource()).getAddress().toLong();
                AddressPair addressPair = new AddressPair(l8, l7 = ((RawCall)object2).getSourceInstructionAddr().toLong());
                Stack stack = (Stack)hashMap.get(addressPair);
                if (stack == null) {
                    stack = new Stack();
                    hashMap.put(addressPair, stack);
                }
                stack.push(object2);
            }
            int n3 = 0;
            for (RawCall rawCall3 : diff.getCallGraph(ESide.PRIMARY).getEdges()) {
                Stack stack;
                AddressPair addressPair;
                AddressPair addressPair3;
                if (rawCall3.getMatchedCall() != null) continue;
                l3 = ((RawFunction)rawCall3.getSource()).getAddress().toLong();
                l2 = rawCall3.getSourceInstructionAddr().toLong();
                if (((RawFunction)rawCall3.getSource()).getMatchedFunction() == null || (addressPair3 = map.get(addressPair = new AddressPair(l3, l2))) == null || (stack = (Stack)hashMap.get(addressPair3)) == null || stack.size() <= 0) continue;
                RawCall rawCall4 = (RawCall)stack.pop();
                rawCall3.setMatchState(false, rawCall4);
                rawCall4.setMatchState(false, rawCall3);
                ++n3;
            }
            diff.getMatches().setSizeOfMatchedCalls(n2 + n3);
            diff.getMatches().setSizeOfChangedCalls(n3);
        }
    }

    private void setChangedFunctionsCount(Diff diff) {
        int n2 = 0;
        for (RawFunction rawFunction : diff.getCallGraph(ESide.PRIMARY).getNodes()) {
            if (!rawFunction.isChanged()) continue;
            ++n2;
        }
        diff.getMatches().setSizeOfChangedFunctions(n2);
    }

    private void setFunctionMatches(Diff diff) {
        RawCallGraph rawCallGraph = diff.getCallGraph(ESide.PRIMARY);
        RawCallGraph rawCallGraph2 = diff.getCallGraph(ESide.SECONDARY);
        for (FunctionMatchData functionMatchData : diff.getMatches().getFunctionMatches()) {
            RawFunction rawFunction = rawCallGraph.getFunction(functionMatchData.getIAddress(ESide.PRIMARY));
            RawFunction rawFunction2 = rawCallGraph2.getFunction(functionMatchData.getIAddress(ESide.SECONDARY));
            if (rawFunction == null || rawFunction2 == null) continue;
            rawFunction.setMatch(rawFunction2, functionMatchData);
            rawFunction2.setMatch(rawFunction, functionMatchData);
        }
    }

    private void setSubDescription(String string) {
        if (this.descriptionTarget != null) {
            this.descriptionTarget.setSubDescription(string);
        }
    }

    private void validateInputFiles(Diff diff) {
        if (!diff.getMatchesDatabase().exists()) {
            throw new IOException("Load Diff graphs failed. Matches database file can not be found.");
        }
        if (!diff.getExportFile(ESide.PRIMARY).exists()) {
            throw new IOException("Load Diff graphs failed. Primary exported file can not be found.");
        }
        if (!diff.getExportFile(ESide.SECONDARY).exists()) {
            throw new IOException("Load Diff graphs failed. Secondary exported file can not be found.");
        }
        if (!diff.getExportFile(ESide.PRIMARY).canRead()) {
            throw new IOException("Load Diff graphs failed. Couldn't read primary exported call graph file.");
        }
        if (!diff.getExportFile(ESide.SECONDARY).canRead()) {
            throw new IOException("Load Diff graphs failed. Couldn't read secondary exported call graph file.");
        }
    }

    @Override
    public void execute() {
        for (Diff diff : this.diffs) {
            this.loadDiff(diff, null);
        }
    }

    public void setProgressDescriptionTarget(IProgressDescription iProgressDescription) {
        this.descriptionTarget = iProgressDescription;
    }
}

