/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.diff;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.project.diff.IDiffListener;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.MatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.project.userview.ViewManager;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.io.File;
import java.util.logging.Level;

public final class Diff {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final ListenerProvider<IDiffListener> listenerProvider = new ListenerProvider();
    private File matchesDatabaseFile;
    private File primaryExportFile;
    private File secondaryExportFile;
    private String priExportMD5 = null;
    private String secExportMD5 = null;
    private final ViewManager viewManager = new ViewManager();
    private RawCallGraph primaryCallGraph = null;
    private RawCallGraph secondaryCallGraph = null;
    private final DiffMetadata metadata;
    private final boolean isFunctionDiff;
    private MatchData matches;
    private boolean loaded = false;

    public Diff(DiffMetadata diffMetadata, File file, File file2, File file3, boolean bl2) {
        this.metadata = Preconditions.checkNotNull(diffMetadata);
        this.matchesDatabaseFile = Preconditions.checkNotNull(file);
        this.primaryExportFile = Preconditions.checkNotNull(file2);
        this.secondaryExportFile = Preconditions.checkNotNull(file3);
        this.isFunctionDiff = bl2;
    }

    private void close() {
        this.primaryCallGraph = null;
        this.secondaryCallGraph = null;
        if (this.matches != null) {
            this.matches.close();
        }
        this.loaded = false;
    }

    Diff cloneDiffObjectOnSaveAs(File file, File file2, File file3, FlowGraphViewData flowGraphViewData) {
        this.viewManager.removeView(flowGraphViewData);
        Diff diff = new Diff(this.metadata, file, file2, file3, true);
        diff.primaryExportFile = file2;
        diff.secondaryExportFile = file3;
        diff.priExportMD5 = this.priExportMD5;
        diff.secExportMD5 = this.secExportMD5;
        diff.loaded = this.loaded;
        diff.viewManager.addView(flowGraphViewData);
        diff.primaryCallGraph = this.primaryCallGraph;
        diff.secondaryCallGraph = this.secondaryCallGraph;
        diff.matches = this.matches;
        flowGraphViewData.setViewName(BinDiffFileUtils.forceFilenameEndsNotWithExtension(file.getName(), "BinDiff"));
        flowGraphViewData.getGraphs().setDiff(diff);
        return diff;
    }

    public void addListener(IDiffListener iDiffListener) {
        this.listenerProvider.addListener(iDiffListener);
    }

    public void closeDiff() {
        logger.at(Level.INFO).log("Unloading Diff '%s'", this.getDiffName());
        if (this.matches == null) {
            return;
        }
        this.close();
        for (IDiffListener iDiffListener : this.listenerProvider) {
            iDiffListener.unloadedDiff(this);
        }
    }

    public String getBinExportMD5(ESide eSide) {
        if (this.priExportMD5 == null) {
            this.priExportMD5 = FileUtils.calcMD5(this.primaryExportFile);
        }
        if (this.secExportMD5 == null) {
            this.secExportMD5 = FileUtils.calcMD5(this.secondaryExportFile);
        }
        return ESide.PRIMARY == eSide ? this.priExportMD5 : this.secExportMD5;
    }

    public RawCallGraph getCallGraph(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.primaryCallGraph : this.secondaryCallGraph;
    }

    public String getDiffFolder() {
        return this.getMatchesDatabase().getParent();
    }

    public DiffMetadata getDiffMetaData() {
        return this.metadata;
    }

    public String getDiffName() {
        return this.matchesDatabaseFile.getName();
    }

    public File getExportFile(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.primaryExportFile : this.secondaryExportFile;
    }

    public RawFunction getFunction(IAddress iAddress, ESide eSide) {
        return this.getCallGraph(eSide).getFunction(iAddress);
    }

    public ListenerProvider<IDiffListener> getListener() {
        return this.listenerProvider;
    }

    public MatchData getMatches() {
        return this.matches;
    }

    public File getMatchesDatabase() {
        return this.matchesDatabaseFile;
    }

    public DiffMetadata getMetadata() {
        return this.metadata;
    }

    public ViewManager getViewManager() {
        return this.viewManager;
    }

    public boolean isFunctionDiff() {
        return this.isFunctionDiff;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void removeDiff() {
        logger.at(Level.INFO).log("Removing Diff '%s'", this.getDiffName());
        this.close();
        for (IDiffListener iDiffListener : this.listenerProvider) {
            iDiffListener.unloadedDiff(this);
        }
        for (IDiffListener iDiffListener : this.listenerProvider) {
            iDiffListener.removedDiff(this);
        }
    }

    public void removeListener(IDiffListener iDiffListener) {
        this.listenerProvider.removeListener(iDiffListener);
    }

    public void setCallGraph(RawCallGraph rawCallGraph, ESide eSide) {
        if (eSide == ESide.PRIMARY) {
            this.primaryCallGraph = rawCallGraph;
        } else {
            this.secondaryCallGraph = rawCallGraph;
        }
    }

    public void setExportFile(File file, ESide eSide) {
        if (!this.isFunctionDiff()) {
            throw new UnsupportedOperationException("Unsupported operation: Export file names can only be updated if the diff is a function diff.");
        }
        if (eSide == ESide.PRIMARY) {
            this.primaryExportFile = file;
            this.priExportMD5 = null;
        } else {
            this.secondaryExportFile = file;
            this.secExportMD5 = null;
        }
    }

    public void setLoaded(boolean bl2) {
        this.loaded = bl2;
    }

    public void setMatches(MatchData matchData) {
        this.matches = matchData;
    }

    public void setMatchesDatabase(File file) {
        if (!this.isFunctionDiff()) {
            throw new UnsupportedOperationException("Matches database file can only be updated if the diff is a function diff.");
        }
        this.matchesDatabaseFile = file;
    }

    public void willOverwriteDiff(String string) {
        for (IDiffListener iDiffListener : this.listenerProvider) {
            iDiffListener.willOverwriteDiff(string);
        }
    }
}

