/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.diff;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.enums.EDiffViewMode;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.enums.EViewType;
import com.google.security.zynamics.bindiff.exceptions.GraphCreationException;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.builders.ViewCallGraphBuilder;
import com.google.security.zynamics.bindiff.graph.helpers.GraphZoomer;
import com.google.security.zynamics.bindiff.graph.searchers.GraphAddressSearcher;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelInitializer;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.io.matches.DiffRequestMessage;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.builders.RawCombinedCallGraphBuilder;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffLoader;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.FunctionDiffMetadata;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedCallGraph;
import com.google.security.zynamics.bindiff.project.userview.CallGraphViewData;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.io.File;

public class CallGraphViewLoader
extends CEndlessHelperThread {
    private final DiffRequestMessage data;
    private final MainWindow window;
    private final TabPanelManager tabPanelManager;
    private final Workspace workspace;

    public CallGraphViewLoader(Diff diff, MainWindow mainWindow, TabPanelManager tabPanelManager, Workspace workspace) {
        this(new DiffRequestMessage(Preconditions.checkNotNull(diff)), mainWindow, tabPanelManager, workspace);
    }

    public CallGraphViewLoader(DiffRequestMessage diffRequestMessage, MainWindow mainWindow, TabPanelManager tabPanelManager, Workspace workspace) {
        this.data = Preconditions.checkNotNull(diffRequestMessage);
        this.window = Preconditions.checkNotNull(mainWindow);
        this.tabPanelManager = Preconditions.checkNotNull(tabPanelManager);
        this.workspace = Preconditions.checkNotNull(workspace);
    }

    private static void zoomToMatch(IAddress iAddress, BinDiffGraph<?, ?> binDiffGraph) {
        ZyGraphNode zyGraphNode = null;
        if (binDiffGraph instanceof SingleGraph) {
            zyGraphNode = GraphAddressSearcher.searchAddress((SingleGraph)binDiffGraph, iAddress);
        } else if (binDiffGraph instanceof CombinedGraph) {
            zyGraphNode = GraphAddressSearcher.searchAddress((CombinedGraph)binDiffGraph, ESide.PRIMARY, iAddress);
        }
        if (zyGraphNode != null) {
            GraphZoomer.zoomToNode(binDiffGraph, zyGraphNode);
        }
    }

    private void createCallGraphView(Diff diff, CallGraphViewData callGraphViewData) {
        ViewTabPanel viewTabPanel = new ViewTabPanel(this.window, this.tabPanelManager, this.workspace, diff, callGraphViewData);
        this.tabPanelManager.addTab(viewTabPanel);
        this.setDescription("Creating view...");
        try {
            BinDiffGraph binDiffGraph;
            GraphsContainer graphsContainer = callGraphViewData.getGraphs();
            ViewTabPanelInitializer.initialize(graphsContainer, this);
            this.tabPanelManager.selectTab(viewTabPanel);
            EDiffViewMode eDiffViewMode = viewTabPanel.getController().getGraphSettings().getDiffViewMode();
            BinDiffGraph binDiffGraph2 = binDiffGraph = eDiffViewMode == EDiffViewMode.NORMAL_VIEW ? graphsContainer.getPrimaryGraph() : graphsContainer.getCombinedGraph();
            if (binDiffGraph != null) {
                CallGraphViewLoader.zoomToMatch(new CAddress(this.data.getFunctionAddress(ESide.PRIMARY)), binDiffGraph);
            }
        }
        catch (Exception exception) {
            throw new GraphCreationException("An error occurred while initializing the graph.");
        }
    }

    private CallGraphViewData loadCallGraphViewData(Diff diff) {
        RawCallGraph rawCallGraph = diff.getCallGraph(ESide.PRIMARY);
        RawCallGraph rawCallGraph2 = diff.getCallGraph(ESide.SECONDARY);
        this.setDescription("Building raw call graph...");
        RawCombinedCallGraph rawCombinedCallGraph = RawCombinedCallGraphBuilder.buildCombinedCallgraph(diff.getMatches(), rawCallGraph, rawCallGraph2);
        this.setDescription("Building view call graph...");
        GraphsContainer graphsContainer = ViewCallGraphBuilder.buildDiffCallgraphs(diff, rawCombinedCallGraph);
        DiffMetadata diffMetadata = diff.getMetadata();
        CallGraphViewData callGraphViewData = new CallGraphViewData(rawCallGraph, rawCallGraph2, graphsContainer, FlowGraphViewData.getViewName(graphsContainer), diffMetadata.getDisplayName(ESide.PRIMARY), diffMetadata.getDisplayName(ESide.SECONDARY), EViewType.FUNCTION_DIFF_VIEW);
        diff.getViewManager().addView(callGraphViewData);
        return callGraphViewData;
    }

    @Override
    protected void runExpensiveCommand() {
        Object object;
        Diff diff = this.data.getDiff();
        if (diff == null) {
            object = new File(this.data.getMatchesDBPath());
            try (MatchesDatabase matchesDatabase = new MatchesDatabase((File)object);){
                FunctionDiffMetadata functionDiffMetadata = matchesDatabase.loadFunctionDiffMetadata(true);
                File file = new File(this.data.getBinExportPath(ESide.PRIMARY));
                File file2 = new File(this.data.getBinExportPath(ESide.SECONDARY));
                diff = new Diff(functionDiffMetadata, (File)object, file, file2, false);
                DiffLoader diffLoader = new DiffLoader();
                diffLoader.loadDiff(diff, this.data);
            }
        }
        object = this.loadCallGraphViewData(diff);
        this.createCallGraphView(diff, (CallGraphViewData)object);
    }
}

