/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.builders;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.exceptions.GraphCreationException;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedJump;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawJump;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;

public class RawCombinedFlowGraphBuilder {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    private static RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> buildMatchedCombinedFlowGraph(FunctionMatchData functionMatchData, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2) {
        Object object;
        Object object2;
        Object object3;
        Pair<Object, Object> pair;
        Object object4;
        Object object5;
        Object object6;
        IAddress iAddress;
        Object object72;
        IAddress iAddress2 = rawFlowGraph.getAddress();
        IAddress iAddress3 = rawFlowGraph2.getAddress();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<RawCombinedJump<RawCombinedBasicBlock>> arrayList2 = new ArrayList<RawCombinedJump<RawCombinedBasicBlock>>();
        HashMap<Pair<Object, Object>, Object> hashMap = new HashMap<Pair<Object, Object>, Object>();
        for (Object object8 : rawFlowGraph) {
            object72 = ((SingleViewNode)object8).getAddress();
            iAddress = functionMatchData.getSecondaryBasicblockAddr((IAddress)object72);
            object6 = null;
            if (iAddress != null) {
                object6 = rawFlowGraph2.getBasicblock(iAddress);
            }
            object5 = functionMatchData.getBasicBlockMatch((IAddress)object72, ESide.PRIMARY);
            object4 = new RawCombinedBasicBlock((RawBasicBlock)object8, (RawBasicBlock)object6, (BasicBlockMatchData)object5, iAddress2, iAddress3);
            hashMap.put(new Pair<Object, IAddress>(object72, iAddress), object4);
            arrayList.add(object4);
        }
        for (Object object8 : rawFlowGraph2) {
            object72 = ((SingleViewNode)object8).getAddress();
            iAddress = functionMatchData.getPrimaryBasicblockAddr((IAddress)object72);
            if (iAddress != null) continue;
            object6 = new RawCombinedBasicBlock(null, (RawBasicBlock)object8, null, iAddress2, iAddress3);
            hashMap.put(new Pair<Object, Object>(null, object72), object6);
            arrayList.add(object6);
        }
        for (Object object8 : rawFlowGraph.getEdges()) {
            object72 = ((RawJump)object8).getSource().getAddress();
            iAddress = ((RawJump)object8).getTarget().getAddress();
            object6 = functionMatchData.getSecondaryBasicblockAddr((IAddress)object72);
            object5 = functionMatchData.getSecondaryBasicblockAddr(iAddress);
            object4 = new Pair<Object, Object>(object72, object6);
            pair = new Pair<IAddress, Object>(iAddress, object5);
            object3 = rawFlowGraph2.getJump((IAddress)object6, (IAddress)object5);
            RawCombinedBasicBlock rawCombinedBasicBlock = (RawCombinedBasicBlock)hashMap.get(object4);
            object2 = (RawCombinedBasicBlock)hashMap.get(pair);
            object = new RawCombinedJump<RawCombinedBasicBlock>(rawCombinedBasicBlock, (RawCombinedBasicBlock)object2, (RawJump)object8, (RawJump)object3);
            arrayList2.add((RawCombinedJump<RawCombinedBasicBlock>)object);
        }
        HashSet hashSet = new HashSet(rawFlowGraph.getEdges());
        for (Object object72 : rawFlowGraph2.getEdges()) {
            iAddress = ((RawJump)object72).getSource().getAddress();
            object6 = ((RawJump)object72).getTarget().getAddress();
            object5 = functionMatchData.getPrimaryBasicblockAddr(iAddress);
            object4 = functionMatchData.getPrimaryBasicblockAddr((IAddress)object6);
            pair = new Pair<Object, IAddress>(object5, iAddress);
            object3 = new Pair<Object, Object>(object4, object6);
            boolean bl2 = false;
            object2 = rawFlowGraph.getJump((IAddress)object5, (IAddress)object4);
            if (!hashSet.contains(object2)) {
                bl2 = true;
            }
            if (!bl2) continue;
            object = (RawCombinedBasicBlock)hashMap.get(pair);
            RawCombinedBasicBlock rawCombinedBasicBlock = (RawCombinedBasicBlock)hashMap.get(object3);
            RawCombinedJump<RawCombinedBasicBlock> rawCombinedJump = new RawCombinedJump<RawCombinedBasicBlock>((RawCombinedBasicBlock)object, rawCombinedBasicBlock, null, (RawJump)object72);
            arrayList2.add(rawCombinedJump);
        }
        return new RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>>(arrayList, arrayList2, rawFlowGraph, rawFlowGraph2);
    }

    private static RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> buildPrimaryUnmatchedCombinedFlowGraph(RawFlowGraph rawFlowGraph) {
        RawCombinedBasicBlock rawCombinedBasicBlock;
        IAddress iAddress = rawFlowGraph.getAddress();
        ArrayList<RawCombinedBasicBlock> arrayList = new ArrayList<RawCombinedBasicBlock>();
        ArrayList<RawCombinedJump<RawCombinedBasicBlock>> arrayList2 = new ArrayList<RawCombinedJump<RawCombinedBasicBlock>>();
        HashMap<IAddress, RawCombinedBasicBlock> hashMap = new HashMap<IAddress, RawCombinedBasicBlock>();
        for (Object object : rawFlowGraph) {
            rawCombinedBasicBlock = new RawCombinedBasicBlock((RawBasicBlock)object, null, null, iAddress, null);
            hashMap.put(((SingleViewNode)object).getAddress(), rawCombinedBasicBlock);
            arrayList.add(rawCombinedBasicBlock);
        }
        for (Object object : rawFlowGraph.getEdges()) {
            rawCombinedBasicBlock = (RawCombinedBasicBlock)hashMap.get(((RawJump)object).getSource().getAddress());
            RawCombinedBasicBlock rawCombinedBasicBlock2 = (RawCombinedBasicBlock)hashMap.get(((RawJump)object).getTarget().getAddress());
            RawCombinedJump<RawCombinedBasicBlock> rawCombinedJump = new RawCombinedJump<RawCombinedBasicBlock>(rawCombinedBasicBlock, rawCombinedBasicBlock2, (RawJump)object, null);
            arrayList2.add(rawCombinedJump);
        }
        return new RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>>(arrayList, arrayList2, rawFlowGraph, null);
    }

    private static RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> buildSecondaryUnmatchedCombinedFlowgraph(RawFlowGraph rawFlowGraph) {
        RawCombinedBasicBlock rawCombinedBasicBlock;
        IAddress iAddress = rawFlowGraph.getAddress();
        ArrayList<RawCombinedBasicBlock> arrayList = new ArrayList<RawCombinedBasicBlock>();
        ArrayList<RawCombinedJump<RawCombinedBasicBlock>> arrayList2 = new ArrayList<RawCombinedJump<RawCombinedBasicBlock>>();
        HashMap<IAddress, RawCombinedBasicBlock> hashMap = new HashMap<IAddress, RawCombinedBasicBlock>();
        for (Object object : rawFlowGraph) {
            rawCombinedBasicBlock = new RawCombinedBasicBlock(null, (RawBasicBlock)object, null, null, iAddress);
            hashMap.put(((SingleViewNode)object).getAddress(), rawCombinedBasicBlock);
            arrayList.add(rawCombinedBasicBlock);
        }
        for (Object object : rawFlowGraph.getEdges()) {
            rawCombinedBasicBlock = (RawCombinedBasicBlock)hashMap.get(((RawJump)object).getSource().getAddress());
            RawCombinedBasicBlock rawCombinedBasicBlock2 = (RawCombinedBasicBlock)hashMap.get(((RawJump)object).getTarget().getAddress());
            RawCombinedJump<RawCombinedBasicBlock> rawCombinedJump = new RawCombinedJump<RawCombinedBasicBlock>(rawCombinedBasicBlock, rawCombinedBasicBlock2, null, (RawJump)object);
            arrayList2.add(rawCombinedJump);
        }
        return new RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>>(arrayList, arrayList2, null, rawFlowGraph);
    }

    public static RawCombinedFlowGraph<RawCombinedBasicBlock, RawCombinedJump<RawCombinedBasicBlock>> buildRawCombinedFlowGraph(FunctionMatchData functionMatchData, RawFlowGraph rawFlowGraph, RawFlowGraph rawFlowGraph2) {
        logger.at(Level.INFO).log(" - Building combined flow graphs");
        if (rawFlowGraph != null && rawFlowGraph2 != null) {
            return RawCombinedFlowGraphBuilder.buildMatchedCombinedFlowGraph(functionMatchData, rawFlowGraph, rawFlowGraph2);
        }
        if (rawFlowGraph != null) {
            return RawCombinedFlowGraphBuilder.buildPrimaryUnmatchedCombinedFlowGraph(rawFlowGraph);
        }
        if (rawFlowGraph2 != null) {
            return RawCombinedFlowGraphBuilder.buildSecondaryUnmatchedCombinedFlowgraph(rawFlowGraph2);
        }
        throw new GraphCreationException("Combined flow graphs creation failed.");
    }
}

