/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project.builders;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.exceptions.GraphCreationException;
import com.google.security.zynamics.bindiff.project.matches.MatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCall;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedCall;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedFunction;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.CViewNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class RawCombinedCallGraphBuilder {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    private static List<RawCombinedCall> buildCombinedCalls(RawCallGraph rawCallGraph, RawCallGraph rawCallGraph2, Map<Pair<IAddress, IAddress>, RawCombinedFunction> map) {
        Object object;
        RawCombinedFunction rawCombinedFunction;
        Object object2;
        IAddress iAddress;
        IAddress iAddress2;
        IAddress iAddress3;
        IAddress iAddress4;
        RawFunction rawFunction;
        RawFunction rawFunction2;
        RawFunction rawFunction3;
        RawFunction rawFunction4;
        ArrayList<RawCombinedCall> arrayList = new ArrayList<RawCombinedCall>();
        for (RawCall rawCall : rawCallGraph.getEdges()) {
            rawFunction4 = (RawFunction)rawCall.getSource();
            rawFunction3 = (RawFunction)rawCall.getTarget();
            rawFunction2 = rawFunction4.getMatchedFunction();
            rawFunction = rawFunction3.getMatchedFunction();
            iAddress4 = rawFunction4.getAddress();
            iAddress3 = rawFunction3.getAddress();
            iAddress2 = rawFunction2 == null ? null : rawFunction2.getAddress();
            iAddress = rawFunction == null ? null : rawFunction.getAddress();
            object2 = rawCall.getMatchedCall();
            if (object2 != null && ((RawCall)object2).isChanged()) {
                object2 = null;
            }
            rawCombinedFunction = map.get(new Pair<IAddress, IAddress>(iAddress4, iAddress2));
            object = map.get(new Pair<IAddress, IAddress>(iAddress3, iAddress));
            RawCombinedCall rawCombinedCall = new RawCombinedCall(rawCombinedFunction, (RawCombinedFunction)object, rawCall, (RawCall)object2);
            arrayList.add(rawCombinedCall);
        }
        for (RawCall rawCall : rawCallGraph2.getEdges()) {
            if (rawCall.getMatchedCall() != null && !rawCall.getMatchedCall().isChanged()) continue;
            rawFunction4 = (RawFunction)rawCall.getSource();
            rawFunction3 = (RawFunction)rawCall.getTarget();
            rawFunction2 = rawFunction4.getMatchedFunction();
            rawFunction = rawFunction3.getMatchedFunction();
            iAddress4 = rawFunction4.getAddress();
            iAddress3 = rawFunction3.getAddress();
            iAddress2 = rawFunction2 == null ? null : rawFunction2.getAddress();
            iAddress = rawFunction == null ? null : rawFunction.getAddress();
            object2 = map.get(new Pair<IAddress, IAddress>(iAddress2, iAddress4));
            rawCombinedFunction = map.get(new Pair<IAddress, IAddress>(iAddress, iAddress3));
            object = new RawCombinedCall((RawCombinedFunction)object2, rawCombinedFunction, null, rawCall);
            arrayList.add((RawCombinedCall)object);
        }
        return arrayList;
    }

    private static List<RawCombinedFunction> buildCombinedFunctions(MatchData matchData, RawCallGraph rawCallGraph, RawCallGraph rawCallGraph2, Map<Pair<IAddress, IAddress>, RawCombinedFunction> map) {
        CViewNode cViewNode;
        IAddress iAddress;
        IAddress iAddress2;
        ArrayList<RawCombinedFunction> arrayList = new ArrayList<RawCombinedFunction>();
        for (RawFunction rawFunction : rawCallGraph.getNodes()) {
            iAddress2 = rawFunction.getAddress();
            iAddress = matchData.getSecondaryFunctionAddr(iAddress2);
            cViewNode = null;
            if (iAddress != null) {
                cViewNode = rawCallGraph2.getFunction(iAddress);
            }
            RawCombinedFunction rawCombinedFunction = new RawCombinedFunction(rawFunction, (RawFunction)cViewNode);
            map.put(new Pair<IAddress, IAddress>(iAddress2, iAddress), rawCombinedFunction);
            arrayList.add(rawCombinedFunction);
        }
        for (RawFunction rawFunction : rawCallGraph2.getNodes()) {
            iAddress2 = rawFunction.getAddress();
            iAddress = matchData.getPrimaryFunctionAddr(iAddress2);
            if (iAddress != null) continue;
            cViewNode = new RawCombinedFunction(null, rawFunction);
            map.put(new Pair<Object, IAddress>(null, iAddress2), (RawCombinedFunction)cViewNode);
            arrayList.add((RawCombinedFunction)cViewNode);
        }
        return arrayList;
    }

    public static RawCombinedCallGraph buildCombinedCallgraph(MatchData matchData, RawCallGraph rawCallGraph, RawCallGraph rawCallGraph2) {
        logger.at(Level.INFO).log(" - Building combined call graph");
        try {
            HashMap<Pair<IAddress, IAddress>, RawCombinedFunction> hashMap = new HashMap<Pair<IAddress, IAddress>, RawCombinedFunction>();
            List<RawCombinedFunction> list = RawCombinedCallGraphBuilder.buildCombinedFunctions(matchData, rawCallGraph, rawCallGraph2, hashMap);
            List<RawCombinedCall> list2 = RawCombinedCallGraphBuilder.buildCombinedCalls(rawCallGraph, rawCallGraph2, hashMap);
            hashMap.clear();
            return new RawCombinedCallGraph(list, list2);
        }
        catch (Exception exception) {
            throw new GraphCreationException("Combined call graph creation failed. " + exception.getMessage());
        }
    }
}

