/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.database.WorkspaceDatabase;
import com.google.security.zynamics.bindiff.project.IWorkspaceListener;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.project.matches.FunctionDiffMetadata;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;

public final class WorkspaceLoader
extends CEndlessHelperThread {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final int MAX_LOAD_WORKSPACE_ERRORS = 15;
    private final Workspace workspace;
    private final File workspaceFile;
    private StringBuilder errors = new StringBuilder();

    public WorkspaceLoader(File file, Workspace workspace) {
        this.workspaceFile = Preconditions.checkNotNull(file);
        this.workspace = Preconditions.checkNotNull(workspace);
    }

    @Override
    protected void runExpensiveCommand() {
        this.loadMetaData();
    }

    public String getErrorMessage() {
        return this.errors.toString();
    }

    public boolean hasErrors() {
        return "".equals(this.getErrorMessage());
    }

    public void loadMetaData() {
        this.workspace.setLoaded(false);
        if (this.workspaceFile == null) {
            throw new IOException("Load workspace failed. Workspace file cannot be null.");
        }
        if (this.workspaceFile.isDirectory()) {
            throw new IOException("Load workspace failed. Workspace file is a directory.");
        }
        logger.at(Level.INFO).log("Loading workspace '%s'...", this.workspaceFile.getPath());
        this.setDescription("Reading workspace data...");
        try (WorkspaceDatabase workspaceDatabase = new WorkspaceDatabase(this.workspaceFile);){
            MatchesDatabase matchesDatabase;
            Object object2;
            File file;
            List<String> list = workspaceDatabase.loadDiffPaths(false);
            List<String> list2 = workspaceDatabase.loadDiffPaths(true);
            int n2 = 0;
            int n3 = list.size();
            this.errors.setLength(0);
            String string = FileUtils.ensureTrailingSlash(this.workspaceFile.getParentFile().getAbsolutePath());
            for (String string2 : list) {
                DiffMetadata object3;
                ++n2;
                file = new File(string + string2);
                object2 = file.exists() ? file : new File(string2);
                logger.at(Level.INFO).log(" - Preloading Diff '%s'", ((File)object2).getPath());
                try {
                    matchesDatabase = new MatchesDatabase((File)object2);
                    try {
                        this.setDescription(String.format("Preloading Diffs %d/%d '%s'", n2, n3, ((File)object2).getName()));
                        object3 = matchesDatabase.loadDiffMetadata((File)object2);
                    }
                    finally {
                        matchesDatabase.close();
                    }
                }
                catch (SQLException sQLException) {
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log();
                    this.errors.append(" - ").append(((File)object2).getName()).append("\n");
                    continue;
                }
                this.errors.append(this.workspace.addDiff((File)object2, object3, false));
            }
            n2 = 0;
            n3 = list2.size();
            for (String string2 : list2) {
                FunctionDiffMetadata functionDiffMetadata;
                file = new File(string + string2);
                object2 = file.exists() ? file : new File(string2);
                logger.at(Level.INFO).log(" - Preloading Function Diff '%s'", ((File)object2).getPath());
                Object var11_18 = null;
                this.setDescription(String.format("Preloading Function Diffs %d/%d '%s'", ++n2, n3, ((File)object2).getName()));
                try {
                    matchesDatabase = new MatchesDatabase((File)object2);
                    try {
                        functionDiffMetadata = matchesDatabase.loadFunctionDiffMetadata(false);
                    }
                    finally {
                        matchesDatabase.close();
                    }
                }
                catch (SQLException sQLException) {
                    this.errors.append(" - ").append(((File)object2).getName()).append("\n");
                    continue;
                }
                this.errors.append(this.workspace.addDiff((File)object2, functionDiffMetadata, true));
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n5 != -1) {
                n5 = this.errors.indexOf("\n", n4);
                if (n5 == -1) continue;
                if (++n6 >= 15) {
                    this.errors.setLength(n5);
                    this.errors.append("...");
                    break;
                }
                n4 = n5 + 1;
            }
            if (this.errors.length() > 0) {
                this.errors.insert(0, "Diff loading failed for at least one item:\n\n");
            }
            this.workspace.setWorkspaceFile(this.workspaceFile);
            this.setDescription("Connecting to comment database...");
            this.workspace.setLoaded(true);
            for (IWorkspaceListener iWorkspaceListener : this.workspace.getListeners()) {
                iWorkspaceListener.loadedWorkspace(this.workspace);
            }
            logger.at(Level.INFO).log("Workspace loaded");
        }
    }
}

