/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.project;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.database.CommentsDatabase;
import com.google.security.zynamics.bindiff.database.WorkspaceDatabase;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.project.IWorkspaceListener;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.diff.DiffDirectories;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public final class Workspace {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private File workspaceFile = null;
    private final List<Diff> diffs = new ArrayList<Diff>();
    private String name;
    private boolean isLoaded = false;
    private final ListenerProvider<IWorkspaceListener> listeners = new ListenerProvider();
    private MainWindow parentWindow;

    private void createCommentDatabase() {
        try {
            CommentsDatabase commentsDatabase = new CommentsDatabase(this, true);
            commentsDatabase.close();
        }
        catch (SQLException sQLException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log(sQLException.getMessage());
            CMessageBox.showError(this.parentWindow, sQLException.getMessage());
        }
    }

    public void addDiff(Diff diff) {
        if (this.diffs.contains(diff)) {
            return;
        }
        Diff diff2 = null;
        for (Diff object : this.diffs) {
            if (!object.getMatchesDatabase().equals(diff.getMatchesDatabase())) continue;
            diff2 = object;
        }
        if (diff2 != null) {
            this.diffs.remove(diff2);
        }
        this.diffs.add(diff);
        if (this.isLoaded) {
            for (IWorkspaceListener iWorkspaceListener : this.listeners) {
                iWorkspaceListener.addedDiff(diff);
            }
            this.saveWorkspace();
        }
    }

    public String addDiff(File file, DiffMetadata diffMetadata, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder("");
        File file2 = null;
        File file3 = null;
        if (diffMetadata == null || !file.exists()) {
            stringBuilder.append(" - ").append(file.getPath()).append("\n");
        }
        if (diffMetadata != null) {
            file2 = DiffDirectories.getBinExportFile(file, diffMetadata, ESide.PRIMARY);
            if (!file2.exists() || file2.isDirectory()) {
                stringBuilder.append(" - ").append(file2.getPath()).append("\n");
            }
            if (!(file3 = DiffDirectories.getBinExportFile(file, diffMetadata, ESide.SECONDARY)).exists() || file3.isDirectory()) {
                stringBuilder.append(" - ").append(file3.getPath()).append("\n");
            }
        }
        Diff diff = new Diff(diffMetadata, file, file2, file3, bl2);
        try {
            this.addDiff(diff);
        }
        catch (SQLException sQLException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(sQLException)).log(sQLException.getMessage());
            CMessageBox.showError(this.parentWindow, sQLException.getMessage());
        }
        return stringBuilder.toString();
    }

    public void addListener(IWorkspaceListener iWorkspaceListener) {
        this.listeners.addListener(iWorkspaceListener);
    }

    public void closeWorkspace() {
        if (!this.isLoaded()) {
            return;
        }
        logger.at(Level.INFO).log("Closing workspace '%s'...", this.workspaceFile.getPath());
        this.diffs.clear();
        this.workspaceFile = null;
        this.name = "";
        this.isLoaded = false;
        for (IWorkspaceListener iWorkspaceListener : this.listeners) {
            iWorkspaceListener.closedWorkspace();
        }
        logger.at(Level.INFO).log("Workspace closed");
    }

    public boolean containsDiff(String string) {
        for (Diff diff : this.diffs) {
            if (!diff.getMatchesDatabase().getPath().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<Diff> getDiffList() {
        return this.diffs;
    }

    public List<Diff> getDiffList(boolean bl2) {
        ArrayList<Diff> arrayList = new ArrayList<Diff>();
        for (Diff diff : this.diffs) {
            if (diff.isFunctionDiff() != bl2) continue;
            arrayList.add(diff);
        }
        return arrayList;
    }

    public ListenerProvider<IWorkspaceListener> getListeners() {
        return this.listeners;
    }

    public MainWindow getWindow() {
        return this.parentWindow;
    }

    public File getWorkspaceDir() {
        return this.workspaceFile.getParentFile();
    }

    public String getWorkspaceDirPath() {
        return this.workspaceFile.getParent();
    }

    public File getWorkspaceFile() {
        return this.workspaceFile;
    }

    public String getWorkspaceFileName() {
        return this.name;
    }

    public String getWorkspaceFilePath() {
        return this.workspaceFile.getPath();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void newWorkspace(File file) {
        if (this.isLoaded) {
            throw new IOException("Couldn't create new workspace. Existing workspace has to be closed first.");
        }
        this.workspaceFile = file;
        this.name = file.getName();
        this.isLoaded = true;
        this.saveWorkspace();
        this.createCommentDatabase();
        for (IWorkspaceListener iWorkspaceListener : this.listeners) {
            iWorkspaceListener.loadedWorkspace(this);
        }
        logger.at(Level.WARNING).log("Created new Workspace");
    }

    public void removeDiff(Diff diff) {
        this.diffs.remove(diff);
    }

    public void removeListener(IWorkspaceListener iWorkspaceListener) {
        this.listeners.removeListener(iWorkspaceListener);
    }

    public void saveWorkspace() {
        if (this.workspaceFile == null) {
            throw new SQLException("Couldn't save workspace. No workspace is loaded.");
        }
        try (WorkspaceDatabase workspaceDatabase = new WorkspaceDatabase(this.workspaceFile);){
            workspaceDatabase.saveWorkspace(this);
        }
    }

    public void setLoaded(boolean bl2) {
        this.isLoaded = bl2;
    }

    public void setParentWindow(MainWindow mainWindow) {
        this.parentWindow = mainWindow;
    }

    void setWorkspaceFile(File file) {
        this.workspaceFile = file;
        this.name = file.getName();
    }
}

