/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.processes;

import com.google.common.flogger.FluentLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;

public class ProcessOutputStreamReader
implements Runnable {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final String name;
    private final InputStream inStream;
    private Thread thread;

    public ProcessOutputStreamReader(String string, InputStream inputStream) {
        this.name = string;
        this.inStream = inputStream;
    }

    public void interruptThread() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this.inStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while (!this.thread.isInterrupted()) {
                String string = bufferedReader.readLine();
                if (string == null) {
                    break;
                }
                logger.at(Level.INFO).log("[%s] %s", (Object)this.name, (Object)string);
            }
        }
        catch (Exception exception) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Could't read process output stream");
        }
        finally {
            if (this.inStream != null) {
                try {
                    this.inStream.close();
                }
                catch (IOException iOException) {
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Could't close process output stream");
                }
            }
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }
}

