/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.processes;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.exceptions.DifferException;
import com.google.security.zynamics.bindiff.processes.ProcessOutputStreamReader;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class DiffProcess {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    private DiffProcess() {
    }

    private static void handleExitCode(int n2) {
        if (n2 != 0) {
            if (n2 == 1) {
                throw new DifferException("An error occurred while diffing. Exit code 1.");
            }
            if (n2 == 2) {
                throw new DifferException("An error occurred while diffing. Exit code 2.");
            }
            if (n2 == 3) {
                throw new DifferException("Machine ran out of memory. Exit code 3.");
            }
            throw new DifferException(String.format("Unknown error occurred while diffing. Exit code %d.", n2));
        }
    }

    public static String getBinDiffFilename(String string, String string2) {
        try {
            String string3 = BinDiffFileUtils.removeFileExtension(string);
            String string4 = string2.substring(string2.lastIndexOf(File.separator) + 1);
            string4 = BinDiffFileUtils.removeFileExtension(string4);
            return string3 + "_vs_" + string4 + "." + "BinDiff";
        }
        catch (Exception exception) {
            throw new DifferException(exception, "Adding Diff to workspace.");
        }
    }

    public static void startDiffProcess(String string, String string2, String string3, File file) {
        File file2 = new File(string);
        if (!file2.exists()) {
            throw new DifferException("Can't find BinDiff engine at '" + string + "'.");
        }
        if (!file2.canExecute()) {
            throw new DifferException("BinDiff engine is not an executable '" + string + "'.");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(string, "--primary", string2, "--secondary", string3, "--output_dir", file.getPath(), "--output_format=bin");
        logger.at(Level.INFO).log(String.join((CharSequence)" ", processBuilder.command()));
        int n2 = -1;
        Process process = null;
        ProcessOutputStreamReader processOutputStreamReader = null;
        ProcessOutputStreamReader processOutputStreamReader2 = null;
        try {
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            processOutputStreamReader = new ProcessOutputStreamReader("BinDiff Process - stdout", process.getInputStream());
            processOutputStreamReader2 = new ProcessOutputStreamReader("BinDiff Process - stderr", process.getErrorStream());
            processOutputStreamReader.start();
            processOutputStreamReader2.start();
            n2 = process.waitFor();
            processOutputStreamReader.interruptThread();
            processOutputStreamReader2.interruptThread();
            DiffProcess.handleExitCode(n2);
        }
        catch (DifferException differException) {
            throw differException;
        }
        catch (IOException iOException) {
            throw new DifferException(iOException, String.format("Couldn't start diffing process. Exit code %d.", n2));
        }
        catch (InterruptedException interruptedException) {
            throw new DifferException(interruptedException, String.format("Diffing process was interrupted unexpectedly. Exit code %d.", n2));
        }
        catch (Exception exception) {
            throw new DifferException(exception, String.format("Diffing process failed. Exit code %d.", n2));
        }
        finally {
            if (processOutputStreamReader != null) {
                processOutputStreamReader.interruptThread();
            }
            if (processOutputStreamReader2 != null) {
                processOutputStreamReader2.interruptThread();
            }
        }
    }
}

