/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.logging;

import com.google.common.base.Strings;
import com.google.security.zynamics.bindiff.logging.LogFormatter;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.io.File;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

public class Logger {
    private static final java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
    private static final LogFormatter formatter = new LogFormatter();
    private static final ConsoleHandler consoleHandler = new ConsoleHandler();
    private static FileHandler fileHandler = null;

    private Logger() {
    }

    public static String levelToString(Level level) {
        if (Level.ALL.equals(level)) {
            return "debug";
        }
        if (Level.INFO.equals(level)) {
            return "info";
        }
        if (Level.WARNING.equals(level)) {
            return "warning";
        }
        if (Level.SEVERE.equals(level)) {
            return "error";
        }
        if (Level.OFF.equals(level)) {
            return "off";
        }
        return Integer.toString(level.intValue());
    }

    public static void setFileHandler(FileHandler fileHandler) {
        if (Logger.fileHandler != null) {
            rootLogger.removeHandler(fileHandler);
        }
        Logger.fileHandler = fileHandler;
        Logger.fileHandler.setFormatter(formatter);
    }

    public static void setConsoleLogging(boolean bl2) {
        rootLogger.removeHandler(consoleHandler);
        if (bl2) {
            rootLogger.addHandler(consoleHandler);
        }
    }

    public static void setFileLogging(boolean bl2) {
        rootLogger.removeHandler(fileHandler);
        if (bl2) {
            rootLogger.addHandler(fileHandler);
        }
    }

    public static String getDefaultLoggingDirectoryPath() {
        File file = new File(SystemHelpers.getApplicationDataDirectory("BinDiff") + "logs");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getPath();
    }

    public static String getLoggingFilePath(String string) {
        String string2 = Strings.isNullOrEmpty(string) ? Logger.getDefaultLoggingDirectoryPath() : string;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        string2 = BinDiffFileUtils.forceFileSeparator(string2);
        return FileUtils.ensureTrailingSlash(string2) + "bindiff_ui.log";
    }

    public static void setLogLevel(Level level) {
        rootLogger.setLevel(level);
    }

    static {
        consoleHandler.setFormatter(formatter);
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        rootLogger.addHandler(consoleHandler);
    }
}

