/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.logging;

import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.security.zynamics.bindiff.logging.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class LogFormatter
extends SimpleFormatter {
    private static final String PACKAGE;

    private static StringBuilder formatClassName(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = Strings.commonPrefix(string2, PACKAGE);
        Splitter.on('.').splitToList(string3).forEach(string -> {
            stringBuilder.append('/');
            stringBuilder.append(string.length() > 0 ? string.charAt(0) : (char)'?');
        });
        return stringBuilder.append(string2, string3.length(), string2.length()).deleteCharAt(0);
    }

    @Override
    public synchronized String format(LogRecord logRecord) {
        LocalDateTime localDateTime = LocalDateTime.now(ZoneId.systemDefault());
        char c2 = Ascii.toUpperCase(Logger.levelToString(logRecord.getLevel()).charAt(0));
        String string = (Character.isAlphabetic(c2) ? c2 : (char)'?') + Strings.padStart(Integer.toString(localDateTime.getMonthValue()), 2, '0') + Strings.padStart(Integer.toString(localDateTime.getDayOfMonth()), 2, '0') + ' ' + Strings.padStart(Integer.toString(localDateTime.getHour()), 2, '0') + ':' + Strings.padStart(Integer.toString(localDateTime.getMinute()), 2, '0') + ':' + Strings.padStart(Integer.toString(localDateTime.getSecond()), 2, '0') + '.' + Strings.padStart(Integer.toString(localDateTime.getNano() / 1000), 6, '0') + ' ' + logRecord.getThreadID() + ' ' + LogFormatter.formatClassName(logRecord.getSourceClassName()) + "::" + logRecord.getSourceMethodName() + "] ";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(logRecord.getMessage()).append('\n');
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            Splitter.on('\n').omitEmptyStrings().splitToList(stringWriter.getBuffer()).forEach(string2 -> stringBuilder.append(string).append((String)string2).append('\n'));
        }
        return stringBuilder.toString();
    }

    static {
        String string = LogFormatter.class.getPackage().getName();
        PACKAGE = string.substring(0, string.lastIndexOf(46));
    }
}

