/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.io;

import com.google.security.zynamics.bindiff.database.CommentsDatabase;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstruction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstructionComment;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.project.userview.ViewData;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import java.sql.SQLException;

public final class CommentsWriter {
    private CommentsWriter() {
    }

    private static void writeBasicblockComment(CommentsDatabase commentsDatabase, String string, IAddress iAddress, IAddress iAddress2, String string2) {
        if (string2 != null) {
            commentsDatabase.writeBasicblockComment(string, iAddress, iAddress2, string2);
        }
    }

    private static Pair<Integer, Integer> writeComments(CommentsDatabase commentsDatabase, String string, RawFlowGraph rawFlowGraph) {
        int n2 = 0;
        int n3 = 0;
        if (rawFlowGraph != null) {
            for (RawBasicBlock rawBasicBlock : rawFlowGraph) {
                IAddress iAddress = rawBasicBlock.getFunctionAddr();
                if (rawBasicBlock.isChangedComment()) {
                    IAddress iAddress2 = rawBasicBlock.getAddress();
                    Object object = rawBasicBlock.getComment();
                    try {
                        ++n3;
                        CommentsWriter.writeBasicblockComment(commentsDatabase, string, iAddress, iAddress2, (String)object);
                    }
                    catch (SQLException sQLException) {
                        ++n2;
                    }
                }
                for (Object object : rawBasicBlock) {
                    if (!((RawInstruction)object).hasComments()) continue;
                    for (RawInstructionComment rawInstructionComment : ((RawInstruction)object).getComments()) {
                        if (!rawInstructionComment.isModified()) continue;
                        IAddress iAddress3 = ((RawInstruction)object).getAddress();
                        try {
                            ++n3;
                            CommentsWriter.writeInstructionComment(commentsDatabase, string, iAddress, iAddress3, rawInstructionComment);
                        }
                        catch (SQLException sQLException) {
                            ++n2;
                        }
                    }
                }
            }
        }
        return new Pair<Integer, Integer>(n2, n3);
    }

    private static void writeInstructionComment(CommentsDatabase commentsDatabase, String string, IAddress iAddress, IAddress iAddress2, RawInstructionComment rawInstructionComment) {
        if (rawInstructionComment.isModified()) {
            String string2 = rawInstructionComment.getText();
            if (rawInstructionComment != null) {
                ECommentPlacement eCommentPlacement = rawInstructionComment.getPlacement();
                commentsDatabase.writeInstructionComment(string, iAddress, iAddress2, eCommentPlacement, string2);
            }
        }
    }

    public static void writeComments(Workspace workspace, String string, String string2, ViewData viewData) {
        try (CommentsDatabase commentsDatabase = new CommentsDatabase(workspace, false);){
            if (viewData.isFlowGraphView()) {
                RawFlowGraph rawFlowGraph = ((FlowGraphViewData)viewData).getRawGraph(ESide.PRIMARY);
                Pair<Integer, Integer> pair = CommentsWriter.writeComments(commentsDatabase, string, rawFlowGraph);
                RawFlowGraph rawFlowGraph2 = ((FlowGraphViewData)viewData).getRawGraph(ESide.SECONDARY);
                Pair<Integer, Integer> pair2 = CommentsWriter.writeComments(commentsDatabase, string2, rawFlowGraph2);
                int n2 = pair.first() + pair2.first();
                int n3 = pair.second() + pair2.second();
                if (n2 > 0) {
                    throw new SQLException(String.format("View '%s' failed to write %d of %d changed comments.", viewData.getViewName(), n2, n3));
                }
            }
        }
    }
}

