/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.io;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.BinExport;
import com.google.security.zynamics.bindiff.enums.EFunctionType;
import com.google.security.zynamics.bindiff.enums.EInstructionHighlighting;
import com.google.security.zynamics.bindiff.enums.EJumpType;
import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.io.matches.DiffRequestMessage;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCall;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCallGraph;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstruction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawInstructionComment;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawJump;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;

public class BinExport2Reader {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final ESide side;
    private final BinExport.BinExport2 binexport;
    private int maxMnemonicLen;
    private final Map<IAddress, RawInstructionComment> comments;

    public BinExport2Reader(File file, ESide eSide) {
        this.side = eSide;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            String string;
            CAddress cAddress;
            this.binexport = BinExport.BinExport2.parseFrom(bufferedInputStream);
            for (BinExport.BinExport2.Mnemonic generatedMessageV3 : this.binexport.getMnemonicList()) {
                this.maxMnemonicLen = Math.max(this.maxMnemonicLen, generatedMessageV3.getName().length());
            }
            this.comments = new TreeMap<IAddress, RawInstructionComment>();
            for (BinExport.BinExport2.Comment comment : this.binexport.getCommentList()) {
                cAddress = new CAddress(this.getInstructionAddress(comment.getInstructionIndex()));
                string = this.binexport.getStringTable(comment.getStringTableIndex());
                this.comments.put(cAddress, new RawInstructionComment(string, comment.getType() != BinExport.BinExport2.Comment.Type.ANTERIOR ? ECommentPlacement.BEHIND_LINE : ECommentPlacement.ABOVE_LINE));
            }
            if (this.comments.isEmpty()) {
                for (BinExport.BinExport2.Reference reference : this.binexport.getAddressCommentList()) {
                    cAddress = new CAddress(this.getInstructionAddress(reference.getInstructionIndex()));
                    string = this.binexport.getStringTable(reference.getStringTableIndex());
                    this.comments.put(cAddress, new RawInstructionComment(string, ECommentPlacement.BEHIND_LINE));
                }
            }
        }
    }

    private static EFunctionType vertexToFunctionType(BinExport.BinExport2.CallGraph.Vertex.Type type) {
        switch (type) {
            case NORMAL: {
                return EFunctionType.NORMAL;
            }
            case LIBRARY: {
                return EFunctionType.LIBRARY;
            }
            case IMPORTED: {
                return EFunctionType.IMPORTED;
            }
            case THUNK: {
                return EFunctionType.THUNK;
            }
            case INVALID: {
                return EFunctionType.UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Invalid vertex type");
    }

    private static String getFunctionName(BinExport.BinExport2.CallGraph.Vertex vertex) {
        String string = vertex.getDemangledName();
        if (!string.isEmpty()) {
            return string;
        }
        string = vertex.getMangledName();
        if (!string.isEmpty()) {
            return string;
        }
        return String.format("sub_%08X", vertex.getAddress());
    }

    private static EJumpType toJumpType(BinExport.BinExport2.FlowGraph.Edge.Type type) {
        switch (type) {
            case CONDITION_TRUE: {
                return EJumpType.JUMP_TRUE;
            }
            case CONDITION_FALSE: {
                return EJumpType.JUMP_FALSE;
            }
            case UNCONDITIONAL: {
                return EJumpType.UNCONDITIONAL;
            }
            case SWITCH: {
                return EJumpType.SWITCH;
            }
        }
        throw new IllegalArgumentException("Invalid flow graph edge type");
    }

    public RawCallGraph readCallGraph() {
        BinExport.BinExport2.CallGraph callGraph = this.binexport.getCallGraph();
        ArrayList<RawFunction> arrayList = new ArrayList<RawFunction>();
        for (BinExport.BinExport2.CallGraph.Vertex serializable2 : callGraph.getVertexList()) {
            String string = BinExport2Reader.getFunctionName(serializable2);
            arrayList.add(new RawFunction(new CAddress(serializable2.getAddress()), string, BinExport2Reader.vertexToFunctionType(serializable2.getType()), this.side));
        }
        ArrayList arrayList2 = new ArrayList();
        TreeSet<IAddress> treeSet = new TreeSet<IAddress>();
        for (BinExport.BinExport2.CallGraph.Edge edge : callGraph.getEdgeList()) {
            RawFunction rawFunction = (RawFunction)arrayList.get(edge.getSourceVertexIndex());
            if (!treeSet.add(rawFunction.getAddress())) continue;
            arrayList2.add(new RawCall(rawFunction, (RawFunction)arrayList.get(edge.getTargetVertexIndex()), rawFunction.getAddress(), this.side));
        }
        return new RawCallGraph(arrayList, arrayList2, this.side);
    }

    private long getInstructionAddress(int n2) {
        BinExport.BinExport2.Instruction instruction = this.binexport.getInstruction(n2);
        if (instruction.hasAddress()) {
            return instruction.getAddress();
        }
        int n3 = 0;
        --n2;
        while (n2 >= 0) {
            instruction = this.binexport.getInstruction(n2);
            n3 += instruction.getRawBytes().size();
            if (instruction.hasAddress()) {
                return this.binexport.getInstruction(n2).getAddress() + (long)n3;
            }
            --n2;
        }
        throw new IllegalStateException("Invalid instruction index");
    }

    private static char highlightChar(EInstructionHighlighting eInstructionHighlighting) {
        return (char)EInstructionHighlighting.getOrdinal(eInstructionHighlighting);
    }

    private static void renderExpression(BinExport.BinExport2 binExport2, BinExport.BinExport2.Operand operand, int n2, StringBuffer stringBuffer) {
        int n3 = operand.getExpressionIndex(n2);
        BinExport.BinExport2.Expression expression = binExport2.getExpression(n3);
        String string = expression.getSymbol();
        boolean bl2 = binExport2.getMetaInformation().getArchitectureName().endsWith("64");
        switch (expression.getType()) {
            case OPERATOR: {
                int n4;
                ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
                for (n4 = n2 + 1; n4 < operand.getExpressionIndexCount() && binExport2.getExpression(operand.getExpressionIndex(n4)).getParentIndex() == operand.getExpressionIndex(n2); ++n4) {
                    arrayList.add(n4);
                }
                n4 = arrayList.size();
                if ("{".equals(string)) {
                    stringBuffer.append("{");
                    for (int i2 = 0; i2 < n4; ++i2) {
                        BinExport2Reader.renderExpression(binExport2, operand, (Integer)arrayList.get(i2), stringBuffer);
                        if (i2 == n4 - 1) continue;
                        stringBuffer.append(BinExport2Reader.highlightChar(EInstructionHighlighting.TYPE_NEWOPERAND_COMMA));
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("}");
                    break;
                }
                if (n4 == 1) {
                    stringBuffer.append(BinExport2Reader.highlightChar(EInstructionHighlighting.TYPE_OPERATOR));
                    stringBuffer.append(string);
                    BinExport2Reader.renderExpression(binExport2, operand, (Integer)arrayList.get(0), stringBuffer);
                    break;
                }
                if (n4 <= 1) break;
                for (int i3 = 0; i3 < n4; ++i3) {
                    BinExport2Reader.renderExpression(binExport2, operand, (Integer)arrayList.get(i3), stringBuffer);
                    if (i3 == n4 - 1) continue;
                    BinExport.BinExport2.Expression expression2 = binExport2.getExpression(operand.getExpressionIndex((Integer)arrayList.get(i3 + 1)));
                    BinExport.BinExport2.Expression.Type type = expression2.getType();
                    if ("+".equals(string) && (type == BinExport.BinExport2.Expression.Type.IMMEDIATE_INT || type == BinExport.BinExport2.Expression.Type.IMMEDIATE_FLOAT)) {
                        long l2;
                        long l3 = l2 = bl2 ? expression2.getImmediate() : (long)((int)expression2.getImmediate());
                        if (l2 < 0L && expression2.getSymbol().isEmpty()) continue;
                        if (l2 == 0L) {
                            ++i3;
                            continue;
                        }
                    }
                    stringBuffer.append(string);
                }
                break;
            }
            case SYMBOL: {
                stringBuffer.append(BinExport2Reader.highlightChar(EInstructionHighlighting.TYPE_SYMBOL));
                stringBuffer.append(string);
                break;
            }
            case REGISTER: {
                stringBuffer.append(BinExport2Reader.highlightChar(EInstructionHighlighting.TYPE_REGISTER));
                stringBuffer.append(string);
                break;
            }
            case SIZE_PREFIX: {
                if (bl2 && !"b8".equals(string) || !bl2 && !"b4".equals(string)) {
                    stringBuffer.append(BinExport2Reader.highlightChar(EInstructionHighlighting.TYPE_SIZEPREFIX));
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                }
                BinExport2Reader.renderExpression(binExport2, operand, n2 + 1, stringBuffer);
                break;
            }
            case DEREFERENCE: {
                stringBuffer.append(BinExport2Reader.highlightChar(EInstructionHighlighting.TYPE_DEREFERENCE));
                stringBuffer.append("[");
                if (n2 + 1 < operand.getExpressionIndexCount()) {
                    BinExport2Reader.renderExpression(binExport2, operand, n2 + 1, stringBuffer);
                }
                stringBuffer.append(BinExport2Reader.highlightChar(EInstructionHighlighting.TYPE_DEREFERENCE));
                stringBuffer.append("]");
                break;
            }
            case IMMEDIATE_INT: 
            case IMMEDIATE_FLOAT: {
                if (string.isEmpty()) {
                    long l4 = bl2 ? expression.getImmediate() : (long)((int)expression.getImmediate());
                    stringBuffer.append(BinExport2Reader.highlightChar(EInstructionHighlighting.TYPE_IMMEDIATE));
                    if (l4 <= 9L) {
                        stringBuffer.append(String.format("%d", l4));
                        break;
                    }
                    stringBuffer.append(String.format("0x%X", l4));
                    break;
                }
                stringBuffer.append(BinExport2Reader.highlightChar(EInstructionHighlighting.TYPE_SYMBOL));
                stringBuffer.append(string);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid expression type");
            }
        }
    }

    private static String renderInstructionOperands(BinExport.BinExport2 binExport2, BinExport.BinExport2.Instruction instruction) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < instruction.getOperandIndexCount(); ++i2) {
            BinExport.BinExport2.Operand operand = binExport2.getOperand(instruction.getOperandIndex(i2));
            for (int i3 = 0; i3 < operand.getExpressionIndexCount(); ++i3) {
                BinExport.BinExport2.Expression expression = binExport2.getExpression(operand.getExpressionIndex(i3));
                if (expression.hasParentIndex()) continue;
                BinExport2Reader.renderExpression(binExport2, operand, i3, stringBuffer);
            }
            if (i2 == instruction.getOperandIndexCount() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public RawFlowGraph readFlowGraph(Diff diff, IAddress iAddress) {
        Object object;
        RawFunction rawFunction = diff.getCallGraph(this.side).getFunction(iAddress);
        BinExport.BinExport2.FlowGraph flowGraph = null;
        for (BinExport.BinExport2.FlowGraph serializable2 : this.binexport.getFlowGraphList()) {
            object = this.binexport.getBasicBlock(serializable2.getEntryBasicBlockIndex());
            BinExport.BinExport2.Instruction instruction = this.binexport.getInstruction(((BinExport.BinExport2.BasicBlock)object).getInstructionIndex(0).getBeginIndex());
            if (iAddress.toLong() != instruction.getAddress()) continue;
            flowGraph = serializable2;
            break;
        }
        TreeMap treeMap = new TreeMap();
        ArrayList<RawJump> arrayList = new ArrayList<RawJump>();
        if (flowGraph != null) {
            Object object2;
            Object object3;
            for (Integer n2 : flowGraph.getBasicBlockIndexList()) {
                BinExport.BinExport2.BasicBlock basicBlock = this.binexport.getBasicBlock(n2);
                object3 = new CAddress(this.getInstructionAddress(basicBlock.getInstructionIndex(0).getBeginIndex()));
                object2 = rawFunction.getFunctionMatch();
                EMatchState eMatchState = object2 != null && ((FunctionMatchData)object2).getBasicBlockMatch((IAddress)object3, this.side) != null ? EMatchState.MATCHED : (this.side == ESide.PRIMARY ? EMatchState.PRIMARY_UNMATCHED : EMatchState.SECONDRAY_UNMATCHED);
                TreeMap<IAddress, RawInstruction> treeMap2 = new TreeMap<IAddress, RawInstruction>();
                for (BinExport.BinExport2.BasicBlock.IndexRange indexRange : basicBlock.getInstructionIndexList()) {
                    int n3 = !indexRange.hasEndIndex() ? indexRange.getBeginIndex() + 1 : indexRange.getEndIndex();
                    for (int i2 = indexRange.getBeginIndex(); i2 < n3; ++i2) {
                        BinExport.BinExport2.Instruction instruction = this.binexport.getInstruction(i2);
                        CAddress cAddress = new CAddress(this.getInstructionAddress(i2));
                        long[] lArray = new long[instruction.getCallTargetCount()];
                        for (int i3 = 0; i3 < lArray.length; ++i3) {
                            lArray[i3] = instruction.getCallTarget(i3);
                        }
                        ArrayList<RawInstructionComment> arrayList2 = new ArrayList<RawInstructionComment>();
                        RawInstructionComment rawInstructionComment = this.comments.get(cAddress);
                        if (rawInstructionComment != null) {
                            arrayList2.add(rawInstructionComment);
                        }
                        RawInstruction rawInstruction = new RawInstruction(cAddress, this.binexport.getMnemonic(instruction.getMnemonicIndex()).getName(), this.maxMnemonicLen, BinExport2Reader.renderInstructionOperands(this.binexport, instruction).getBytes(StandardCharsets.UTF_8), lArray, arrayList2);
                        treeMap2.put(cAddress, rawInstruction);
                    }
                }
                RawBasicBlock rawBasicBlock = new RawBasicBlock(iAddress, rawFunction.getName(), (IAddress)object3, treeMap2, this.side, eMatchState);
                treeMap.put(n2, rawBasicBlock);
            }
            for (BinExport.BinExport2.FlowGraph.Edge edge : flowGraph.getEdgeList()) {
                int n4 = edge.getSourceBasicBlockIndex();
                object3 = (RawBasicBlock)treeMap.get(n4);
                int n5 = edge.getTargetBasicBlockIndex();
                object2 = (RawBasicBlock)treeMap.get(n5);
                if (object3 == null || object2 == null) {
                    logger.at(Level.WARNING).log("Incomplete %s flow graph edge (source %d%s, target %d%s)", this.side == ESide.PRIMARY ? "primary" : "secondary", n4, object3 == null ? " missing" : "", n5, object2 == null ? " missing" : "");
                    continue;
                }
                arrayList.add(new RawJump((RawBasicBlock)object3, (RawBasicBlock)object2, BinExport2Reader.toJumpType(edge.getType())));
            }
        }
        object = new ArrayList(treeMap.values());
        return new RawFlowGraph(iAddress, rawFunction.getName(), rawFunction.getFunctionType(), (List<RawBasicBlock>)object, arrayList, this.side);
    }

    public void readFlowGraphsStatistics(Diff diff) {
        for (BinExport.BinExport2.FlowGraph flowGraph : this.binexport.getFlowGraphList()) {
            BinExport.BinExport2.BasicBlock basicBlock = this.binexport.getBasicBlock(flowGraph.getEntryBasicBlockIndex());
            BinExport.BinExport2.Instruction instruction = this.binexport.getInstruction(basicBlock.getInstructionIndex(0).getBeginIndex());
            long l2 = instruction.getAddress();
            RawFunction rawFunction = diff.getCallGraph(this.side).getFunction(new CAddress(l2));
            rawFunction.setSizeOfBasicBlocks(flowGraph.getBasicBlockIndexCount());
            int n2 = 0;
            for (int n3 : flowGraph.getBasicBlockIndexList()) {
                n2 += this.binexport.getBasicBlock(n3).getInstructionIndexCount();
            }
            rawFunction.setSizeOfInstructions(n2);
            rawFunction.setSizeOfJumps(flowGraph.getEdgeCount());
        }
    }

    public RawCallGraph readSingleFunctionDiffCallGraph(DiffRequestMessage diffRequestMessage) {
        long l2 = diffRequestMessage.getFunctionAddress(this.side);
        ArrayList<RawFunction> arrayList = new ArrayList<RawFunction>();
        ArrayList<RawCall> arrayList2 = new ArrayList<RawCall>();
        BinExport.BinExport2.CallGraph callGraph = this.binexport.getCallGraph();
        for (BinExport.BinExport2.CallGraph.Vertex vertex : callGraph.getVertexList()) {
            if (l2 != vertex.getAddress()) continue;
            String string = BinExport2Reader.getFunctionName(vertex);
            arrayList.add(new RawFunction(new CAddress(vertex.getAddress()), string, BinExport2Reader.vertexToFunctionType(vertex.getType()), this.side));
            return new RawCallGraph(arrayList, arrayList2, this.side);
        }
        throw new RuntimeException("Function flow graph not found.");
    }

    public String getArchitectureName() {
        return this.binexport.getMetaInformation().getArchitectureName();
    }

    public int getMaxMnemonicLen() {
        return this.maxMnemonicLen;
    }
}

