/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.window;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.menubar.WorkspaceMenuBar;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JTabbedPane;

public class WindowFunctions {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final TabPanelManager tabPanelManager;
    private final MainWindow window;

    public WindowFunctions(MainWindow mainWindow, Workspace workspace) {
        Preconditions.checkNotNull(mainWindow);
        Preconditions.checkNotNull(workspace);
        this.tabPanelManager = new TabPanelManager(mainWindow, workspace);
        WorkspaceTabPanel workspaceTabPanel = new WorkspaceTabPanel(mainWindow, workspace);
        this.tabPanelManager.addTab(workspaceTabPanel);
        this.window = mainWindow;
    }

    private void saveConfigFile() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        GeneralSettingsConfigItem generalSettingsConfigItem = binDiffConfig.getMainSettings();
        Point point = this.window.getLocation();
        generalSettingsConfigItem.setWindowXPos((int)point.getX());
        generalSettingsConfigItem.setWindowYPos((int)point.getY());
        generalSettingsConfigItem.setWindowWidth(this.window.getWidth());
        generalSettingsConfigItem.setWindowHeight(this.window.getHeight());
        generalSettingsConfigItem.setWindowStateWasMaximized(this.window.getExtendedState() == 6);
        generalSettingsConfigItem.setWorkspaceTreeDividerPosition(this.tabPanelManager.getWorkspaceTabPanel().getDividerLocation());
        generalSettingsConfigItem.setScreenWidth(Toolkit.getDefaultToolkit().getScreenSize().width);
        generalSettingsConfigItem.setScreenHeight(Toolkit.getDefaultToolkit().getScreenSize().height);
        WorkspaceMenuBar workspaceMenuBar = (WorkspaceMenuBar)this.tabPanelManager.getWorkspaceTabPanel().getMenuBar();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : workspaceMenuBar.getRecentWorkspaces()) {
            if (!new File(string).isFile()) continue;
            arrayList.add(string);
        }
        generalSettingsConfigItem.setRecentWorkspaceDirectories(arrayList);
        try {
            BinDiffConfig.getInstance().write();
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Couldn't save configuration file");
            CMessageBox.showError(this.window, "Couldn't save configuration file.");
        }
    }

    public void exitBinDiff() {
        WorkspaceTabPanelFunctions workspaceTabPanelFunctions = this.tabPanelManager.getWorkspaceTabPanel().getController();
        if (workspaceTabPanelFunctions.closeWorkspace()) {
            workspaceTabPanelFunctions.closeDialogs();
            this.saveConfigFile();
            logger.at(Level.INFO).log("BinDiff closed normally");
        }
        System.exit(0);
    }

    public JTabbedPane getTabbedPanel() {
        return this.tabPanelManager.getTabbedPane();
    }

    public TabPanelManager getTabPanelManager() {
        return this.tabPanelManager;
    }
}

