/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.window;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.detachedviewstabpanel.FunctionDiffViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanel;
import com.google.security.zynamics.bindiff.gui.window.WindowFunctions;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.WorkspaceAdapter;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class MainWindow
extends JFrame {
    private final WindowFunctions controller;
    private final InternalWindowListener windowListener = new InternalWindowListener();
    private String titlePath;

    public MainWindow(Workspace workspace) {
        Preconditions.checkNotNull(workspace);
        workspace.addListener(new InternalWorkspaceListener());
        this.controller = new WindowFunctions(this, workspace);
        this.initWindow();
        this.addWindowListener(this.windowListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MainWindow.this.updateEllipsis();
            }
        });
    }

    private boolean hasChangedScreenResolution() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        GeneralSettingsConfigItem generalSettingsConfigItem = binDiffConfig.getMainSettings();
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n3 = Toolkit.getDefaultToolkit().getScreenSize().height;
        generalSettingsConfigItem.setScreenWidth(n2);
        generalSettingsConfigItem.setScreenHeight(n3);
        return generalSettingsConfigItem.getScreenWidth() != n2 || generalSettingsConfigItem.getScreenHeight() != n3;
    }

    private void initWindow() {
        this.setDefaultCloseOperation(0);
        GuiUtils.setWindowIcons(this, "data/appicons/bindiff-16x16-rgba.png", "data/appicons/bindiff-32x32-rgba.png", "data/appicons/bindiff-48x48-rgba.png");
        boolean bl2 = BinDiffConfig.getInstance().getMainSettings().getWindowStateWasMaximized();
        if (!bl2 && !this.hasChangedScreenResolution()) {
            GeneralSettingsConfigItem generalSettingsConfigItem = BinDiffConfig.getInstance().getMainSettings();
            int n2 = generalSettingsConfigItem.getWindowXPos();
            int n3 = generalSettingsConfigItem.getWindowYPos();
            int n4 = generalSettingsConfigItem.getWindowWidth();
            int n5 = generalSettingsConfigItem.getWindowHeight();
            this.setLocation(n2, n3);
            this.setSize(n4, n5);
            this.setPreferredSize(new Dimension(n4, n5));
        } else {
            this.setLocation(100, 100);
            this.setSize(800, 600);
            this.setPreferredSize(new Dimension(800, 600));
            this.setExtendedState(6);
        }
        this.add((Component)this.controller.getTabbedPanel(), "Center");
        this.pack();
    }

    private void updateEllipsis() {
        if (this.titlePath == null || this.getGraphics() == null) {
            return;
        }
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
        Insets insets = this.getInsets();
        int n2 = insets.right - insets.left + 100 + fontMetrics.stringWidth(" - BinDiff");
        String string = this.titlePath;
        for (int i2 = this.titlePath.length(); i2 >= 12 && fontMetrics.stringWidth(string) > this.getWidth() - n2; --i2) {
            string = FileUtils.getPathEllipsis(this.titlePath, i2);
        }
        this.setTitle(string);
    }

    public WindowFunctions getController() {
        return this.controller;
    }

    @Override
    public void setTitle(String string) {
        super.setTitle((!string.isEmpty() ? string + " - " : "") + "BinDiff");
    }

    public void updateTitle(Workspace workspace, TabPanel tabPanel) {
        this.titlePath = null;
        if (tabPanel instanceof WorkspaceTabPanel) {
            if (workspace == null || !workspace.isLoaded()) {
                this.setTitle("");
            } else {
                this.setTitle(workspace.getWorkspaceFilePath());
                this.titlePath = workspace.getWorkspaceFilePath();
                this.updateEllipsis();
            }
        } else if (tabPanel instanceof FunctionDiffViewTabPanel) {
            String string = tabPanel.getTitle();
            this.setTitle(string);
        } else if (tabPanel instanceof ViewTabPanel) {
            String string = String.format("%s - %s", tabPanel.getTitle(), ((ViewTabPanel)tabPanel).getView().getGraphs().getDiff().getDiffName());
            this.setTitle(string);
        }
    }

    private class InternalWorkspaceListener
    extends WorkspaceAdapter {
        private InternalWorkspaceListener() {
        }

        @Override
        public void closedWorkspace() {
            MainWindow.this.setTitle("");
        }

        @Override
        public void loadedWorkspace(Workspace workspace) {
            MainWindow.this.setTitle(workspace.getWorkspaceFilePath());
            MainWindow.this.titlePath = workspace.getWorkspaceFilePath();
            MainWindow.this.updateEllipsis();
        }
    }

    private class InternalWindowListener
    extends WindowAdapter {
        private InternalWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            MainWindow.this.removeWindowListener(MainWindow.this.windowListener);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            WorkspaceTabPanelFunctions workspaceTabPanelFunctions = MainWindow.this.controller.getTabPanelManager().getWorkspaceTabPanel().getController();
            workspaceTabPanelFunctions.getWorkspaceTree().grabFocus();
            SwingUtilities.invokeLater(MainWindow.this.controller::exitBinDiff);
        }
    }
}

