/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.subpanels;

import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.enums.ESortByCriterion;
import com.google.security.zynamics.bindiff.enums.ESortOrder;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeMultiFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.EMatchStateFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.ESelectionFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.ESideFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.EVisibilityFilter;
import com.google.security.zynamics.bindiff.gui.components.treesearchfield.ITreeSearchFieldListener;
import com.google.security.zynamics.bindiff.gui.components.treesearchfield.TreeSearchFieldCombo;
import com.google.security.zynamics.bindiff.gui.dialogs.graphnodetreeoptionsdialog.GraphNodeTreeOptionsDialog;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.AbstractGraphNodeTree;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.CombinedCallGraphTree;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.CombinedFlowGraphTree;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.SingleCallGraphTree;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.SingleFlowGraphTree;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.TreeNodeSearcher;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.TreeNodeMultiSorter;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.AbstractRootTreeNode;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawFlowGraph;
import com.google.security.zynamics.bindiff.project.userview.ViewData;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeNode;

public class GraphNodeTreePanel
extends JPanel {
    private static final ImageIcon ICON_OPTIONS = ImageUtils.getImageIcon("data/buttonicons/options.png");
    private static final ImageIcon ICON_CLEAR = ImageUtils.getImageIcon("data/buttonicons/clear.png");
    private static final ImageIcon ICON_CLEAR_GRAY = ImageUtils.getImageIcon("data/buttonicons/clear-gray.png");
    private final TreeSearchFieldCombo filterCombo = new TreeSearchFieldCombo();
    private final JButton clearButton = new JButton(ICON_CLEAR_GRAY);
    private final JButton optionsButton = new JButton(ICON_OPTIONS);
    private final InternalClearButtonListener clearButtonListener = new InternalClearButtonListener();
    private final InternalOptionsButtonListener optionsButtonAction = new InternalOptionsButtonListener();
    private final InternalSearchFieldListener searchComboListener = new InternalSearchFieldListener();
    private final GraphNodeTreeOptionsDialog optionsDialog;
    private AbstractGraphNodeTree tree;

    public GraphNodeTreePanel(ViewTabPanelFunctions viewTabPanelFunctions, Diff diff, ViewData viewData, CombinedGraph combinedGraph) {
        super(new BorderLayout());
        this.optionsDialog = this.createOptionsDialog((Window)viewTabPanelFunctions.getMainWindow(), combinedGraph);
        this.tree = this.createCombinedTree(viewTabPanelFunctions, diff, viewData, combinedGraph);
        this.init();
    }

    public GraphNodeTreePanel(ViewTabPanelFunctions viewTabPanelFunctions, Diff diff, ViewData viewData, SingleGraph singleGraph) {
        super(new BorderLayout());
        this.optionsDialog = this.createOptionsDialog((Window)viewTabPanelFunctions.getMainWindow(), singleGraph);
        this.tree = this.createSingleTree(viewTabPanelFunctions, diff, viewData, singleGraph);
        this.init();
    }

    private void addListeners() {
        this.filterCombo.addListener(this.searchComboListener);
        this.optionsButton.addActionListener(this.optionsButtonAction);
        this.clearButton.addActionListener(this.clearButtonListener);
    }

    private AbstractGraphNodeTree createCombinedTree(ViewTabPanelFunctions viewTabPanelFunctions, Diff diff, ViewData viewData, CombinedGraph combinedGraph) {
        TreeNodeSearcher treeNodeSearcher = this.createDefaultTreeSearcher();
        GraphNodeMultiFilter graphNodeMultiFilter = this.createDefaultMultiFilter(diff, viewData);
        TreeNodeMultiSorter treeNodeMultiSorter = this.createDefaultMultiSorter();
        if (combinedGraph.getGraphType() == EGraphType.CALLGRAPH) {
            return new CombinedCallGraphTree(viewTabPanelFunctions, diff, viewData, combinedGraph, treeNodeSearcher, graphNodeMultiFilter, treeNodeMultiSorter);
        }
        if (combinedGraph.getGraphType() == EGraphType.FLOWGRAPH) {
            return new CombinedFlowGraphTree(viewTabPanelFunctions, diff, viewData, combinedGraph, treeNodeSearcher, graphNodeMultiFilter, treeNodeMultiSorter);
        }
        throw new IllegalStateException("Combined graph node tree cannot be null.");
    }

    private GraphNodeMultiFilter createDefaultMultiFilter(Diff diff, ViewData viewData) {
        RawFlowGraph rawFlowGraph = null;
        RawFlowGraph rawFlowGraph2 = null;
        if (viewData.isFlowGraphView()) {
            rawFlowGraph = (RawFlowGraph)viewData.getRawGraph(ESide.PRIMARY);
            rawFlowGraph2 = (RawFlowGraph)viewData.getRawGraph(ESide.SECONDARY);
        }
        return new GraphNodeMultiFilter(diff, rawFlowGraph, rawFlowGraph2, new CAddress(0L), new CAddress(-1L), EMatchStateFilter.NONE, ESelectionFilter.NONE, EVisibilityFilter.NONE, ESideFilter.NONE);
    }

    private TreeNodeMultiSorter createDefaultMultiSorter() {
        TreeNodeMultiSorter treeNodeMultiSorter = new TreeNodeMultiSorter();
        for (int i2 = 0; i2 < 5; ++i2) {
            ESortByCriterion eSortByCriterion = this.optionsDialog.getSortByCriterion(i2);
            ESortOrder eSortOrder = this.optionsDialog.getSortOrder(i2);
            treeNodeMultiSorter.setCriterion(eSortByCriterion, eSortOrder, i2, false);
        }
        return treeNodeMultiSorter;
    }

    private TreeNodeSearcher createDefaultTreeSearcher() {
        return new TreeNodeSearcher(false, false, true, true, false, false);
    }

    private GraphNodeTreeOptionsDialog createOptionsDialog(Window window, CombinedGraph combinedGraph) {
        boolean bl2 = combinedGraph.getGraphType() == EGraphType.CALLGRAPH;
        GraphNodeTreeOptionsDialog graphNodeTreeOptionsDialog = new GraphNodeTreeOptionsDialog(window, "Combined Tree Options", bl2, true);
        GuiHelper.centerChildToParent(window, graphNodeTreeOptionsDialog, true);
        return graphNodeTreeOptionsDialog;
    }

    private GraphNodeTreeOptionsDialog createOptionsDialog(Window window, SingleGraph singleGraph) {
        boolean bl2 = singleGraph.getGraphType() == EGraphType.CALLGRAPH;
        String string = "Primary Tree Options";
        String string2 = "Secondary Tree Options";
        ESide eSide = singleGraph.getSide();
        GraphNodeTreeOptionsDialog graphNodeTreeOptionsDialog = new GraphNodeTreeOptionsDialog(window, eSide == ESide.PRIMARY ? "Primary Tree Options" : "Secondary Tree Options", bl2, false);
        GuiHelper.centerChildToParent(window, graphNodeTreeOptionsDialog, true);
        return graphNodeTreeOptionsDialog;
    }

    private AbstractGraphNodeTree createSingleTree(ViewTabPanelFunctions viewTabPanelFunctions, Diff diff, ViewData viewData, SingleGraph singleGraph) {
        TreeNodeSearcher treeNodeSearcher = this.createDefaultTreeSearcher();
        GraphNodeMultiFilter graphNodeMultiFilter = this.createDefaultMultiFilter(diff, viewData);
        TreeNodeMultiSorter treeNodeMultiSorter = this.createDefaultMultiSorter();
        if (singleGraph.getGraphType() == EGraphType.CALLGRAPH) {
            return new SingleCallGraphTree(viewTabPanelFunctions, diff, viewData, singleGraph, treeNodeSearcher, graphNodeMultiFilter, treeNodeMultiSorter);
        }
        if (singleGraph.getGraphType() == EGraphType.FLOWGRAPH) {
            return new SingleFlowGraphTree(viewTabPanelFunctions, diff, viewData, singleGraph, treeNodeSearcher, graphNodeMultiFilter, treeNodeMultiSorter);
        }
        throw new IllegalStateException("Single graph node tree cannot be null.");
    }

    private void init() {
        this.clearButton.setToolTipText("Clear Search Results");
        this.optionsButton.setToolTipText("Search Settings");
        this.addListeners();
        this.setBorder(new LineBorder(Color.GRAY));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(new EmptyBorder(1, 1, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(new EmptyBorder(0, 0, 1, 1));
        jPanel2.add((Component)this.filterCombo, "Center");
        this.clearButton.setBackground(Color.WHITE);
        this.clearButton.setFocusable(false);
        this.clearButton.setPreferredSize(new Dimension(32, this.filterCombo.getPreferredSize().height));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(0, 1, 0, 0));
        jPanel3.add((Component)this.clearButton, "Center");
        jPanel2.add((Component)jPanel3, "East");
        this.optionsButton.setBackground(Color.WHITE);
        this.optionsButton.setFocusable(false);
        this.optionsButton.setPreferredSize(new Dimension(32, this.filterCombo.getPreferredSize().height));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new EmptyBorder(0, 1, 0, 0));
        jPanel4.add((Component)this.optionsButton, "East");
        jPanel3.add((Component)jPanel4, "East");
        this.filterCombo.setBackground(Color.WHITE);
        this.filterCombo.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tree.setBorder(new EmptyBorder(1, 1, 1, 1));
        jPanel.add((Component)jPanel2, "North");
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Center");
    }

    public void dispose() {
        if (this.tree instanceof SingleCallGraphTree) {
            ((SingleCallGraphTree)this.tree).dispose();
        } else if (this.tree instanceof SingleFlowGraphTree) {
            ((SingleFlowGraphTree)this.tree).dispose();
        } else if (this.tree instanceof CombinedCallGraphTree) {
            ((CombinedCallGraphTree)this.tree).dispose();
        } else if (this.tree instanceof CombinedFlowGraphTree) {
            ((CombinedFlowGraphTree)this.tree).dispose();
        }
        this.optionsDialog.dispose();
        this.filterCombo.removeListener(this.searchComboListener);
        this.optionsButton.removeActionListener(this.optionsButtonAction);
        this.clearButton.removeActionListener(this.clearButtonListener);
        this.tree = null;
    }

    public AbstractGraphNodeTree getTree() {
        return this.tree;
    }

    public void updateClearTreeSearchIcons() {
        this.clearButton.setIcon(ICON_CLEAR);
        TreeNode treeNode = this.getTree().getRootNode().getFirstChild();
        if (treeNode != null && treeNode.getChildCount() == this.getTree().getGraph().getNodes().size()) {
            this.clearButton.setIcon(ICON_CLEAR_GRAY);
        }
    }

    private class InternalSearchFieldListener
    implements ITreeSearchFieldListener {
        private InternalSearchFieldListener() {
        }

        @Override
        public void searchChanged(String string) {
            TreeNodeSearcher treeNodeSearcher = ((AbstractRootTreeNode)GraphNodeTreePanel.this.tree.getModel().getRoot()).getSearcher();
            treeNodeSearcher.setSearchString(string);
            GraphNodeTreePanel.this.updateClearTreeSearchIcons();
        }
    }

    private class InternalOptionsButtonListener
    implements ActionListener {
        private InternalOptionsButtonListener() {
        }

        private void setFilter(boolean bl2) {
            GraphNodeMultiFilter graphNodeMultiFilter = ((AbstractRootTreeNode)GraphNodeTreePanel.this.tree.getModel().getRoot()).getFilter();
            graphNodeMultiFilter.setFilter(GraphNodeTreePanel.this.optionsDialog.getStartAddress(), GraphNodeTreePanel.this.optionsDialog.getEndAddress(), GraphNodeTreePanel.this.optionsDialog.getMatchStateFilter(), GraphNodeTreePanel.this.optionsDialog.getSelectionFilter(), GraphNodeTreePanel.this.optionsDialog.getVisibilityFilter(), GraphNodeTreePanel.this.optionsDialog.getSideFilter(), false);
            if (bl2) {
                graphNodeMultiFilter.notifyListeners();
            }
        }

        private void setSearcher(boolean bl2) {
            TreeNodeSearcher treeNodeSearcher = ((AbstractRootTreeNode)GraphNodeTreePanel.this.tree.getModel().getRoot()).getSearcher();
            boolean bl3 = GraphNodeTreePanel.this.optionsDialog.getRegEx();
            boolean bl4 = GraphNodeTreePanel.this.optionsDialog.getCaseSensitive();
            boolean bl5 = GraphNodeTreePanel.this.optionsDialog.getPrimarySide();
            boolean bl6 = GraphNodeTreePanel.this.optionsDialog.getSecondarySide();
            boolean bl7 = GraphNodeTreePanel.this.optionsDialog.getHighlightGraphNodes();
            boolean bl8 = GraphNodeTreePanel.this.optionsDialog.getUseTemporaryResult();
            treeNodeSearcher.setSearchSettings(bl3, bl4, bl5, bl6, bl8, bl7);
            if (bl2) {
                treeNodeSearcher.notifyListeners();
            }
        }

        private void setSorter(boolean bl2) {
            TreeNodeMultiSorter treeNodeMultiSorter = ((AbstractRootTreeNode)GraphNodeTreePanel.this.tree.getModel().getRoot()).getSorter();
            for (int i2 = 0; i2 < 5; ++i2) {
                ESortByCriterion eSortByCriterion = GraphNodeTreePanel.this.optionsDialog.getSortByCriterion(i2);
                ESortOrder eSortOrder = GraphNodeTreePanel.this.optionsDialog.getSortOrder(i2);
                treeNodeMultiSorter.setCriterion(eSortByCriterion, eSortOrder, i2, false);
            }
            if (bl2) {
                treeNodeMultiSorter.notifyListeners();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(GraphNodeTreePanel.this.optionsButton)) {
                GraphNodeTreePanel.this.optionsDialog.setVisible(true);
                if (GraphNodeTreePanel.this.optionsDialog.getOkPressed()) {
                    this.setSearcher(false);
                    this.setFilter(false);
                    this.setSorter(true);
                    GraphNodeTreePanel.this.updateClearTreeSearchIcons();
                }
            }
        }
    }

    private class InternalClearButtonListener
    implements ActionListener {
        private InternalClearButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphNodeMultiFilter graphNodeMultiFilter = ((AbstractRootTreeNode)GraphNodeTreePanel.this.tree.getModel().getRoot()).getFilter();
            graphNodeMultiFilter.clearSettings(false);
            GraphNodeTreePanel.this.optionsDialog.setDefaults(1);
            TreeNodeSearcher treeNodeSearcher = ((AbstractRootTreeNode)GraphNodeTreePanel.this.tree.getModel().getRoot()).getSearcher();
            treeNodeSearcher.setSearchString("");
            GraphNodeTreePanel.this.filterCombo.clear();
            GraphNodeTreePanel.this.clearButton.setIcon(ICON_CLEAR_GRAY);
        }
    }
}

