/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory;

import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.ISnapshotListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SelectionSnapshot {
    private final ListenerProvider<ISnapshotListener> listeners = new ListenerProvider();
    private final List<ZyGraphNode<?>> selectedNodes = new ArrayList();

    public SelectionSnapshot(Collection<ZyGraphNode<?>> collection) {
        this.selectedNodes.addAll(collection);
    }

    public void add(ZyGraphNode<?> zyGraphNode) {
        this.selectedNodes.add(zyGraphNode);
        for (ISnapshotListener iSnapshotListener : this.listeners) {
            iSnapshotListener.addedNode(zyGraphNode);
        }
    }

    public void addListener(ISnapshotListener iSnapshotListener) {
        this.listeners.addListener(iSnapshotListener);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SelectionSnapshot)) {
            return false;
        }
        return (SelectionSnapshot)object != null && ((SelectionSnapshot)object).selectedNodes.equals(this.selectedNodes);
    }

    public Collection<CombinedDiffNode> getCombinedGraphSelection() {
        ArrayList<CombinedDiffNode> arrayList = new ArrayList<CombinedDiffNode>();
        for (ZyGraphNode<?> zyGraphNode : this.selectedNodes) {
            if (!(zyGraphNode instanceof CombinedDiffNode)) continue;
            arrayList.add((CombinedDiffNode)zyGraphNode);
        }
        return arrayList;
    }

    public String getDescription() {
        String string = "No Selection";
        if (this.selectedNodes.size() == 1) {
            String string2 = "";
            ZyGraphNode<?> zyGraphNode = this.selectedNodes.get(0);
            if (zyGraphNode instanceof SingleDiffNode) {
                string2 = ((SingleDiffNode)zyGraphNode).getRawNode().getAddress().toHexString();
            } else if (zyGraphNode instanceof CombinedDiffNode) {
                CombinedDiffNode combinedDiffNode = (CombinedDiffNode)zyGraphNode;
                SingleViewNode singleViewNode = combinedDiffNode.getPrimaryRawNode();
                SingleViewNode singleViewNode2 = combinedDiffNode.getSecondaryRawNode();
                string2 = singleViewNode == null ? "missing" : singleViewNode.getAddress().toHexString();
                string2 = string2 + " - ";
                string2 = string2 + (singleViewNode2 == null ? "missing" : singleViewNode2.getAddress().toHexString());
            }
            string = String.format("Single Selection (%s)", string2);
        } else if (this.selectedNodes.size() > 1) {
            string = "Group Selection";
        }
        return string;
    }

    public int getNumberOfSelectedNodes() {
        return this.selectedNodes.size();
    }

    public Collection<ZyGraphNode<?>> getSelection() {
        return this.selectedNodes;
    }

    public Collection<SingleDiffNode> getSingleGraphSelection() {
        ArrayList<SingleDiffNode> arrayList = new ArrayList<SingleDiffNode>();
        for (ZyGraphNode<?> zyGraphNode : this.selectedNodes) {
            if (!(zyGraphNode instanceof SingleDiffNode)) continue;
            arrayList.add((SingleDiffNode)zyGraphNode);
        }
        return arrayList;
    }

    public int hashCode() {
        return this.selectedNodes.hashCode();
    }

    public void modicationFinished() {
        for (ISnapshotListener iSnapshotListener : this.listeners) {
            iSnapshotListener.finished();
        }
    }

    public void remove(ZyGraphNode<?> zyGraphNode) {
        this.selectedNodes.remove(zyGraphNode);
        for (ISnapshotListener iSnapshotListener : this.listeners) {
            iSnapshotListener.removedNode(zyGraphNode);
        }
    }

    public void removeListener(ISnapshotListener iSnapshotListener) {
        this.listeners.removeListener(iSnapshotListener);
    }
}

