/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeFilter;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.ISelectionHistoryListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistory;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistoryRootNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistoryTree;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistoryTreeGroupNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistoryTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionSnapshot;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphSelectionListener;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphVisibilityListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class SelectionHistoryTreePanel
extends JPanel {
    private SelectionHistoryTree tree;
    private DefaultTreeModel model;
    private final InternalGraphSelectionListener graphSelectionListener = new InternalGraphSelectionListener();
    private final InternalGraphVisibilityListener graphVisibilityListener = new InternalGraphVisibilityListener();
    private final InternalSelectionHistoryListener selectionHistoryListener = new InternalSelectionHistoryListener();
    private final InternalTreeSelectionListener treeSelectionListener = new InternalTreeSelectionListener();
    private final InternalTreeMouseListener treeMouseListener = new InternalTreeMouseListener();
    private int childCount = 0;
    private BinDiffGraph<?, ?> graph;
    private final SelectionHistory selectionHistory;

    public SelectionHistoryTreePanel(ViewTabPanelFunctions viewTabPanelFunctions, BinDiffGraph<?, ?> binDiffGraph, SelectionHistory selectionHistory) {
        super(new BorderLayout());
        Preconditions.checkNotNull(viewTabPanelFunctions);
        this.graph = Preconditions.checkNotNull(binDiffGraph);
        this.selectionHistory = Preconditions.checkNotNull(selectionHistory);
        this.tree = this.createTree(viewTabPanelFunctions);
        this.createPanel();
        this.selectionHistory.addHistoryListener(this.selectionHistoryListener);
        binDiffGraph.getIntermediateListeners().addIntermediateListener(this.graphSelectionListener);
        binDiffGraph.getIntermediateListeners().addIntermediateListener(this.graphVisibilityListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.addMouseListener(this.treeMouseListener);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    private void createPanel() {
        this.tree.setRootVisible(true);
        this.tree.setSelectionModel(null);
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    private SelectionHistoryTree createTree(ViewTabPanelFunctions viewTabPanelFunctions) {
        SelectionHistoryRootNode selectionHistoryRootNode = new SelectionHistoryRootNode(viewTabPanelFunctions, this.graph, "Selection History");
        SelectionHistoryTree selectionHistoryTree = new SelectionHistoryTree(selectionHistoryRootNode);
        selectionHistoryRootNode.setTree(selectionHistoryTree);
        this.model = new DefaultTreeModel(selectionHistoryRootNode);
        this.model.nodeStructureChanged(selectionHistoryRootNode);
        selectionHistoryTree.setRootVisible(true);
        selectionHistoryTree.getSelectionModel().setSelectionMode(1);
        return selectionHistoryTree;
    }

    private void insertSnapshot(SelectionSnapshot selectionSnapshot) {
        SelectionHistoryTreeGroupNode selectionHistoryTreeGroupNode = new SelectionHistoryTreeGroupNode(selectionSnapshot, this.childCount);
        for (ZyGraphNode<?> zyGraphNode : selectionSnapshot.getSelection()) {
            SelectionHistoryTreeNode selectionHistoryTreeNode = new SelectionHistoryTreeNode(zyGraphNode);
            selectionHistoryTreeGroupNode.add(selectionHistoryTreeNode);
        }
        ++this.childCount;
        this.model.insertNodeInto(selectionHistoryTreeGroupNode, (SelectionHistoryRootNode)this.model.getRoot(), 0);
    }

    private void selectCombinedNodes(Collection<CombinedDiffNode> collection) {
        this.graph.getIntermediateListeners().removeIntermediateListener(this.graphSelectionListener);
        if (this.graph instanceof CombinedGraph) {
            List<CombinedDiffNode> list = GraphNodeFilter.filterNodes((CombinedGraph)this.graph, GraphNodeFilter.Criterion.SELECTED);
            ((CombinedGraph)this.graph).selectNodes(list, false);
            ((CombinedGraph)this.graph).selectNodes(collection, true);
        }
        this.graph.getIntermediateListeners().addIntermediateListener(this.graphSelectionListener);
    }

    private void selectSingleNodes(Collection<SingleDiffNode> collection) {
        this.graph.getIntermediateListeners().removeIntermediateListener(this.graphSelectionListener);
        if (this.graph instanceof SingleGraph) {
            List<SingleDiffNode> list = GraphNodeFilter.filterNodes((SingleGraph)this.graph, GraphNodeFilter.Criterion.SELECTED);
            ((SingleGraph)this.graph).selectNodes(list, false);
            ((SingleGraph)this.graph).selectNodes(collection, true);
        }
        this.graph.getIntermediateListeners().addIntermediateListener(this.graphSelectionListener);
    }

    private void unselectCombinedNodes(Collection<CombinedDiffNode> collection) {
        this.graph.getIntermediateListeners().removeIntermediateListener(this.graphSelectionListener);
        if (this.graph instanceof CombinedGraph) {
            ((CombinedGraph)this.graph).selectNodes(collection, false);
        }
        this.graph.getIntermediateListeners().addIntermediateListener(this.graphSelectionListener);
    }

    private void unselectSingleNodes(Collection<SingleDiffNode> collection) {
        this.graph.getIntermediateListeners().removeIntermediateListener(this.graphSelectionListener);
        if (this.graph instanceof SingleGraph) {
            ((SingleGraph)this.graph).selectNodes(collection, false);
        }
        this.graph.getIntermediateListeners().addIntermediateListener(this.graphSelectionListener);
    }

    public void dispose() {
        this.selectionHistory.removeHistoryListener(this.selectionHistoryListener);
        this.graph.getIntermediateListeners().removeIntermediateListener(this.graphSelectionListener);
        this.graph.getIntermediateListeners().removeIntermediateListener(this.graphVisibilityListener);
        this.tree.removeMouseListener(this.treeMouseListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.setSelectionModel(new DefaultTreeSelectionModel());
        this.tree.setCellRenderer(null);
        this.tree.dispose();
        this.tree = null;
        this.graph = null;
    }

    public int getChildCount() {
        return this.childCount;
    }

    private class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            SelectionHistoryTreeGroupNode selectionHistoryTreeGroupNode = (SelectionHistoryTreeGroupNode)SelectionHistoryTreePanel.this.tree.getLastSelectedPathComponent();
            if (selectionHistoryTreeGroupNode == null || selectionHistoryTreeGroupNode.getParent() != SelectionHistoryTreePanel.this.model.getRoot()) {
                return;
            }
            int n2 = SelectionHistoryTreePanel.this.selectionHistory.getNumberOfSnapshots() - SelectionHistoryTreePanel.this.model.getIndexOfChild(SelectionHistoryTreePanel.this.model.getRoot(), selectionHistoryTreeGroupNode) - 1;
            SelectionSnapshot selectionSnapshot = SelectionHistoryTreePanel.this.selectionHistory.getSnapshot(n2);
            if (SelectionHistoryTreePanel.this.graph instanceof SingleGraph) {
                SelectionHistoryTreePanel.this.selectSingleNodes(selectionSnapshot.getSingleGraphSelection());
            } else if (SelectionHistoryTreePanel.this.graph instanceof CombinedGraph) {
                SelectionHistoryTreePanel.this.selectCombinedNodes(selectionSnapshot.getCombinedGraphSelection());
            }
            SelectionHistoryTreePanel.this.tree.updateUI();
        }
    }

    private class InternalTreeMouseListener
    extends MouseAdapter {
        private InternalTreeMouseListener() {
        }

        private TreePath getTreePath(MouseEvent mouseEvent) {
            return SelectionHistoryTreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath = this.getTreePath(mouseEvent);
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (mouseEvent.getButton() == 1) {
                SelectionHistoryTreePanel.this.graph.getPrimaryGraph().getSelectionHistory().setEnabled(false);
                SelectionHistoryTreePanel.this.graph.getSecondaryGraph().getSelectionHistory().setEnabled(false);
                SelectionHistoryTreePanel.this.graph.getCombinedGraph().getSelectionHistory().setEnabled(false);
                if (object instanceof SelectionHistoryTreeGroupNode) {
                    SelectionHistoryTreeGroupNode selectionHistoryTreeGroupNode = (SelectionHistoryTreeGroupNode)object;
                    if (SelectionHistoryTreePanel.this.graph instanceof SingleGraph) {
                        List<SingleDiffNode> list;
                        Collection<SingleDiffNode> collection = selectionHistoryTreeGroupNode.getSnapshot().getSingleGraphSelection();
                        if (new HashSet<SingleDiffNode>(collection).equals(new HashSet<SingleDiffNode>(list = GraphNodeFilter.filterNodes((SingleGraph)SelectionHistoryTreePanel.this.graph, GraphNodeFilter.Criterion.SELECTED)))) {
                            SelectionHistoryTreePanel.this.unselectSingleNodes(collection);
                        } else {
                            SelectionHistoryTreePanel.this.selectSingleNodes(collection);
                        }
                    } else if (SelectionHistoryTreePanel.this.graph instanceof CombinedGraph) {
                        List<CombinedDiffNode> list;
                        Collection<CombinedDiffNode> collection = selectionHistoryTreeGroupNode.getSnapshot().getCombinedGraphSelection();
                        if (new HashSet<CombinedDiffNode>(collection).equals(new HashSet<CombinedDiffNode>(list = GraphNodeFilter.filterNodes((CombinedGraph)SelectionHistoryTreePanel.this.graph, GraphNodeFilter.Criterion.SELECTED)))) {
                            SelectionHistoryTreePanel.this.unselectCombinedNodes(collection);
                        } else {
                            SelectionHistoryTreePanel.this.selectCombinedNodes(collection);
                        }
                    }
                } else if (object instanceof SelectionHistoryTreeNode) {
                    SelectionHistoryTreeNode selectionHistoryTreeNode = (SelectionHistoryTreeNode)object;
                    ZyGraphNode<?> zyGraphNode = selectionHistoryTreeNode.getNode();
                    boolean bl2 = zyGraphNode.isSelected();
                    SelectionHistoryTreePanel.this.graph.getIntermediateListeners().removeIntermediateListener(SelectionHistoryTreePanel.this.graphSelectionListener);
                    if (zyGraphNode instanceof SingleDiffNode) {
                        ((SingleGraph)SelectionHistoryTreePanel.this.graph).selectNode((SingleDiffNode)zyGraphNode, !bl2);
                    } else if (zyGraphNode instanceof CombinedDiffNode) {
                        ((CombinedGraph)SelectionHistoryTreePanel.this.graph).selectNode((CombinedDiffNode)zyGraphNode, !bl2);
                    }
                    SelectionHistoryTreePanel.this.graph.getIntermediateListeners().addIntermediateListener(SelectionHistoryTreePanel.this.graphSelectionListener);
                }
                SelectionHistoryTreePanel.this.graph.getPrimaryGraph().getSelectionHistory().setEnabled(true);
                SelectionHistoryTreePanel.this.graph.getSecondaryGraph().getSelectionHistory().setEnabled(true);
                SelectionHistoryTreePanel.this.graph.getCombinedGraph().getSelectionHistory().setEnabled(true);
            }
        }
    }

    private class InternalSelectionHistoryListener
    implements ISelectionHistoryListener {
        private InternalSelectionHistoryListener() {
        }

        @Override
        public void finishedRedo() {
            SelectionHistoryTreePanel.this.graph.getIntermediateListeners().addIntermediateListener(SelectionHistoryTreePanel.this.graphSelectionListener);
            SelectionHistoryTreePanel.this.tree.updateUI();
        }

        @Override
        public void finishedUndo() {
            SelectionHistoryTreePanel.this.graph.getIntermediateListeners().addIntermediateListener(SelectionHistoryTreePanel.this.graphSelectionListener);
            SelectionHistoryTreePanel.this.tree.updateUI();
        }

        @Override
        public void snapshotAdded(SelectionSnapshot selectionSnapshot) {
            SelectionHistoryTreePanel.this.insertSnapshot(selectionSnapshot);
        }

        @Override
        public void snapshotRemoved() {
            SelectionHistoryRootNode selectionHistoryRootNode = (SelectionHistoryRootNode)SelectionHistoryTreePanel.this.model.getRoot();
            int n2 = selectionHistoryRootNode.getChildCount();
            SelectionHistoryTreeGroupNode selectionHistoryTreeGroupNode = (SelectionHistoryTreeGroupNode)SelectionHistoryTreePanel.this.model.getChild(selectionHistoryRootNode, n2 - 1);
            selectionHistoryTreeGroupNode.dispose();
            SelectionHistoryTreePanel.this.model.removeNodeFromParent(selectionHistoryTreeGroupNode);
        }

        @Override
        public void startedRedo() {
            SelectionHistoryTreePanel.this.graph.getIntermediateListeners().removeIntermediateListener(SelectionHistoryTreePanel.this.graphSelectionListener);
        }

        @Override
        public void startedUndo() {
            SelectionHistoryTreePanel.this.graph.getIntermediateListeners().removeIntermediateListener(SelectionHistoryTreePanel.this.graphSelectionListener);
        }
    }

    private class InternalGraphVisibilityListener
    implements IZyGraphVisibilityListener {
        private InternalGraphVisibilityListener() {
        }

        @Override
        public void nodeDeleted() {
            SelectionHistoryTreePanel.this.updateUI();
        }

        @Override
        public void visibilityChanged() {
            SelectionHistoryTreePanel.this.updateUI();
        }
    }

    private class InternalGraphSelectionListener
    implements IZyGraphSelectionListener {
        private SelectionSnapshot lastSnapshot;

        private InternalGraphSelectionListener() {
        }

        @Override
        public void selectionChanged() {
            SelectionSnapshot selectionSnapshot = new SelectionSnapshot(GraphNodeFilter.filterNodes(SelectionHistoryTreePanel.this.graph, GraphNodeFilter.Criterion.SELECTED));
            if (selectionSnapshot.getNumberOfSelectedNodes() != 0 && !selectionSnapshot.equals(this.lastSnapshot)) {
                SelectionHistoryTreePanel.this.selectionHistory.addSnapshot(selectionSnapshot);
                this.lastSnapshot = selectionSnapshot;
            }
            SelectionHistoryTreePanel.this.updateUI();
        }
    }
}

