/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory;

import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.popupmenus.CallGraphPopupMenu;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.popupmenus.FlowGraphPopupMenu;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.AbstractSelectionHistoryTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistoryRootNode;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class SelectionHistoryTreeNode
extends AbstractSelectionHistoryTreeNode {
    private static final ImageIcon ICON_SELECTED_GRAPHNODE = ImageUtils.getImageIcon("data/selectionicons/graphnode-selection.png");
    private static final ImageIcon ICON_NO_SELECTED_GRAPHNODES = ImageUtils.getImageIcon("data/selectionicons/no-selected-graphnodes.png");
    private static final ImageIcon ICON_NO_SELECTED_GRAPHNODES_GRAY = ImageUtils.getImageIcon("data/selectionicons/no-selected-graphnodes-gray.png");
    private final ZyGraphNode<?> node;

    public SelectionHistoryTreeNode(ZyGraphNode<?> zyGraphNode) {
        super(SelectionHistoryTreeNode.getNodeName(zyGraphNode));
        this.node = zyGraphNode;
    }

    private static String getCombinedNodeName(CombinedDiffNode combinedDiffNode) {
        String string = "";
        CombinedViewNode combinedViewNode = combinedDiffNode.getRawNode();
        SingleViewNode singleViewNode = combinedViewNode.getRawNode(ESide.PRIMARY);
        string = singleViewNode == null ? string + "Unmatched" : string + SelectionHistoryTreeNode.getSingleNodeName(singleViewNode);
        string = string + " \u2194 ";
        SingleViewNode singleViewNode2 = combinedViewNode.getRawNode(ESide.SECONDARY);
        string = singleViewNode2 == null ? string + "Unmatched" : string + SelectionHistoryTreeNode.getSingleNodeName(singleViewNode2);
        return string;
    }

    private static String getNodeName(ZyGraphNode<?> zyGraphNode) {
        String string = "";
        if (zyGraphNode instanceof SingleDiffNode) {
            string = string + SelectionHistoryTreeNode.getSingleNodeName((SingleViewNode)zyGraphNode.getRawNode());
        } else if (zyGraphNode instanceof CombinedDiffNode) {
            string = string + SelectionHistoryTreeNode.getCombinedNodeName((CombinedDiffNode)zyGraphNode);
        }
        return string;
    }

    private static String getSingleNodeName(SingleViewNode singleViewNode) {
        String string = "";
        if (singleViewNode instanceof RawFunction) {
            string = string + singleViewNode.getAddress() + " " + ((RawFunction)singleViewNode).getName();
        } else if (singleViewNode instanceof RawBasicBlock) {
            string = string + singleViewNode.getAddress();
        }
        return string;
    }

    @Override
    public ImageIcon getIcon() {
        if (!this.node.isVisible()) {
            return ICON_NO_SELECTED_GRAPHNODES_GRAY;
        }
        if (this.node.isSelected()) {
            return ICON_SELECTED_GRAPHNODE;
        }
        return ICON_NO_SELECTED_GRAPHNODES;
    }

    public ZyGraphNode<?> getNode() {
        return this.node;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        SelectionHistoryRootNode selectionHistoryRootNode = this.getRootNode();
        BinDiffGraph<?, ?> binDiffGraph = selectionHistoryRootNode.getGraph();
        if (binDiffGraph.getGraphType() == EGraphType.CALLGRAPH) {
            return new CallGraphPopupMenu(this.getRootNode().getController(), binDiffGraph, this.node);
        }
        if (binDiffGraph.getGraphType() == EGraphType.FLOWGRAPH) {
            return new FlowGraphPopupMenu(this.getRootNode().getController(), binDiffGraph, this.node);
        }
        return null;
    }
}

