/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory;

import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.AbstractSelectionHistoryTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.ISnapshotListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistoryTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistoryTreeNodeWrapper;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionSnapshot;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;

public class SelectionHistoryTreeGroupNode
extends AbstractSelectionHistoryTreeNode {
    private static final Icon ICON_ALL_UNSELECTED_GRAPHNODES = ImageUtils.getImageIcon("data/selectionicons/graph-selection-folder-all-unselected.png");
    private static final Icon ICON_ALL_SELECTED_GRAPHNODES = ImageUtils.getImageIcon("data/selectionicons/graph-selection-folder-open.png");
    private static final Icon ICON_ALL_UNVISIBLE_GRAPHNODES = ImageUtils.getImageIcon("data/selectionicons/graph-selection-folder-all-unselected-gray.png");
    private static final Icon ICON_ALL_UNSELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES = ImageUtils.getImageIcon("data/selectionicons/graph-selection-folder-all-unselected-halfgray.png");
    private static final Icon ICON_ALL_VISIBLE_SOME_SELECTED_SOME_UNSELECTED_GRAPHNODES = ImageUtils.getImageIcon("data/selectionicons/graph-selection-folder-some-unselected.png");
    private static final Icon ICON_SOME_SELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES = ImageUtils.getImageIcon("data/selectionicons/graph-selection-folder-some-unselected-halfgray.png");
    private static final Icon ICON_EMPTY_FOLDER = ImageUtils.getImageIcon("data/selectionicons/graph-selection-folder-empty.png");
    private static final Icon ICON_DUMMY = ImageUtils.getImageIcon("data/selectionicons/graph-selection-folder-closed.png");
    private final ISnapshotListener snapshotListener = new InternalSnapshotListener();
    private final SelectionSnapshot snapshot;
    private final int snapshotCount;

    public SelectionHistoryTreeGroupNode(SelectionSnapshot selectionSnapshot, int n2) {
        super(new SelectionHistoryTreeNodeWrapper(selectionSnapshot, n2).toString());
        this.snapshot = selectionSnapshot;
        selectionSnapshot.addListener(this.snapshotListener);
        this.snapshotCount = n2;
    }

    public void dispose() {
        this.snapshot.removeListener(this.snapshotListener);
    }

    @Override
    public Icon getIcon() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Collection<ZyGraphNode<?>> collection = this.snapshot.getSelection();
        for (ZyGraphNode<?> zyGraphNode : collection) {
            if (zyGraphNode.isSelected()) {
                ++n3;
            } else {
                ++n4;
            }
            if (!zyGraphNode.isVisible()) {
                ++n5;
            }
            ++n2;
        }
        if (n2 == 0) {
            return ICON_EMPTY_FOLDER;
        }
        if (n5 == n2) {
            return ICON_ALL_UNVISIBLE_GRAPHNODES;
        }
        if (n3 == n2) {
            return ICON_ALL_SELECTED_GRAPHNODES;
        }
        if (n4 == n2 && n5 == 0) {
            return ICON_ALL_UNSELECTED_GRAPHNODES;
        }
        if (n3 == 0) {
            return ICON_ALL_UNSELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES;
        }
        if (n5 == 0) {
            return ICON_ALL_VISIBLE_SOME_SELECTED_SOME_UNSELECTED_GRAPHNODES;
        }
        if (n5 != 0 && n3 != 0) {
            return ICON_SOME_SELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES;
        }
        return ICON_DUMMY;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        BinDiffGraph<?, ?> binDiffGraph = this.getRootNode().getGraph();
        if (binDiffGraph instanceof SingleGraph) {
            if (binDiffGraph.getGraphType() == EGraphType.CALLGRAPH) {
                JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Copy Function Addresses"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (SingleDiffNode singleDiffNode : SelectionHistoryTreeGroupNode.this.snapshot.getSingleGraphSelection()) {
                            stringBuilder.append(((RawFunction)singleDiffNode.getRawNode()).getAddress().toHexString());
                            stringBuilder.append("\n");
                        }
                        ClipboardHelpers.copyToClipboard(stringBuilder.toString());
                    }
                });
                JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction("Copy Function Names"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (SingleDiffNode singleDiffNode : SelectionHistoryTreeGroupNode.this.snapshot.getSingleGraphSelection()) {
                            stringBuilder.append(((RawFunction)singleDiffNode.getRawNode()).getName());
                            stringBuilder.append("\n");
                        }
                        ClipboardHelpers.copyToClipboard(stringBuilder.toString());
                    }
                });
                jPopupMenu.add(jMenuItem);
                jPopupMenu.add(jMenuItem2);
            } else if (binDiffGraph.getGraphType() == EGraphType.FLOWGRAPH) {
                JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Copy Basic Block Addresses"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (SingleDiffNode singleDiffNode : SelectionHistoryTreeGroupNode.this.snapshot.getSingleGraphSelection()) {
                            stringBuilder.append(((RawBasicBlock)singleDiffNode.getRawNode()).getAddress().toHexString());
                            stringBuilder.append("\n");
                        }
                        ClipboardHelpers.copyToClipboard(stringBuilder.toString());
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
        } else if (this.getRootNode().getGraph() instanceof CombinedGraph) {
            if (binDiffGraph.getGraphType() == EGraphType.CALLGRAPH) {
                JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Copy Primary Function Addresses"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (CombinedDiffNode combinedDiffNode : SelectionHistoryTreeGroupNode.this.snapshot.getCombinedGraphSelection()) {
                            RawFunction rawFunction = (RawFunction)combinedDiffNode.getPrimaryRawNode();
                            if (rawFunction == null) continue;
                            stringBuilder.append(rawFunction.getAddress().toHexString());
                            stringBuilder.append("\n");
                        }
                        ClipboardHelpers.copyToClipboard(stringBuilder.toString());
                    }
                });
                JMenuItem jMenuItem3 = new JMenuItem(new AbstractAction("Copy Secondary Function Addresses"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (CombinedDiffNode combinedDiffNode : SelectionHistoryTreeGroupNode.this.snapshot.getCombinedGraphSelection()) {
                            RawFunction rawFunction = (RawFunction)combinedDiffNode.getSecondaryRawNode();
                            if (rawFunction == null) continue;
                            stringBuilder.append(rawFunction.getAddress().toHexString());
                            stringBuilder.append("\n");
                        }
                        ClipboardHelpers.copyToClipboard(stringBuilder.toString());
                    }
                });
                JMenuItem jMenuItem4 = new JMenuItem(new AbstractAction("Copy Primary Function Names"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (CombinedDiffNode combinedDiffNode : SelectionHistoryTreeGroupNode.this.snapshot.getCombinedGraphSelection()) {
                            RawFunction rawFunction = (RawFunction)combinedDiffNode.getPrimaryRawNode();
                            if (rawFunction == null) continue;
                            stringBuilder.append(rawFunction.getAddress().toHexString());
                            stringBuilder.append("\n");
                        }
                        ClipboardHelpers.copyToClipboard(stringBuilder.toString());
                    }
                });
                JMenuItem jMenuItem5 = new JMenuItem(new AbstractAction("Copy Secondary Function Names"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (CombinedDiffNode combinedDiffNode : SelectionHistoryTreeGroupNode.this.snapshot.getCombinedGraphSelection()) {
                            RawFunction rawFunction = (RawFunction)combinedDiffNode.getSecondaryRawNode();
                            if (rawFunction == null) continue;
                            stringBuilder.append(rawFunction.getAddress().toHexString());
                            stringBuilder.append("\n");
                        }
                        ClipboardHelpers.copyToClipboard(stringBuilder.toString());
                    }
                });
                jPopupMenu.add(jMenuItem);
                jPopupMenu.add(jMenuItem4);
                jPopupMenu.add(jMenuItem3);
                jPopupMenu.add(jMenuItem5);
            } else if (binDiffGraph.getGraphType() == EGraphType.FLOWGRAPH) {
                JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Copy Primary Basic Block Addresses"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (CombinedDiffNode combinedDiffNode : SelectionHistoryTreeGroupNode.this.snapshot.getCombinedGraphSelection()) {
                            RawBasicBlock rawBasicBlock = (RawBasicBlock)combinedDiffNode.getPrimaryRawNode();
                            if (rawBasicBlock == null) continue;
                            stringBuilder.append(rawBasicBlock.getAddress().toHexString());
                            stringBuilder.append("\n");
                        }
                        ClipboardHelpers.copyToClipboard(stringBuilder.toString());
                    }
                });
                JMenuItem jMenuItem6 = new JMenuItem(new AbstractAction("Copy Secondary Basic Block Addresses"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (CombinedDiffNode combinedDiffNode : SelectionHistoryTreeGroupNode.this.snapshot.getCombinedGraphSelection()) {
                            RawBasicBlock rawBasicBlock = (RawBasicBlock)combinedDiffNode.getSecondaryRawNode();
                            if (rawBasicBlock == null) continue;
                            stringBuilder.append(rawBasicBlock.getAddress().toHexString());
                            stringBuilder.append("\n");
                        }
                        ClipboardHelpers.copyToClipboard(stringBuilder.toString());
                    }
                });
                jPopupMenu.add(jMenuItem);
                jPopupMenu.add(jMenuItem6);
            }
        }
        return jPopupMenu;
    }

    public SelectionSnapshot getSnapshot() {
        return this.snapshot;
    }

    private final class InternalSnapshotListener
    implements ISnapshotListener {
        private InternalSnapshotListener() {
        }

        @Override
        public void addedNode(ZyGraphNode<? extends IViewNode<?>> zyGraphNode) {
            SelectionHistoryTreeNode selectionHistoryTreeNode = new SelectionHistoryTreeNode(zyGraphNode);
            SelectionHistoryTreeGroupNode.this.add(selectionHistoryTreeNode);
            SelectionHistoryTreeGroupNode.this.setUserObject(new SelectionHistoryTreeNodeWrapper(SelectionHistoryTreeGroupNode.this.snapshot, SelectionHistoryTreeGroupNode.this.snapshotCount));
        }

        @Override
        public void finished() {
            ((DefaultTreeModel)SelectionHistoryTreeGroupNode.this.getTree().getModel()).nodeStructureChanged(SelectionHistoryTreeGroupNode.this);
            SelectionHistoryTreeGroupNode.this.getTree().updateUI();
        }

        @Override
        public void removedNode(ZyGraphNode<? extends IViewNode<?>> zyGraphNode) {
            for (int i2 = 0; i2 < SelectionHistoryTreeGroupNode.this.getChildCount(); ++i2) {
                SelectionHistoryTreeNode selectionHistoryTreeNode = (SelectionHistoryTreeNode)SelectionHistoryTreeGroupNode.this.getChildAt(i2);
                if (selectionHistoryTreeNode.getNode() != zyGraphNode) continue;
                ((DefaultTreeModel)SelectionHistoryTreeGroupNode.this.getTree().getModel()).removeNodeFromParent(selectionHistoryTreeNode);
                selectionHistoryTreeNode.removeFromParent();
                SelectionHistoryTreeGroupNode.this.setUserObject(new SelectionHistoryTreeNodeWrapper(SelectionHistoryTreeGroupNode.this.snapshot, SelectionHistoryTreeGroupNode.this.snapshotCount));
                break;
            }
        }
    }
}

