/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeFilter;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.AbstractSelectionHistoryTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistoryTreeGroupNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionHistoryTreeNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SelectionHistoryTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color NORMAL_FONT_COLOR = new Color(0, 0, 0);
    private static final Color INVISIBLE_FONT_COLOR = new Color(128, 128, 128);
    private static final Color SELECTED_FONT_COLOR = new Color(160, 0, 0);
    private static final Color MIXED_STATE_GROUP_NODE_COLOR = new Color(160, 120, 120);
    private final AbstractZyGraph<?, ?> graph;

    public SelectionHistoryTreeCellRenderer(AbstractZyGraph<?, ?> abstractZyGraph) {
        this.graph = Preconditions.checkNotNull(abstractZyGraph);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        this.setBackgroundSelectionColor(Color.WHITE);
        this.setBorderSelectionColor(Color.WHITE);
        super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
        Icon icon = ((AbstractSelectionHistoryTreeNode)object).getIcon();
        if (icon != null) {
            this.setIcon(icon);
        }
        List<?> list = GraphNodeFilter.filterNodes(this.graph, GraphNodeFilter.Criterion.SELECTED_VISIBLE);
        List<?> list2 = GraphNodeFilter.filterNodes(this.graph, GraphNodeFilter.Criterion.INVISIBLE);
        this.setForeground(NORMAL_FONT_COLOR);
        if (object instanceof SelectionHistoryTreeGroupNode) {
            SelectionHistoryTreeGroupNode selectionHistoryTreeGroupNode = (SelectionHistoryTreeGroupNode)object;
            if (!selectionHistoryTreeGroupNode.isRoot()) {
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                Collection<ZyGraphNode<?>> collection = selectionHistoryTreeGroupNode.getSnapshot().getSelection();
                for (ZyGraphNode<?> zyGraphNode : collection) {
                    ++n3;
                    if (zyGraphNode.isVisible()) {
                        if (zyGraphNode.isSelected()) {
                            ++n4;
                            continue;
                        }
                        ++n5;
                        continue;
                    }
                    ++n6;
                }
                if (n3 == n4) {
                    this.setForeground(SELECTED_FONT_COLOR);
                } else if (n3 == n5) {
                    this.setForeground(NORMAL_FONT_COLOR);
                } else if (n3 == n6) {
                    this.setForeground(INVISIBLE_FONT_COLOR);
                } else {
                    this.setForeground(MIXED_STATE_GROUP_NODE_COLOR);
                }
            }
        } else if (object instanceof SelectionHistoryTreeNode) {
            SelectionHistoryTreeNode selectionHistoryTreeNode = (SelectionHistoryTreeNode)object;
            ZyGraphNode<?> zyGraphNode = selectionHistoryTreeNode.getNode();
            if (list.contains(zyGraphNode)) {
                this.setForeground(SELECTED_FONT_COLOR);
            } else if (list2.contains(zyGraphNode)) {
                this.setForeground(INVISIBLE_FONT_COLOR);
            }
        }
        return this;
    }
}

