/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.filter.GraphNodeFilter;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.ISelectionHistoryListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.selectionhistory.SelectionSnapshot;
import com.google.security.zynamics.bindiff.project.matches.IMatchesChangeListener;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class SelectionHistory {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final List<SelectionSnapshot> snapshotList = new ArrayList<SelectionSnapshot>();
    private final ListenerProvider<ISelectionHistoryListener> listeners = new ListenerProvider();
    private final InternalMatchedChangedListener matchChangeListener = new InternalMatchedChangedListener();
    private SingleGraph singleGraph;
    private CombinedGraph combinedGraph;
    private final int maxSnapshots;
    private int undoIndex = -1;
    private boolean freeze = false;

    public SelectionHistory(AbstractZyGraph<?, ?> abstractZyGraph, int n2) {
        Preconditions.checkNotNull(abstractZyGraph);
        Preconditions.checkArgument(n2 > 0, "Invalid undo level");
        if (abstractZyGraph instanceof SingleGraph) {
            this.singleGraph = (SingleGraph)abstractZyGraph;
            this.combinedGraph = null;
        } else if (abstractZyGraph instanceof CombinedGraph) {
            this.combinedGraph = (CombinedGraph)abstractZyGraph;
            this.singleGraph = null;
        } else {
            throw new IllegalArgumentException("Graph must be an instance of SingleGraph or CombinedGraph.");
        }
        this.maxSnapshots = n2;
        this.addSnapshot(new SelectionSnapshot(new ArrayList()));
    }

    public void addHistoryListener(ISelectionHistoryListener iSelectionHistoryListener) {
        this.listeners.addListener(iSelectionHistoryListener);
    }

    public void addSnapshot(SelectionSnapshot selectionSnapshot) {
        if (this.freeze) {
            return;
        }
        this.snapshotList.add(selectionSnapshot);
        if (this.snapshotList.size() > this.maxSnapshots) {
            this.snapshotList.remove(0);
            for (ISelectionHistoryListener iSelectionHistoryListener : this.listeners) {
                iSelectionHistoryListener.snapshotRemoved();
            }
        }
        this.undoIndex = this.getNumberOfSnapshots() - 1;
        for (ISelectionHistoryListener iSelectionHistoryListener : this.listeners) {
            iSelectionHistoryListener.snapshotAdded(selectionSnapshot);
        }
    }

    public boolean canRedo() {
        return this.undoIndex <= this.getNumberOfSnapshots() - 1;
    }

    public boolean canUndo() {
        return this.undoIndex >= 0;
    }

    public void dispose() {
        for (ISelectionHistoryListener iSelectionHistoryListener : this.listeners) {
            this.removeHistoryListener(iSelectionHistoryListener);
        }
        this.snapshotList.clear();
        if (this.singleGraph != null) {
            this.singleGraph.getGraphs().getDiff().getMatches().removeListener(this.matchChangeListener);
        }
        if (this.combinedGraph != null) {
            this.combinedGraph.getGraphs().getDiff().getMatches().removeListener(this.matchChangeListener);
        }
        this.singleGraph = null;
        this.combinedGraph = null;
    }

    public int getNumberOfSnapshots() {
        return this.snapshotList.size();
    }

    public SelectionSnapshot getSnapshot(boolean bl2) {
        if (bl2) {
            if (this.undoIndex != 0) {
                --this.undoIndex;
            }
            return this.getSnapshot(this.undoIndex);
        }
        if (this.undoIndex != this.getNumberOfSnapshots() - 1) {
            ++this.undoIndex;
        }
        return this.getSnapshot(this.undoIndex);
    }

    public SelectionSnapshot getSnapshot(int n2) {
        return this.snapshotList.get(n2);
    }

    public void redo() {
        for (ISelectionHistoryListener collection : this.listeners) {
            try {
                collection.startedRedo();
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Selection history listener notification failed");
            }
        }
        if (!this.snapshotList.isEmpty() && this.canRedo()) {
            List<CombinedDiffNode> list;
            if (this.combinedGraph == null) {
                list = GraphNodeFilter.filterNodes(this.singleGraph, GraphNodeFilter.Criterion.SELECTED);
                this.singleGraph.selectNodes(list, false);
                Collection<SingleDiffNode> collection = this.getSnapshot(false).getSingleGraphSelection();
                this.singleGraph.selectNodes(collection, true);
            } else {
                list = GraphNodeFilter.filterNodes(this.combinedGraph, GraphNodeFilter.Criterion.SELECTED);
                this.combinedGraph.selectNodes(list, false);
                Collection<CombinedDiffNode> collection = this.getSnapshot(false).getCombinedGraphSelection();
                this.combinedGraph.selectNodes(collection, true);
            }
        }
        for (ISelectionHistoryListener iSelectionHistoryListener : this.listeners) {
            try {
                iSelectionHistoryListener.finishedRedo();
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Selection history listener notification failed");
            }
        }
    }

    public void registerMatchListener() {
        if (this.singleGraph != null) {
            this.singleGraph.getGraphs().getDiff().getMatches().addListener(this.matchChangeListener);
        } else {
            this.combinedGraph.getGraphs().getDiff().getMatches().addListener(this.matchChangeListener);
        }
    }

    public void removeHistoryListener(ISelectionHistoryListener iSelectionHistoryListener) {
        try {
            this.listeners.removeListener(iSelectionHistoryListener);
        }
        catch (Exception exception) {
            logger.at(Level.WARNING).log("Listener was not listening.");
        }
    }

    public void setEnabled(boolean bl2) {
        this.freeze = !bl2;
    }

    public void undo() {
        for (ISelectionHistoryListener collection : this.listeners) {
            try {
                collection.startedUndo();
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Selection history listener notification failed");
            }
        }
        if (!this.snapshotList.isEmpty() && this.canUndo()) {
            List<CombinedDiffNode> list;
            if (this.combinedGraph == null) {
                list = GraphNodeFilter.filterNodes(this.singleGraph, GraphNodeFilter.Criterion.SELECTED);
                this.singleGraph.selectNodes(list, false);
                Collection<SingleDiffNode> collection = this.getSnapshot(true).getSingleGraphSelection();
                this.singleGraph.selectNodes(collection, true);
            } else {
                list = GraphNodeFilter.filterNodes(this.combinedGraph, GraphNodeFilter.Criterion.SELECTED);
                this.combinedGraph.selectNodes(list, false);
                Collection<CombinedDiffNode> collection = this.getSnapshot(true).getCombinedGraphSelection();
                this.combinedGraph.selectNodes(collection, true);
            }
        }
        for (ISelectionHistoryListener iSelectionHistoryListener : this.listeners) {
            try {
                iSelectionHistoryListener.finishedUndo();
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Selection history listener notification failed");
            }
        }
    }

    private class InternalMatchedChangedListener
    implements IMatchesChangeListener {
        private InternalMatchedChangedListener() {
        }

        private BinDiffGraph<? extends ZyGraphNode<?>, ?> getGraph() {
            return SelectionHistory.this.singleGraph != null ? SelectionHistory.this.singleGraph : SelectionHistory.this.combinedGraph;
        }

        private SingleDiffNode getNewDiffNode(IAddress iAddress) {
            for (SingleDiffNode singleDiffNode : SelectionHistory.this.singleGraph.getNodes()) {
                if (!singleDiffNode.getRawNode().getAddress().equals(iAddress)) continue;
                return singleDiffNode;
            }
            return null;
        }

        private CombinedDiffNode getNewDiffNode(IAddress iAddress, ESide eSide) {
            for (CombinedDiffNode combinedDiffNode : SelectionHistory.this.combinedGraph.getNodes()) {
                RawCombinedBasicBlock rawCombinedBasicBlock = (RawCombinedBasicBlock)combinedDiffNode.getRawNode();
                if (!iAddress.equals(rawCombinedBasicBlock.getAddress(eSide))) continue;
                return combinedDiffNode;
            }
            return null;
        }

        private void refreshSnapshots(CombinedDiffNode combinedDiffNode, CombinedDiffNode combinedDiffNode2) {
            Preconditions.checkNotNull(combinedDiffNode);
            Preconditions.checkNotNull(combinedDiffNode2);
            IAddress iAddress = combinedDiffNode.getRawNode().getAddress(ESide.PRIMARY);
            IAddress iAddress2 = combinedDiffNode2.getRawNode().getAddress(ESide.SECONDARY);
            block0: for (SelectionSnapshot selectionSnapshot : SelectionHistory.this.snapshotList) {
                for (CombinedDiffNode combinedDiffNode3 : selectionSnapshot.getCombinedGraphSelection()) {
                    if (!iAddress.equals(combinedDiffNode3.getRawNode().getAddress(ESide.PRIMARY)) || !iAddress2.equals(combinedDiffNode3.getRawNode().getAddress(ESide.SECONDARY))) continue;
                    selectionSnapshot.remove(combinedDiffNode3);
                    selectionSnapshot.add(combinedDiffNode);
                    selectionSnapshot.add(combinedDiffNode2);
                    selectionSnapshot.modicationFinished();
                    continue block0;
                }
            }
        }

        private void refreshSnapshots(SingleDiffNode singleDiffNode) {
            Preconditions.checkNotNull(singleDiffNode);
            IAddress iAddress = singleDiffNode.getRawNode().getAddress();
            block0: for (SelectionSnapshot selectionSnapshot : SelectionHistory.this.snapshotList) {
                for (SingleDiffNode singleDiffNode2 : selectionSnapshot.getSingleGraphSelection()) {
                    if (!singleDiffNode2.getRawNode().getAddress().equals(iAddress)) continue;
                    selectionSnapshot.remove(singleDiffNode2);
                    selectionSnapshot.add(singleDiffNode);
                    selectionSnapshot.modicationFinished();
                    continue block0;
                }
            }
        }

        private void updateSnapshots(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
            BinDiffGraph<ZyGraphNode<?>, ?> binDiffGraph = this.getGraph();
            if (binDiffGraph.getGraphType() == EGraphType.CALLGRAPH) {
                return;
            }
            if (iAddress.equals(binDiffGraph.getPrimaryGraph().getFunctionAddress()) && iAddress2.equals(binDiffGraph.getSecondaryGraph().getFunctionAddress())) {
                if (SelectionHistory.this.singleGraph != null) {
                    this.refreshSnapshots(this.getNewDiffNode(SelectionHistory.this.singleGraph.getSide() == ESide.PRIMARY ? iAddress3 : iAddress4));
                } else {
                    this.refreshSnapshots(this.getNewDiffNode(iAddress3, ESide.PRIMARY), this.getNewDiffNode(iAddress4, ESide.SECONDARY));
                }
            }
        }

        @Override
        public void addedBasicBlockMatch(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
            this.updateSnapshots(iAddress, iAddress2, iAddress3, iAddress4);
        }

        @Override
        public void removedBasicBlockMatch(IAddress iAddress, IAddress iAddress2, IAddress iAddress3, IAddress iAddress4) {
            this.updateSnapshots(iAddress, iAddress2, iAddress3, iAddress4);
        }
    }
}

