/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.popupmenus;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.AddNodeMatchAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.CopyBasicBlockAddressAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.DeleteNodeMatchAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.ZoomToNodeAction;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class FlowGraphPopupMenu
extends JPopupMenu {
    public FlowGraphPopupMenu(ViewTabPanelFunctions viewTabPanelFunctions, BinDiffGraph<?, ?> binDiffGraph, ZyGraphNode<?> zyGraphNode) {
        Preconditions.checkNotNull(binDiffGraph);
        Preconditions.checkNotNull(zyGraphNode);
        JMenuItem jMenuItem = new JMenuItem(new AddNodeMatchAction(viewTabPanelFunctions, binDiffGraph, zyGraphNode));
        JMenuItem jMenuItem2 = new JMenuItem(new DeleteNodeMatchAction(viewTabPanelFunctions, binDiffGraph, zyGraphNode));
        JMenuItem jMenuItem3 = new JMenuItem(new ZoomToNodeAction(binDiffGraph, zyGraphNode));
        jMenuItem.setEnabled(ViewTabPanelFunctions.isNodeSelectionMatchAddable(binDiffGraph, zyGraphNode));
        jMenuItem2.setEnabled(ViewTabPanelFunctions.isNodeSelectionMatchDeletable(binDiffGraph, zyGraphNode));
        this.add(jMenuItem);
        this.add(jMenuItem2);
        this.add(new JSeparator());
        this.add(jMenuItem3);
        this.add(new JSeparator());
        if (zyGraphNode instanceof CombinedDiffNode) {
            JMenuItem jMenuItem4;
            CombinedDiffNode combinedDiffNode = (CombinedDiffNode)zyGraphNode;
            if (combinedDiffNode.getPrimaryDiffNode() != null) {
                jMenuItem4 = new JMenuItem(new CopyBasicBlockAddressAction(combinedDiffNode, ESide.PRIMARY));
                this.add(jMenuItem4);
            }
            if (combinedDiffNode.getSecondaryDiffNode() != null) {
                jMenuItem4 = new JMenuItem(new CopyBasicBlockAddressAction(combinedDiffNode, ESide.SECONDARY));
                this.add(jMenuItem4);
            }
        } else if (zyGraphNode instanceof SingleDiffNode) {
            JMenuItem jMenuItem5 = new JMenuItem(new CopyBasicBlockAddressAction((SingleDiffNode)zyGraphNode));
            this.add(jMenuItem5);
        }
    }
}

