/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.menubar;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EGraphSynchronization;
import com.google.security.zynamics.bindiff.graph.settings.GraphLayoutSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphProximityBrowsingSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettingsChangedListenerAdapter;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.SwitchToCombinedViewModeAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.SwitchToNormalViewModeAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.ToggleAutomaticLayoutAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.ToggleGraphSynchronizationAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.ToggleProximityBrowsingAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.ToggleProximityFreezeModeAction;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import java.awt.Toolkit;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class ModesMenu
extends JMenu {
    private JRadioButtonMenuItem normalViewMode;
    private JRadioButtonMenuItem combinedViewMode;
    private JCheckBoxMenuItem synchronizeGraphs;
    private JCheckBoxMenuItem automaticLayout;
    private JCheckBoxMenuItem proximityBrowsing;
    private JCheckBoxMenuItem proximityFreezeMode;
    private InternalSettingsListener settingsListener = new InternalSettingsListener();
    private ViewTabPanelFunctions controller;

    public ModesMenu(ViewTabPanelFunctions viewTabPanelFunctions) {
        super("Mode");
        this.setMnemonic('M');
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.controller = Preconditions.checkNotNull(viewTabPanelFunctions);
        this.normalViewMode = GuiUtils.buildRadioButtonMenuItem("Normal View Mode", 'N', 49, n2, new SwitchToNormalViewModeAction(viewTabPanelFunctions));
        this.combinedViewMode = GuiUtils.buildRadioButtonMenuItem("Combined View Mode", 'C', 50, n2, new SwitchToCombinedViewModeAction(viewTabPanelFunctions));
        this.synchronizeGraphs = GuiUtils.buildCheckBoxMenuItem("Synchronize Graphs", 'S', 119, 0, new ToggleGraphSynchronizationAction(viewTabPanelFunctions));
        this.automaticLayout = GuiUtils.buildCheckBoxMenuItem("Automatic Layout", 'A', 116, 0, new ToggleAutomaticLayoutAction(viewTabPanelFunctions));
        this.proximityBrowsing = GuiUtils.buildCheckBoxMenuItem("Proximity Browsing", 'P', 117, 0, new ToggleProximityBrowsingAction(viewTabPanelFunctions));
        this.proximityFreezeMode = GuiUtils.buildCheckBoxMenuItem("Proximity Freeze-Mode", 'F', 118, 0, new ToggleProximityFreezeModeAction(viewTabPanelFunctions));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.normalViewMode.setSelected(true);
        buttonGroup.add(this.normalViewMode);
        buttonGroup.add(this.combinedViewMode);
        this.add(this.normalViewMode);
        this.add(this.combinedViewMode);
        this.add(new JSeparator());
        this.add(this.automaticLayout);
        this.add(this.proximityBrowsing);
        this.add(this.proximityFreezeMode);
        this.add(new JSeparator());
        this.add(this.synchronizeGraphs);
        GraphSettings graphSettings = viewTabPanelFunctions.getGraphSettings();
        this.initStates(graphSettings);
        graphSettings.addListener(this.settingsListener);
    }

    private void initStates(GraphSettings graphSettings) {
        switch (graphSettings.getDiffViewMode()) {
            case NORMAL_VIEW: {
                this.normalViewMode.setSelected(true);
                break;
            }
            case COMBINED_VIEW: {
                this.combinedViewMode.setSelected(true);
                break;
            }
        }
        this.automaticLayout.setSelected(graphSettings.getLayoutSettings().getAutomaticLayouting());
        this.proximityBrowsing.setSelected(graphSettings.getProximitySettings().getProximityBrowsing());
        this.proximityFreezeMode.setSelected(graphSettings.getProximitySettings().getProximityBrowsingFrozen());
        this.synchronizeGraphs.setSelected(graphSettings.getGraphSyncMode() == EGraphSynchronization.SYNC);
    }

    public void dispose() {
        this.controller.getGraphSettings().removeListener(this.settingsListener);
        this.settingsListener = null;
        this.controller = null;
        this.normalViewMode = null;
        this.combinedViewMode = null;
        this.synchronizeGraphs = null;
        this.automaticLayout = null;
        this.proximityBrowsing = null;
        this.proximityFreezeMode = null;
    }

    private class InternalSettingsListener
    extends GraphSettingsChangedListenerAdapter {
        private InternalSettingsListener() {
        }

        @Override
        public void autoLayoutChanged(GraphLayoutSettings graphLayoutSettings) {
            ModesMenu.this.automaticLayout.setSelected(graphLayoutSettings.getAutomaticLayouting());
        }

        @Override
        public void diffViewModeChanged(GraphSettings graphSettings) {
            switch (graphSettings.getDiffViewMode()) {
                case NORMAL_VIEW: {
                    ModesMenu.this.normalViewMode.setSelected(true);
                    break;
                }
                case COMBINED_VIEW: {
                    ModesMenu.this.combinedViewMode.setSelected(true);
                    break;
                }
            }
        }

        @Override
        public void graphSyncChanged(GraphSettings graphSettings) {
            ModesMenu.this.synchronizeGraphs.setSelected(graphSettings.getGraphSyncMode() == EGraphSynchronization.SYNC);
        }

        @Override
        public void proximityBrowsingChanged(GraphProximityBrowsingSettings graphProximityBrowsingSettings) {
            ModesMenu.this.proximityBrowsing.setSelected(graphProximityBrowsingSettings.getProximityBrowsing());
        }

        @Override
        public void proximityBrowsingFrozenChanged(GraphProximityBrowsingSettings graphProximityBrowsingSettings) {
            ModesMenu.this.proximityFreezeMode.setSelected(graphProximityBrowsingSettings.getProximityBrowsingFrozen());
        }
    }
}

