/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.menubar;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EDiffViewMode;
import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.ZoomInAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.ZoomOutAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.AddNodeMatchAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.CircularGraphLayoutAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.DeleteNodeMatchAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.FitGraphContentAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.HierarchicalGraphLayoutAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.OrthogonalGraphLayoutAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.ShowGraphSettingsDialogAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.ZoomToSelectedAction;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphSelectionListener;
import java.awt.Toolkit;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class GraphsMenu
extends JMenu {
    private JMenuItem graphSettings;
    private JMenuItem HierarchicalLayout;
    private JMenuItem orthogonalLayout;
    private JMenuItem circularLayout;
    private JMenuItem fitContent;
    private JMenuItem zoomToSelected;
    private final JMenuItem zoomIn;
    private final JMenuItem zoomOut;
    private JMenuItem deleteMatch;
    private JMenuItem addMatch;
    private ViewTabPanelFunctions controller;
    private InternalGraphSelectionListener listener = new InternalGraphSelectionListener();

    public GraphsMenu(ViewTabPanelFunctions viewTabPanelFunctions) {
        super("Graphs");
        this.controller = Preconditions.checkNotNull(viewTabPanelFunctions);
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        viewTabPanelFunctions.getGraphs().getPrimaryGraph().getIntermediateListeners().addIntermediateListener(this.listener);
        viewTabPanelFunctions.getGraphs().getSecondaryGraph().getIntermediateListeners().addIntermediateListener(this.listener);
        viewTabPanelFunctions.getGraphs().getCombinedGraph().getIntermediateListeners().addIntermediateListener(this.listener);
        this.setMnemonic('G');
        this.graphSettings = GuiUtils.buildMenuItem("Graph Settings", 'G', 113, 0, new ShowGraphSettingsDialogAction(viewTabPanelFunctions));
        this.HierarchicalLayout = GuiUtils.buildMenuItem("Hierarchical Layout", 'H', 72, n2 | 0x40, new HierarchicalGraphLayoutAction(viewTabPanelFunctions));
        this.orthogonalLayout = GuiUtils.buildMenuItem("Orthogonal Layout", 'L', 79, n2 | 0x40, new OrthogonalGraphLayoutAction(viewTabPanelFunctions));
        this.circularLayout = GuiUtils.buildMenuItem("Circular Layout", 'C', 67, n2 | 0x40, new CircularGraphLayoutAction(viewTabPanelFunctions));
        this.fitContent = GuiUtils.buildMenuItem("Fit Graph", 'F', 77, n2 | 0x40, new FitGraphContentAction(viewTabPanelFunctions));
        this.zoomToSelected = GuiUtils.buildMenuItem("Zoom to Selected", 'Z', 83, n2 | 0x40, new ZoomToSelectedAction(viewTabPanelFunctions));
        this.zoomIn = GuiUtils.buildMenuItem("Zoom in", 'I', 521, n2, new ZoomInAction(viewTabPanelFunctions));
        this.zoomOut = GuiUtils.buildMenuItem("Zoom out", 'O', 45, n2, new ZoomOutAction(viewTabPanelFunctions));
        this.deleteMatch = GuiUtils.buildMenuItem("Delete Matches", 'D', (AbstractAction)new DeleteNodeMatchAction(viewTabPanelFunctions));
        this.addMatch = GuiUtils.buildMenuItem("Add Match", 'A', (AbstractAction)new AddNodeMatchAction(viewTabPanelFunctions));
        this.add(this.graphSettings);
        this.add(new JSeparator());
        this.add(this.HierarchicalLayout);
        this.add(this.orthogonalLayout);
        this.add(this.circularLayout);
        this.add(new JSeparator());
        this.add(this.fitContent);
        this.add(this.zoomToSelected);
        this.add(this.zoomIn);
        this.add(this.zoomOut);
        this.add(new JSeparator());
        this.add(this.deleteMatch);
        this.add(this.addMatch);
        this.addMatch.setEnabled(false);
        this.deleteMatch.setEnabled(false);
    }

    public void dispose() {
        this.controller.getGraphs().getPrimaryGraph().getIntermediateListeners().removeIntermediateListener(this.listener);
        this.controller.getGraphs().getSecondaryGraph().getIntermediateListeners().removeIntermediateListener(this.listener);
        this.controller.getGraphs().getCombinedGraph().getIntermediateListeners().removeIntermediateListener(this.listener);
        this.controller = null;
        this.listener = null;
        this.graphSettings = null;
        this.HierarchicalLayout = null;
        this.orthogonalLayout = null;
        this.circularLayout = null;
        this.fitContent = null;
        this.zoomToSelected = null;
        this.deleteMatch = null;
        this.addMatch = null;
    }

    private class InternalGraphSelectionListener
    implements IZyGraphSelectionListener {
        private InternalGraphSelectionListener() {
        }

        private int countSelectedMatchedNodes(CombinedGraph combinedGraph) {
            int n2 = 0;
            for (CombinedDiffNode combinedDiffNode : combinedGraph.getSelectedNodes()) {
                if (combinedDiffNode.getRawNode().getMatchState() != EMatchState.MATCHED) continue;
                ++n2;
            }
            return n2;
        }

        private int countSelectedNodes(SingleGraph singleGraph, boolean bl2) {
            int n2 = 0;
            for (SingleDiffNode singleDiffNode : singleGraph.getSelectedNodes()) {
                if (bl2 && singleDiffNode.getRawNode().getMatchState() == EMatchState.MATCHED) {
                    ++n2;
                    continue;
                }
                if (bl2 || singleDiffNode.getRawNode().getMatchState() == EMatchState.MATCHED) continue;
                ++n2;
            }
            return n2;
        }

        private int countSelectedUnmatchedNodes(CombinedGraph combinedGraph, ESide eSide) {
            int n2 = 0;
            for (CombinedDiffNode combinedDiffNode : combinedGraph.getSelectedNodes()) {
                if (eSide == ESide.PRIMARY && combinedDiffNode.getRawNode().getMatchState() == EMatchState.PRIMARY_UNMATCHED) {
                    ++n2;
                    continue;
                }
                if (eSide != ESide.SECONDARY || combinedDiffNode.getRawNode().getMatchState() == EMatchState.SECONDRAY_UNMATCHED) continue;
                ++n2;
            }
            return n2;
        }

        @Override
        public void selectionChanged() {
            GraphsContainer graphsContainer = GraphsMenu.this.controller.getGraphs();
            boolean bl2 = false;
            boolean bl3 = false;
            if (graphsContainer.getPrimaryGraph().getNodes().size() != 0 && graphsContainer.getSecondaryGraph().getNodes().size() != 0) {
                if (GraphsMenu.this.controller.getGraphSettings().getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
                    bl2 = this.countSelectedNodes(graphsContainer.getPrimaryGraph(), false) == 1 && this.countSelectedNodes(graphsContainer.getSecondaryGraph(), false) == 1;
                    bl3 = this.countSelectedNodes(graphsContainer.getPrimaryGraph(), true) > 0 || this.countSelectedNodes(graphsContainer.getSecondaryGraph(), true) > 0;
                } else if (GraphsMenu.this.controller.getGraphSettings().getDiffViewMode() == EDiffViewMode.COMBINED_VIEW) {
                    CombinedGraph combinedGraph = graphsContainer.getCombinedGraph();
                    bl2 = this.countSelectedUnmatchedNodes(combinedGraph, ESide.PRIMARY) == 1 && this.countSelectedUnmatchedNodes(combinedGraph, ESide.SECONDARY) == 1;
                    bl3 = this.countSelectedMatchedNodes(combinedGraph) > 0;
                }
            }
            GraphsMenu.this.addMatch.setEnabled(bl2);
            GraphsMenu.this.deleteMatch.setEnabled(bl3);
        }
    }
}

