/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.single.flowgraph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EFunctionType;
import com.google.security.zynamics.bindiff.enums.EMatchState;
import com.google.security.zynamics.bindiff.enums.EMatchType;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.searcher.ISearchableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.sorter.ISortableTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.AbstractTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.helper.MouseTreeNodeSelectionHandlerSingleBasicBlock;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.graphnodetree.treenodes.single.flowgraph.SingleFlowGraphRootTreeNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.popupmenus.FlowGraphPopupMenu;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.matches.BasicBlockMatchData;
import com.google.security.zynamics.bindiff.project.matches.FunctionMatchData;
import com.google.security.zynamics.bindiff.project.matches.MatchData;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.bindiff.project.userview.FlowGraphViewData;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class SingleFlowGraphBasicBlockTreeNode
extends AbstractTreeNode
implements ISearchableTreeNode,
ISortableTreeNode {
    private static final Icon MATCHED_BASICBLOCK = ImageUtils.getImageIcon("data/treeicons/matched-basicblock.png");
    private static final Icon CHANGED_BASICBLOCK = ImageUtils.getImageIcon("data/treeicons/changed-basicblock.png");
    private static final Icon PRIMARY_UNMATCHED_BASICBLOCK = ImageUtils.getImageIcon("data/treeicons/primary-unmatched-basicblock.png");
    private static final Icon SECONDARY_UNMATCHED_BASICBLOCK = ImageUtils.getImageIcon("data/treeicons/secondary-unmatched-basicblock.png");
    private static final Icon MATCHED_BASICBLOCK_SELECTED = ImageUtils.getImageIcon("data/treeicons/matched-selected-basicblock.png");
    private static final Icon CHANGED_BASICBLOCK_SELECTED = ImageUtils.getImageIcon("data/treeicons/changed-selected-basicblock.png");
    private static final Icon PRIMARY_UNMATCHED_BASICBLOCK_SELECTED = ImageUtils.getImageIcon("data/treeicons/primary-unmatched-selected-basicblock.png");
    private static final Icon SECONDARY_UNMATCHED_BASICBLOCK_SELECTED = ImageUtils.getImageIcon("data/treeicons/secondary-unmatched-selected-basicblock.png");
    private static final Icon MATCHED_BASICBLOCK_INVISIBLE = ImageUtils.getImageIcon("data/treeicons/matched-invisible-basicblock.png");
    private static final Icon CHANGED_BASICBLOCK_INVISIBLE = ImageUtils.getImageIcon("data/treeicons/changed-invisible-basicblock.png");
    private static final Icon PRIMARY_UNMATCHED_BASICBLOCK_INVISIBLE = ImageUtils.getImageIcon("data/treeicons/primary-unmatched-invisible-basicblock.png");
    private static final Icon SECONDARY_UNMATCHED_BASICBLOCK_INVISIBLE = ImageUtils.getImageIcon("data/treeicons/secondary-unmatched-invisible-basicblock.png");
    private final SingleDiffNode singleDiffNode;
    private final RawBasicBlock rawBasicblock;

    public SingleFlowGraphBasicBlockTreeNode(SingleFlowGraphRootTreeNode singleFlowGraphRootTreeNode, SingleDiffNode singleDiffNode) {
        super(singleFlowGraphRootTreeNode);
        this.singleDiffNode = Preconditions.checkNotNull(singleDiffNode);
        this.rawBasicblock = (RawBasicBlock)this.singleDiffNode.getRawNode();
        this.createChildren();
    }

    private boolean isChangedBasicblock() {
        Diff diff = this.getDiff();
        EMatchState eMatchState = this.getMatchState();
        if (eMatchState == EMatchState.PRIMARY_UNMATCHED || eMatchState == EMatchState.SECONDRAY_UNMATCHED) {
            return false;
        }
        MatchData matchData = diff.getMatches();
        if (this.rawBasicblock.getSide() == ESide.PRIMARY) {
            IAddress iAddress;
            IAddress iAddress2;
            FunctionMatchData functionMatchData;
            IAddress iAddress3 = this.rawBasicblock.getFunctionAddr();
            IAddress iAddress4 = matchData.getSecondaryFunctionAddr(iAddress3);
            if (iAddress4 != null && (functionMatchData = matchData.getFunctionMatch(iAddress3, ESide.PRIMARY)) != null && functionMatchData.isBasicblockMatch(iAddress2 = this.rawBasicblock.getAddress(), iAddress = functionMatchData.getSecondaryBasicblockAddr(iAddress2))) {
                RawBasicBlock rawBasicBlock = ((FlowGraphViewData)this.getView()).getRawGraph(ESide.SECONDARY).getBasicblock(iAddress);
                BasicBlockMatchData basicBlockMatchData = functionMatchData.getBasicBlockMatch(iAddress2, ESide.PRIMARY);
                if (basicBlockMatchData != null) {
                    int n2 = basicBlockMatchData.getSizeOfMatchedInstructions();
                    return this.rawBasicblock.getInstructions().size() > n2 || rawBasicBlock.getInstructions().size() > n2;
                }
            }
        } else {
            IAddress iAddress;
            IAddress iAddress5;
            FunctionMatchData functionMatchData;
            IAddress iAddress6 = this.rawBasicblock.getFunctionAddr();
            IAddress iAddress7 = matchData.getPrimaryFunctionAddr(iAddress6);
            if (iAddress7 != null && (functionMatchData = matchData.getFunctionMatch(iAddress7, ESide.PRIMARY)) != null && functionMatchData.isBasicblockMatch(iAddress5 = functionMatchData.getPrimaryBasicblockAddr(iAddress = this.rawBasicblock.getAddress()), iAddress)) {
                RawBasicBlock rawBasicBlock = ((FlowGraphViewData)this.getView()).getRawGraph(ESide.PRIMARY).getBasicblock(iAddress5);
                BasicBlockMatchData basicBlockMatchData = functionMatchData.getBasicBlockMatch(iAddress5, ESide.PRIMARY);
                if (basicBlockMatchData != null) {
                    int n3 = basicBlockMatchData.getSizeOfMatchedInstructions();
                    return this.rawBasicblock.getInstructions().size() > n3 || rawBasicBlock.getInstructions().size() > n3;
                }
            }
        }
        return false;
    }

    @Override
    public void createChildren() {
    }

    @Override
    public IAddress getAddress() {
        return this.rawBasicblock.getAddress();
    }

    @Override
    public IAddress getAddress(ESide eSide) {
        return this.rawBasicblock.getSide() == eSide ? this.rawBasicblock.getAddress() : null;
    }

    public RawBasicBlock getBasicblock() {
        return this.rawBasicblock;
    }

    @Override
    public String getFunctionName() {
        return this.rawBasicblock.getFunctionName();
    }

    @Override
    public EFunctionType getFunctionType() {
        return null;
    }

    @Override
    public ZyGraphNode<?> getGraphNode() {
        return this.singleDiffNode;
    }

    @Override
    public ZyGraphNode<?> getGraphNode(ESide eSide) {
        if (this.singleDiffNode.getSide() != eSide) {
            return null;
        }
        return this.singleDiffNode;
    }

    @Override
    public Icon getIcon() {
        switch (this.getMatchState()) {
            case MATCHED: {
                if (!this.isChangedBasicblock()) {
                    if (this.isSelected()) {
                        return MATCHED_BASICBLOCK_SELECTED;
                    }
                    if (!this.isVisible()) {
                        return MATCHED_BASICBLOCK_INVISIBLE;
                    }
                    return MATCHED_BASICBLOCK;
                }
                if (this.isSelected()) {
                    return CHANGED_BASICBLOCK_SELECTED;
                }
                if (!this.isVisible()) {
                    return CHANGED_BASICBLOCK_INVISIBLE;
                }
                return CHANGED_BASICBLOCK;
            }
            case PRIMARY_UNMATCHED: {
                if (this.isSelected()) {
                    return PRIMARY_UNMATCHED_BASICBLOCK_SELECTED;
                }
                if (!this.isVisible()) {
                    return PRIMARY_UNMATCHED_BASICBLOCK_INVISIBLE;
                }
                return PRIMARY_UNMATCHED_BASICBLOCK;
            }
            case SECONDRAY_UNMATCHED: {
                if (this.isSelected()) {
                    return SECONDARY_UNMATCHED_BASICBLOCK_SELECTED;
                }
                if (!this.isVisible()) {
                    return SECONDARY_UNMATCHED_BASICBLOCK_INVISIBLE;
                }
                return SECONDARY_UNMATCHED_BASICBLOCK;
            }
        }
        throw new IllegalStateException("Unknown match type.");
    }

    @Override
    public EMatchState getMatchState() {
        return this.rawBasicblock.getMatchState();
    }

    @Override
    public EMatchType getMatchType() {
        if (this.getMatchState() == EMatchState.MATCHED) {
            if (this.isChangedBasicblock()) {
                return EMatchType.INSTRUCTIONS_CHANGED;
            }
            return EMatchType.IDENTICAL;
        }
        return EMatchType.UNUMATCHED;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return new FlowGraphPopupMenu(this.getRootNode().getController(), this.getGraph(), this.singleDiffNode);
    }

    @Override
    public SingleFlowGraphRootTreeNode getRootNode() {
        return (SingleFlowGraphRootTreeNode)this.getAbstractRootNode();
    }

    public SingleDiffNode getSingleDiffNode() {
        return this.singleDiffNode;
    }

    @Override
    public String getTooltipText() {
        return null;
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
            MouseTreeNodeSelectionHandlerSingleBasicBlock.handleMouseSelectionEvent(mouseEvent, this);
        }
        super.handleMouseEvent(mouseEvent);
    }

    @Override
    public boolean isSelected() {
        return this.rawBasicblock.isSelected();
    }

    @Override
    public boolean isVisible() {
        return this.rawBasicblock.isVisible();
    }

    @Override
    public String toString() {
        return this.rawBasicblock.getAddress().toHexString();
    }
}

